# Generated by Django 3.2.12 on 2022-02-21 13:46

import django.core.validators
from django.db import migrations, models
import django.utils.timezone
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('djstarter', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Task',
            fields=[
                ('oid', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('scheduled_at', models.DateTimeField(default=django.utils.timezone.now)),
                ('started_at', models.DateTimeField(blank=True, null=True)),
                ('ended_at', models.DateTimeField(blank=True, null=True)),
                ('status', models.IntegerField(choices=[(0, 'INIT'), (1, 'RUNNING'), (2, 'ERROR'), (3, 'FINISHED'), (4, 'STOPPING'), (5, 'STOPPED'), (6, 'CANCELLED'), (7, 'SCHEDULED')], db_index=True, default=0)),
                ('action_count', models.IntegerField(default=0)),
                ('target_action_count', models.IntegerField(default=1, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(200)])),
                ('thread_count', models.IntegerField(default=1, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(10)])),
                ('parameters', models.JSONField(default=dict)),
                ('results', models.JSONField(default=dict)),
            ],
            options={
                'db_table': 'core_task',
                'ordering': ['-created'],
            },
        ),
    ]
