# -*- coding: utf-8 -*-
# Generated by Django 1.10 on 2016-08-02 10:48
from __future__ import unicode_literals

import django.contrib.postgres.fields
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='SurveyField',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('help_text', models.CharField(blank=True, max_length=255)),
                ('field_type', models.CharField(choices=[('free_text', 'Character field (free text)'), ('number', 'Number'), ('percentage', 'Percentage slider'), ('radio', 'Choose one option'), ('checkbox', 'Choose one or more options')], default='free_text', max_length=255)),
                ('answers', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=255), default=[], help_text='For choice fields only. Enter one or more answers, separated by newlines.', size=None)),
            ],
        ),
        migrations.CreateModel(
            name='SurveyFieldOrdering',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, db_index=True)),
                ('field', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='surveys.SurveyField')),
            ],
        ),
        migrations.CreateModel(
            name='SurveyFieldset',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sort_order', models.IntegerField(blank=True, db_index=True)),
                ('name', models.CharField(max_length=255)),
                ('fields', models.ManyToManyField(related_name='fieldsets', through='surveys.SurveyFieldOrdering', to='surveys.SurveyField')),
            ],
            options={
                'abstract': False,
                'ordering': ['sort_order'],
            },
        ),
        migrations.CreateModel(
            name='UserResponse',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('user_id', models.CharField(max_length=255)),
                ('answers', django.contrib.postgres.fields.jsonb.JSONField()),
                ('fieldset', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='surveys.SurveyFieldset')),
            ],
        ),
        migrations.AddField(
            model_name='surveyfieldordering',
            name='fieldset',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='surveys.SurveyFieldset'),
        ),
        migrations.AlterUniqueTogether(
            name='userresponse',
            unique_together=set([('fieldset', 'user_id')]),
        ),
        migrations.AlterUniqueTogether(
            name='surveyfieldordering',
            unique_together=set([('field', 'fieldset')]),
        ),
    ]
