# -*- coding: utf-8 -*-
# Generated by Django 1.10.2 on 2016-10-18 08:09
from __future__ import unicode_literals

import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('surveys', '0010_orderable-ordering'),
    ]

    operations = [
        migrations.CreateModel(
            name='SurveyFieldsetTranslation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language_code', models.CharField(db_index=True, max_length=15, verbose_name='Language')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('description', models.TextField(blank=True)),
            ],
            options={
                'default_permissions': (),
                'db_tablespace': '',
                'verbose_name': 'survey fieldset Translation',
                'managed': True,
                'db_table': 'surveys_surveyfieldset_translation',
            },
        ),
        migrations.CreateModel(
            name='SurveyFieldTranslation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language_code', models.CharField(db_index=True, max_length=15, verbose_name='Language')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('answers', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=255), blank=True, default=[], help_text='For choice fields only. Enter one or more answers, separated by newlines.', size=None)),
                ('help_text', models.CharField(blank=True, max_length=255)),
            ],
            options={
                'default_permissions': (),
                'db_tablespace': '',
                'verbose_name': 'survey field Translation',
                'managed': True,
                'db_table': 'surveys_surveyfield_translation',
            },
        ),
        migrations.CreateModel(
            name='SurveyTranslation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language_code', models.CharField(db_index=True, max_length=15, verbose_name='Language')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('description', models.TextField(blank=True)),
            ],
            options={
                'default_permissions': (),
                'db_tablespace': '',
                'verbose_name': 'survey Translation',
                'managed': True,
                'db_table': 'surveys_survey_translation',
            },
        ),
        migrations.AddField(
            model_name='surveytranslation',
            name='master',
            field=models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='translations', to='surveys.Survey'),
        ),
        migrations.AddField(
            model_name='surveyfieldtranslation',
            name='master',
            field=models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='translations', to='surveys.SurveyField'),
        ),
        migrations.AddField(
            model_name='surveyfieldsettranslation',
            name='master',
            field=models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='translations', to='surveys.SurveyFieldset'),
        ),
        migrations.AlterUniqueTogether(
            name='surveytranslation',
            unique_together=set([('language_code', 'master')]),
        ),
        migrations.AlterUniqueTogether(
            name='surveyfieldtranslation',
            unique_together=set([('language_code', 'master')]),
        ),
        migrations.AlterUniqueTogether(
            name='surveyfieldsettranslation',
            unique_together=set([('language_code', 'master')]),
        ),
    ]
