# -*- coding: utf-8 -*-
# Generated by Django 1.10.2 on 2016-10-18 08:10
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations
from django.core.exceptions import ObjectDoesNotExist

# from http://django-parler.readthedocs.io/en/latest/advanced/migrating.html
# with some work to make it generic


def move_to_translation(apps, app, model, fields):
    Model = apps.get_model(app, model)
    Translation = apps.get_model(app, model + 'Translation')
    for model_object in Model.objects.all():
        data = {
            'language_code': settings.LANGUAGE_CODE,
            'master_id': model_object.pk,
        }
        for field in fields:
            data.update({field: getattr(model_object, field)})
        Translation.objects.create(**data)


def move_data_from_translation(apps, app, model, fields):
    Translation = apps.get_model(app, model + 'Translation')
    Model = apps.get_model(app, model)
    for model_object in Model.objects.all():
        translation = _get_translation(model_object, Translation)
        for field in fields:
            setattr(model_object, field, getattr(translation, field))
            model_object.save()


def _get_translation(model_object, TranslationModel):  # pragma: no cover
    translations = TranslationModel.objects.filter(master_id=model_object.pk)
    try:
        # Try default translation
        return translations.get(language_code=settings.LANGUAGE_CODE)
    except ObjectDoesNotExist:
        try:
            # Try default language
            return translations.get(
                language_code=settings.PARLER_DEFAULT_LANGUAGE_CODE
            )
        except ObjectDoesNotExist:
            # Maybe the object was translated only in a specific language?
            # Hope there is a single translation
            return translations.get()

app = 'surveys'


def move_data(apps, schema):
    move_to_translation(apps, app, 'Survey', fields=['name', 'description'])
    move_to_translation(apps, app, 'SurveyField', fields=['name', 'help_text', 'answers'])
    move_to_translation(apps, app, 'SurveyFieldSet', fields=['name', 'description'])


def move_data_back(apps, schema):
    move_data_from_translation(apps, app, 'Survey', fields=['name', 'description'])
    move_data_from_translation(apps, app, 'SurveyField', fields=['name', 'help_text', 'answers'])
    move_data_from_translation(apps, app, 'SurveyFieldSet', fields=['name', 'description'])


class Migration(migrations.Migration):

    dependencies = [
        ('surveys', '0011_create_translation_models'),
    ]

    operations = [
        migrations.RunPython(move_data, move_data_back)
    ]
