"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnReplicaKey = exports.CfnKey = exports.CfnAlias = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2022-07-13T21:25:30.775Z","fingerprint":"bZc1QTc/Zb1MHB1uTRyWoQAIA9scEXB21U38YMOaymI="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("@aws-cdk/core");
const cfn_parse = require("@aws-cdk/core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnAliasProps`
 *
 * @param properties - the TypeScript properties of a `CfnAliasProps`
 *
 * @returns the result of the validation.
 */
function CfnAliasPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('aliasName', cdk.requiredValidator)(properties.aliasName));
    errors.collect(cdk.propertyValidator('aliasName', cdk.validateString)(properties.aliasName));
    errors.collect(cdk.propertyValidator('targetKeyId', cdk.requiredValidator)(properties.targetKeyId));
    errors.collect(cdk.propertyValidator('targetKeyId', cdk.validateString)(properties.targetKeyId));
    return errors.wrap('supplied properties not correct for "CfnAliasProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KMS::Alias` resource
 *
 * @param properties - the TypeScript properties of a `CfnAliasProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KMS::Alias` resource.
 */
// @ts-ignore TS6133
function cfnAliasPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAliasPropsValidator(properties).assertSuccess();
    return {
        AliasName: cdk.stringToCloudFormation(properties.aliasName),
        TargetKeyId: cdk.stringToCloudFormation(properties.targetKeyId),
    };
}
// @ts-ignore TS6133
function CfnAliasPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('aliasName', 'AliasName', cfn_parse.FromCloudFormation.getString(properties.AliasName));
    ret.addPropertyResult('targetKeyId', 'TargetKeyId', cfn_parse.FromCloudFormation.getString(properties.TargetKeyId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::KMS::Alias`
 *
 * The `AWS::KMS::Alias` resource specifies a display name for a [KMS key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#kms_keys) . You can use an alias to identify a KMS key in the AWS KMS console, in the [DescribeKey](https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html) operation, and in [cryptographic operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations) , such as [Decrypt](https://docs.aws.amazon.com/kms/latest/APIReference/API_Decrypt.html) and [GenerateDataKey](https://docs.aws.amazon.com/kms/latest/APIReference/API_GenerateDataKey.html) .
 *
 * > Adding, deleting, or updating an alias can allow or deny permission to the KMS key. For details, see [ABAC for AWS KMS](https://docs.aws.amazon.com/kms/latest/developerguide/abac.html) in the *AWS Key Management Service Developer Guide* .
 *
 * Using an alias to refer to a KMS key can help you simplify key management. For example, an alias in your code can be associated with different KMS keys in different AWS Regions . For more information, see [Using aliases](https://docs.aws.amazon.com/kms/latest/developerguide/kms-alias.html) in the *AWS Key Management Service Developer Guide* .
 *
 * When specifying an alias, observe the following rules.
 *
 * - Each alias is associated with one KMS key, but multiple aliases can be associated with the same KMS key.
 * - The alias and its associated KMS key must be in the same AWS account and Region.
 * - The alias name must be unique in the AWS account and Region. However, you can create aliases with the same name in different AWS Regions . For example, you can have an `alias/projectKey` in multiple Regions, each of which is associated with a KMS key in its Region.
 * - Each alias name must begin with `alias/` followed by a name, such as `alias/exampleKey` . The alias name can contain only alphanumeric characters, forward slashes (/), underscores (_), and dashes (-). Alias names cannot begin with `alias/aws/` . That alias name prefix is reserved for [AWS managed keys](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk) .
 *
 * @cloudformationResource AWS::KMS::Alias
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-alias.html
 */
class CfnAlias extends cdk.CfnResource {
    /**
     * Create a new `AWS::KMS::Alias`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnAlias.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_kms_CfnAliasProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnAlias);
            }
            throw error;
        }
        cdk.requireProperty(props, 'aliasName', this);
        cdk.requireProperty(props, 'targetKeyId', this);
        this.aliasName = props.aliasName;
        this.targetKeyId = props.targetKeyId;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnAliasPropsFromCloudFormation(resourceProperties);
        const ret = new CfnAlias(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnAlias.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            aliasName: this.aliasName,
            targetKeyId: this.targetKeyId,
        };
    }
    renderProperties(props) {
        return cfnAliasPropsToCloudFormation(props);
    }
}
exports.CfnAlias = CfnAlias;
_a = JSII_RTTI_SYMBOL_1;
CfnAlias[_a] = { fqn: "@aws-cdk/aws-kms.CfnAlias", version: "1.163.2" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnAlias.CFN_RESOURCE_TYPE_NAME = "AWS::KMS::Alias";
/**
 * Determine whether the given properties match those of a `CfnKeyProps`
 *
 * @param properties - the TypeScript properties of a `CfnKeyProps`
 *
 * @returns the result of the validation.
 */
function CfnKeyPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('enableKeyRotation', cdk.validateBoolean)(properties.enableKeyRotation));
    errors.collect(cdk.propertyValidator('enabled', cdk.validateBoolean)(properties.enabled));
    errors.collect(cdk.propertyValidator('keyPolicy', cdk.requiredValidator)(properties.keyPolicy));
    errors.collect(cdk.propertyValidator('keyPolicy', cdk.validateObject)(properties.keyPolicy));
    errors.collect(cdk.propertyValidator('keySpec', cdk.validateString)(properties.keySpec));
    errors.collect(cdk.propertyValidator('keyUsage', cdk.validateString)(properties.keyUsage));
    errors.collect(cdk.propertyValidator('multiRegion', cdk.validateBoolean)(properties.multiRegion));
    errors.collect(cdk.propertyValidator('pendingWindowInDays', cdk.validateNumber)(properties.pendingWindowInDays));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnKeyProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KMS::Key` resource
 *
 * @param properties - the TypeScript properties of a `CfnKeyProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KMS::Key` resource.
 */
// @ts-ignore TS6133
function cfnKeyPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnKeyPropsValidator(properties).assertSuccess();
    return {
        KeyPolicy: cdk.objectToCloudFormation(properties.keyPolicy),
        Description: cdk.stringToCloudFormation(properties.description),
        Enabled: cdk.booleanToCloudFormation(properties.enabled),
        EnableKeyRotation: cdk.booleanToCloudFormation(properties.enableKeyRotation),
        KeySpec: cdk.stringToCloudFormation(properties.keySpec),
        KeyUsage: cdk.stringToCloudFormation(properties.keyUsage),
        MultiRegion: cdk.booleanToCloudFormation(properties.multiRegion),
        PendingWindowInDays: cdk.numberToCloudFormation(properties.pendingWindowInDays),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnKeyPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('keyPolicy', 'KeyPolicy', cfn_parse.FromCloudFormation.getAny(properties.KeyPolicy));
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('enabled', 'Enabled', properties.Enabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Enabled) : undefined);
    ret.addPropertyResult('enableKeyRotation', 'EnableKeyRotation', properties.EnableKeyRotation != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableKeyRotation) : undefined);
    ret.addPropertyResult('keySpec', 'KeySpec', properties.KeySpec != null ? cfn_parse.FromCloudFormation.getString(properties.KeySpec) : undefined);
    ret.addPropertyResult('keyUsage', 'KeyUsage', properties.KeyUsage != null ? cfn_parse.FromCloudFormation.getString(properties.KeyUsage) : undefined);
    ret.addPropertyResult('multiRegion', 'MultiRegion', properties.MultiRegion != null ? cfn_parse.FromCloudFormation.getBoolean(properties.MultiRegion) : undefined);
    ret.addPropertyResult('pendingWindowInDays', 'PendingWindowInDays', properties.PendingWindowInDays != null ? cfn_parse.FromCloudFormation.getNumber(properties.PendingWindowInDays) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::KMS::Key`
 *
 * The `AWS::KMS::Key` resource specifies an [KMS key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#kms_keys) in AWS Key Management Service . You can use this resource to create symmetric encryption KMS keys, asymmetric KMS keys for encryption or signing, and symmetric HMAC KMS keys. You can use `AWS::KMS::Key` to create [multi-Region primary keys](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html#mrk-primary-key) of all supported types. To replicate a multi-Region key, use the `AWS::KMS::ReplicaKey` resource.
 *
 * You cannot use the `AWS::KMS::Key` resource to specify a KMS key with [imported key material](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html) or a KMS key in a [custom key store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html) .
 *
 * > AWS KMS replaced the term *customer master key (CMK)* with *AWS KMS key* and *KMS key* . The concept has not changed. To prevent breaking changes, AWS KMS is keeping some variations of this term.
 *
 * You can use symmetric encryption KMS keys to encrypt and decrypt small amounts of data, but they are more commonly used to generate data keys and data key pairs. You can also use a symmetric encryption KMS key to encrypt data stored in AWS services that are [integrated with AWS KMS](https://docs.aws.amazon.com//kms/features/#AWS_Service_Integration) . For more information, see [Symmetric encryption KMS keys](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#symmetric-cmks) in the *AWS Key Management Service Developer Guide* .
 *
 * You can use asymmetric KMS keys to encrypt and decrypt data or sign messages and verify signatures. To create an asymmetric key, you must specify an asymmetric `KeySpec` value and a `KeyUsage` value. For details, see [Asymmetric keys in AWS KMS](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html) in the *AWS Key Management Service Developer Guide* .
 *
 * You can use HMAC KMS keys (which are also symmetric keys) to generate and verify hash-based message authentication codes. To create an HMAC key, you must specify an HMAC `KeySpec` value and a `KeyUsage` value of `GENERATE_VERIFY_MAC` . For details, see [HMAC keys in AWS KMS](https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html) in the *AWS Key Management Service Developer Guide* .
 *
 * You can also create symmetric encryption, asymmetric, and HMAC multi-Region primary keys. To create a multi-Region primary key, set the `MultiRegion` property to `true` . For information about multi-Region keys, see [Multi-Region keys in AWS KMS](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html) in the *AWS Key Management Service Developer Guide* .
 *
 * > If you change the value of the `KeyUsage` , `KeySpec` , or `MultiRegion` property on an existing KMS key, the existing KMS key is [scheduled for deletion](https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html) and a new KMS key is created with the specified value.
 * >
 * > While scheduled for deletion, the existing KMS key becomes unusable. If you don't [cancel the scheduled deletion](https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html#deleting-keys-scheduling-key-deletion) of the existing KMS key outside of CloudFormation, all data encrypted under the existing KMS key becomes unrecoverable when the KMS key is deleted.
 *
 * *Regions*
 *
 * AWS KMS CloudFormation resources are supported in all Regions in which AWS CloudFormation is supported. However, in the  (ap-southeast-3), you cannot use a CloudFormation template to create or manage asymmetric KMS keys or multi-Region KMS keys (primary or replica).
 *
 * @cloudformationResource AWS::KMS::Key
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html
 */
class CfnKey extends cdk.CfnResource {
    /**
     * Create a new `AWS::KMS::Key`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnKey.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_kms_CfnKeyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnKey);
            }
            throw error;
        }
        cdk.requireProperty(props, 'keyPolicy', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrKeyId = cdk.Token.asString(this.getAtt('KeyId'));
        this.keyPolicy = props.keyPolicy;
        this.description = props.description;
        this.enabled = props.enabled;
        this.enableKeyRotation = props.enableKeyRotation;
        this.keySpec = props.keySpec;
        this.keyUsage = props.keyUsage;
        this.multiRegion = props.multiRegion;
        this.pendingWindowInDays = props.pendingWindowInDays;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::KMS::Key", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnKeyPropsFromCloudFormation(resourceProperties);
        const ret = new CfnKey(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnKey.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            keyPolicy: this.keyPolicy,
            description: this.description,
            enabled: this.enabled,
            enableKeyRotation: this.enableKeyRotation,
            keySpec: this.keySpec,
            keyUsage: this.keyUsage,
            multiRegion: this.multiRegion,
            pendingWindowInDays: this.pendingWindowInDays,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnKeyPropsToCloudFormation(props);
    }
}
exports.CfnKey = CfnKey;
_b = JSII_RTTI_SYMBOL_1;
CfnKey[_b] = { fqn: "@aws-cdk/aws-kms.CfnKey", version: "1.163.2" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnKey.CFN_RESOURCE_TYPE_NAME = "AWS::KMS::Key";
/**
 * Determine whether the given properties match those of a `CfnReplicaKeyProps`
 *
 * @param properties - the TypeScript properties of a `CfnReplicaKeyProps`
 *
 * @returns the result of the validation.
 */
function CfnReplicaKeyPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('enabled', cdk.validateBoolean)(properties.enabled));
    errors.collect(cdk.propertyValidator('keyPolicy', cdk.requiredValidator)(properties.keyPolicy));
    errors.collect(cdk.propertyValidator('keyPolicy', cdk.validateObject)(properties.keyPolicy));
    errors.collect(cdk.propertyValidator('pendingWindowInDays', cdk.validateNumber)(properties.pendingWindowInDays));
    errors.collect(cdk.propertyValidator('primaryKeyArn', cdk.requiredValidator)(properties.primaryKeyArn));
    errors.collect(cdk.propertyValidator('primaryKeyArn', cdk.validateString)(properties.primaryKeyArn));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnReplicaKeyProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KMS::ReplicaKey` resource
 *
 * @param properties - the TypeScript properties of a `CfnReplicaKeyProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KMS::ReplicaKey` resource.
 */
// @ts-ignore TS6133
function cfnReplicaKeyPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnReplicaKeyPropsValidator(properties).assertSuccess();
    return {
        KeyPolicy: cdk.objectToCloudFormation(properties.keyPolicy),
        PrimaryKeyArn: cdk.stringToCloudFormation(properties.primaryKeyArn),
        Description: cdk.stringToCloudFormation(properties.description),
        Enabled: cdk.booleanToCloudFormation(properties.enabled),
        PendingWindowInDays: cdk.numberToCloudFormation(properties.pendingWindowInDays),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnReplicaKeyPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('keyPolicy', 'KeyPolicy', cfn_parse.FromCloudFormation.getAny(properties.KeyPolicy));
    ret.addPropertyResult('primaryKeyArn', 'PrimaryKeyArn', cfn_parse.FromCloudFormation.getString(properties.PrimaryKeyArn));
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('enabled', 'Enabled', properties.Enabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Enabled) : undefined);
    ret.addPropertyResult('pendingWindowInDays', 'PendingWindowInDays', properties.PendingWindowInDays != null ? cfn_parse.FromCloudFormation.getNumber(properties.PendingWindowInDays) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::KMS::ReplicaKey`
 *
 * The `AWS::KMS::ReplicaKey` resource specifies a multi-Region replica key that is based on a multi-Region primary key.
 *
 * *Multi-Region keys* are an AWS KMS feature that lets you create multiple interoperable KMS keys in different AWS Regions . Because these KMS keys have the same key ID, key material, and other metadata, you can use them to encrypt data in one AWS Region and decrypt it in a different AWS Region without making a cross-Region call or exposing the plaintext data. For more information, see [Multi-Region keys](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html) in the *AWS Key Management Service Developer Guide* .
 *
 * A multi-Region *primary key* is a fully functional symmetric encryption KMS key, HMAC KMS key, or asymmetric KMS key that is also the model for replica keys in other AWS Regions . To create a multi-Region primary key, add an [AWS::KMS::Key](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html) resource to your CloudFormation stack. Set its `MultiRegion` property to true.
 *
 * A multi-Region *replica key* is a fully functional KMS key that has the same key ID and key material as a multi-Region primary key, but is located in a different AWS Region of the same AWS partition. There can be multiple replicas of a primary key, but each must be in a different AWS Region .
 *
 * When you create a replica key in AWS CloudFormation , the replica key is created in the AWS Region represented by the endpoint you use for the request. If you try to replicate a multi-Region key into a Region in which the key type is not supported, the request will fail.
 *
 * > HMAC KMS keys are not supported in all AWS Regions . For a list of supported Regions, see [HMAC keys in AWS KMS](https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html#hmac-regions) in the *AWS Key Management Service Developer Guide* .
 *
 * A primary key and its replicas have the same key ID and key material. They also have the same key spec, key usage, key material origin, and automatic key rotation status. These properties are known as *shared properties* . If they change, AWS KMS synchronizes the change to all related multi-Region keys. All other properties of a replica key can differ, including its key policy, tags, aliases, and key state. AWS KMS does not synchronize these properties.
 *
 * *Regions*
 *
 * AWS KMS CloudFormation resources are supported in all Regions in which AWS CloudFormation is supported. However, in the  (ap-southeast-3), you cannot use a CloudFormation template to create or manage multi-Region KMS keys (primary or replica).
 *
 * @cloudformationResource AWS::KMS::ReplicaKey
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-replicakey.html
 */
class CfnReplicaKey extends cdk.CfnResource {
    /**
     * Create a new `AWS::KMS::ReplicaKey`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnReplicaKey.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_kms_CfnReplicaKeyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnReplicaKey);
            }
            throw error;
        }
        cdk.requireProperty(props, 'keyPolicy', this);
        cdk.requireProperty(props, 'primaryKeyArn', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrKeyId = cdk.Token.asString(this.getAtt('KeyId'));
        this.keyPolicy = props.keyPolicy;
        this.primaryKeyArn = props.primaryKeyArn;
        this.description = props.description;
        this.enabled = props.enabled;
        this.pendingWindowInDays = props.pendingWindowInDays;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::KMS::ReplicaKey", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnReplicaKeyPropsFromCloudFormation(resourceProperties);
        const ret = new CfnReplicaKey(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnReplicaKey.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            keyPolicy: this.keyPolicy,
            primaryKeyArn: this.primaryKeyArn,
            description: this.description,
            enabled: this.enabled,
            pendingWindowInDays: this.pendingWindowInDays,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnReplicaKeyPropsToCloudFormation(props);
    }
}
exports.CfnReplicaKey = CfnReplicaKey;
_c = JSII_RTTI_SYMBOL_1;
CfnReplicaKey[_c] = { fqn: "@aws-cdk/aws-kms.CfnReplicaKey", version: "1.163.2" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnReplicaKey.CFN_RESOURCE_TYPE_NAME = "AWS::KMS::ReplicaKey";
//# sourceMappingURL=data:application/json;base64,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