# Generated by 'python3 -m parameter_persistence.generate_models'

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Field


class WebBridgeParameters(BaseModel):
    address: Optional[str] = Field(
        None, description="The host address to bind the WebSocket server to"
    )
    asset_uri_allowlist: Optional[List[str]] = Field(
        None,
        description="List of regular expressions (ECMAScript) of whitelisted parameter names.",
    )
    capabilities: Optional[List[str]] = Field(None, description="Server capabilities")
    certfile: Optional[str] = Field(None, description="Path to the certificate to use for TLS")
    client_topic_whitelist: Optional[List[str]] = Field(
        None,
        description="List of regular expressions (ECMAScript) of whitelisted parameter names.",
    )
    disable_load_message: Optional[bool] = Field(
        None,
        description="Do not publish as loaned message when publishing a client message",
    )
    include_hidden: Optional[bool] = Field(None, description="Include hidden topics and services")
    keyfile: Optional[str] = Field(None, description="Path to the private key to use for TLS")
    max_qos_depth: Optional[int] = Field(
        None, description="Maximum depth used for the QoS profile of subscriptions."
    )
    min_qos_depth: Optional[int] = Field(
        None, description="Minimum depth used for the QoS profile of subscriptions."
    )
    param_whitelist: Optional[List[str]] = Field(
        None,
        description="List of regular expressions (ECMAScript) of whitelisted parameter names.",
    )
    port: Optional[int] = Field(None, description="The TCP port to bind the WebSocket server to")
    send_buffer_limit: Optional[int] = Field(
        None,
        description="Connection send buffer limit in bytes. Messages will be dropped when a connection's send buffer reaches this limit to avoid a queue of outdated messages building up.",
    )
    service_whitelist: Optional[List[str]] = Field(
        None,
        description="List of regular expressions (ECMAScript) of whitelisted service names.",
    )
    tls: Optional[bool] = Field(
        None, description="Use Transport Layer Security for encrypted communication"
    )
    topic_whitelist: Optional[List[str]] = Field(
        None,
        description="List of regular expressions (ECMAScript) of whitelisted topic names.",
    )
    use_compression: Optional[bool] = Field(
        None,
        description="Use websocket compression (permessage-deflate). Suited for connections with smaller bandwidth, at the cost of additional CPU load.",
    )


class LookoutGreenstreamBringupParameters(BaseModel):
    launch_package: Optional[str] = Field(None, description="")
    launch_executable: Optional[str] = Field(None, description="")


class LaunchParameters(BaseModel):
    web_bridge: Optional[WebBridgeParameters] = None
    lookout_greenstream_bringup: Optional[LookoutGreenstreamBringupParameters] = None
