# Velocity optimization

![Velocity Optimization.](https://raw.githubusercontent.com/TUMFTM/velocity_optimization/master/vel.png)

Optimizes (Maximizes) the velocity profile for a vehicle in real-time respecting physical constraints (e.g., power,
force, combined acceleration, ...). Takes into account a variable friction potential between road and tires. Max.
power input can be space-variable (for, e.g., energy strategy purposes).

### Disclaimer

This software is provided as-is and has not been subject to a certified safety validation. Autonomous Driving is a highly complex and dangerous task. In case you plan to use this software on a vehicle, it is by all means required that you assess the overall safety of your project as a whole. By no means is this software a replacement for a valid safety-concept. See the license for more details.

### Documentation

The public documentation is available through [ReadTheDocs](https://velocity-optimization.readthedocs.io/en/latest/index.html).

The internal development documentation can be found on [GitLab](https://roborace.pages.gitlab.lrz.de/modules/velocity_optimization/index.html).

### Publication

The preprint of the accepted version of the corresponding paper is available on [arXiv](https://arxiv.org/abs/2012.13586).

The paper is available on [IEEE eXplore](https://doi.org/10.1109/TIV.2020.3047858) and will soon be in the printed
version of the IEEE Transactions on Intelligent Vehicles:

    @article{Herrmann2020,
     author = {Herrmann, Thomas and Wischnewski, Alexander and Hermansdorfer, Leonhard and Betz, Johannes and
     Lienkamp, Markus},
     year = {2020},
     title = {{Real-Time Adaptive Velocity Optimization for Autonomous Electric Cars at the Limits of Handling}},
     pages = {000--000, In Press},
     volume = {0},
     number = {0},
     issn = {2379-8904},
     journal = {{IEEE Transactions on Intelligent Vehicles}},
     doi = {10.1109/TIV.2020.3047858}
    }

