/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.auth;

import com.datapps.linkoopdb.jdbc.auth.AuthFunctionBean;
import com.datapps.linkoopdb.jdbc.impl.JDBCArrayBasic;
import com.datapps.linkoopdb.jdbc.lib.FrameworkLogger;
import com.datapps.linkoopdb.jdbc.types.Type;
import java.sql.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AuthBeanMultiplexer {
    private static FrameworkLogger logger = FrameworkLogger.getLog(AuthBeanMultiplexer.class);
    private static AuthBeanMultiplexer singleton = new AuthBeanMultiplexer();
    private static Map<String, List<AuthFunctionBean>> beans = new HashMap<String, List<AuthFunctionBean>>();

    private AuthBeanMultiplexer() {
    }

    public static AuthBeanMultiplexer getSingleton() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getUniqueNameFor(Connection c) throws SQLException {
        Statement st = c.createStatement();
        ResultSet rs = null;
        try {
            rs = st.executeQuery("CALL database_name()");
            if (!rs.next()) {
                throw new SQLException("Engine did not reveal unique database name");
            }
            String string = rs.getString(1);
            return string;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException se) {
                    logger.error("Failed to close ResultSet for retrieving db name");
                }
            }
            rs = null;
            try {
                st.close();
            }
            catch (SQLException se) {
                logger.error("Failed to close Statement for retrieving db name");
            }
            st = null;
        }
    }

    public static Array authenticate(String database, String user, String password) throws Exception {
        if (database == null || database.length() != 16) {
            throw new IllegalStateException("Internal problem.  Database name not exactly 16 characters long: " + database);
        }
        List<AuthFunctionBean> beanList = beans.get(database);
        if (beanList == null) {
            logger.error("Database '" + database + "' has not been set up with " + AuthBeanMultiplexer.class.getName());
            throw new IllegalArgumentException("Database '" + database + "' has not been set up with " + AuthBeanMultiplexer.class.getName());
        }
        RuntimeException firstRTE = null;
        for (AuthFunctionBean nextBean : beanList) {
            try {
                Object[] beanRet = nextBean.authenticate(user, password);
                return beanRet == null ? null : new JDBCArrayBasic(beanRet, Type.SQL_VARCHAR);
            }
            catch (RuntimeException re) {
                if (firstRTE == null) {
                    firstRTE = re;
                }
                logger.error("System failure of an AuthFunctionBean: " + (re.getMessage() == null ? re.toString() : re.getMessage()));
            }
            catch (Exception e) {
                throw e;
            }
        }
        throw firstRTE;
    }

    public void clear() {
        beans.clear();
    }

    public void setAuthFunctionBeans(Map<String, List<AuthFunctionBean>> authFunctionBeanMap) {
        if (beans.size() > 0) {
            throw new IllegalStateException("Use setAuthFunctionBeans(Map) only when the set is empty");
        }
        beans.putAll(authFunctionBeanMap);
    }

    public void setAuthFunctionBeans(Connection c, List<AuthFunctionBean> authFunctionBeans) throws SQLException {
        this.setAuthFunctionBeans(AuthBeanMultiplexer.getUniqueNameFor(c), authFunctionBeans);
    }

    public void setAuthFunctionBeans(String dbName, List<AuthFunctionBean> authFunctionBeans) {
        if (dbName == null || dbName.length() != 16) {
            throw new IllegalArgumentException("Database name not exactly 16 characters long: " + dbName);
        }
        List<AuthFunctionBean> dbsBeans = beans.get(dbName);
        if (dbsBeans == null) {
            dbsBeans = new ArrayList<AuthFunctionBean>();
            beans.put(dbName, dbsBeans);
        } else if (dbsBeans.size() > 0) {
            throw new IllegalStateException("Use setAuthFunctionBeans(String, List) only when the db's AuthFunctionBean list is empty");
        }
        dbsBeans.addAll(authFunctionBeans);
    }

    public void setAuthFunctionBean(Connection c, AuthFunctionBean authFunctionBean) throws SQLException {
        this.setAuthFunctionBeans(AuthBeanMultiplexer.getUniqueNameFor(c), Collections.singletonList(authFunctionBean));
    }

    public void setAuthFunctionBean(String dbName, AuthFunctionBean authFunctionBean) {
        this.setAuthFunctionBeans(dbName, Collections.singletonList(authFunctionBean));
    }
}

