/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.lib;

import com.datapps.linkoopdb.jdbc.lib.Collection;
import com.datapps.linkoopdb.jdbc.lib.Iterator;
import com.datapps.linkoopdb.jdbc.lib.ObjectComparator;
import com.datapps.linkoopdb.jdbc.lib.Set;
import com.datapps.linkoopdb.jdbc.map.BaseHashMap;

public class HashSet
extends BaseHashMap
implements Set {
    public HashSet() {
        this(8);
    }

    public HashSet(int initialCapacity) throws IllegalArgumentException {
        super(initialCapacity, 3, 0, false);
    }

    @Override
    public void setComparator(ObjectComparator comparator) {
        super.setComparator(comparator);
    }

    @Override
    public boolean contains(Object key) {
        return super.containsKey(key);
    }

    public boolean containsAll(Collection col) {
        Iterator it = col.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object get(Object key) {
        int lookup = this.getLookup(key, key.hashCode());
        if (lookup < 0) {
            return null;
        }
        return this.objectKeyTable[lookup];
    }

    @Override
    public boolean add(Object key) {
        int count = this.size();
        super.addOrRemove(0L, 0L, key, null, false);
        return count != this.size();
    }

    @Override
    public boolean addAll(Collection c) {
        boolean changed = false;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            changed |= this.add(it.next());
        }
        return changed;
    }

    public boolean addAll(Object[] keys) {
        boolean changed = false;
        for (int i = 0; i < keys.length; ++i) {
            changed |= this.add(keys[i]);
        }
        return changed;
    }

    public boolean addAll(Object[] keys, int start, int limit) {
        boolean changed = false;
        for (int i = start; i < keys.length && i < limit; ++i) {
            changed |= this.add(keys[i]);
        }
        return changed;
    }

    @Override
    public boolean remove(Object key) {
        return super.removeObject(key, false) != null;
    }

    public boolean removeAll(Collection c) {
        Iterator it = c.iterator();
        boolean result = true;
        while (it.hasNext()) {
            result &= this.remove(it.next());
        }
        return result;
    }

    public boolean removeAll(Object[] keys) {
        boolean result = true;
        for (int i = 0; i < keys.length; ++i) {
            result &= this.remove(keys[i]);
        }
        return result;
    }

    public void toArray(Object[] a) {
        Iterator it = this.iterator();
        int i = 0;
        while (it.hasNext()) {
            a[i] = it.next();
            ++i;
        }
    }

    public Object[] toArray() {
        if (this.isEmpty()) {
            return emptyObjectArray;
        }
        Object[] array = new Object[this.size()];
        this.toArray(array);
        return array;
    }

    @Override
    public Iterator iterator() {
        return new BaseHashMap.BaseHashIterator(this, true);
    }

    public String toString() {
        Iterator it = this.iterator();
        StringBuffer sb = new StringBuffer();
        while (it.hasNext()) {
            if (sb.length() > 0) {
                sb.append(", ");
            } else {
                sb.append('[');
            }
            sb.append(it.next());
        }
        return sb.toString() + ']';
    }
}

