/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.types;

import java.io.Serializable;

public class TimestampData
implements Serializable {
    final long seconds;
    final int nanos;
    final int zone;

    public TimestampData(long seconds) {
        this.seconds = seconds;
        this.nanos = 0;
        this.zone = 0;
    }

    public TimestampData(long seconds, int nanos) {
        this.seconds = seconds;
        this.nanos = nanos;
        this.zone = 0;
    }

    public TimestampData(long seconds, int nanos, int zoneSeconds) {
        this.seconds = seconds;
        this.nanos = nanos;
        this.zone = zoneSeconds;
    }

    public long getSeconds() {
        return this.seconds;
    }

    public int getNanos() {
        return this.nanos;
    }

    public int getZone() {
        return this.zone;
    }

    public long getMillis() {
        return this.seconds * 1000L;
    }

    public boolean equals(Object other) {
        if (other instanceof TimestampData) {
            return this.seconds == ((TimestampData)other).seconds && this.nanos == ((TimestampData)other).nanos && this.zone == ((TimestampData)other).zone;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.seconds ^ this.nanos;
    }

    public int compareTo(TimestampData b) {
        long diff = this.seconds - b.seconds;
        if (diff == 0L && (diff = (long)(this.nanos - b.nanos)) == 0L) {
            return 0;
        }
        return diff > 0L ? 1 : -1;
    }
}

