/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import java.sql.SQLException;

public class GtwConfigParcel
extends Parcel {
    private boolean supportsUTF_Credentials = false;
    private boolean m_bSupportsControlData = false;
    private boolean m_bSupportsRecoverableNP = false;
    private boolean m_bSupportsRedrive = false;
    private boolean m_bSupportsNegotiationMechanism = false;

    public GtwConfigParcel(TDPacketStream tDPacketStream, GenericTeradataConnection genericTeradataConnection) throws SQLException {
        super(genericTeradataConnection);
        this.flavorPosition = tDPacketStream.position();
        this.setFlavor(tDPacketStream.getShort());
        this.setLength(tDPacketStream.getShort());
        if (tDPacketStream.getInt() == 1) {
            this.determineFeatureSupport(tDPacketStream, this.flavorPosition + this.length);
        }
    }

    private void determineFeatureSupport(TDPacketStream tDPacketStream, int n) throws SQLException {
        while (tDPacketStream.position() + 4 <= n) {
            int n2 = tDPacketStream.position();
            short s = tDPacketStream.getShort();
            short s2 = tDPacketStream.getShort();
            if (this.log.isDebugEnabled()) {
                this.log.debug("GtwConfigParcel: self-defining feature " + s + " at position " + n2 + " has length " + s2);
            }
            switch (s) {
                case 3: {
                    this.supportsUTF_Credentials = true;
                    break;
                }
                case 6: {
                    this.m_bSupportsControlData = true;
                    break;
                }
                case 5: {
                    this.m_bSupportsRecoverableNP = true;
                    break;
                }
                case 7: {
                    this.m_bSupportsRedrive = true;
                    break;
                }
                case 12: {
                    this.m_bSupportsNegotiationMechanism = tDPacketStream.getShort() >= 1;
                }
            }
            tDPacketStream.position(n2 + s2);
        }
    }

    public boolean isUTF_CredentialSupported() {
        return this.supportsUTF_Credentials;
    }

    public boolean isControlDataSupported() {
        return this.m_bSupportsControlData;
    }

    public boolean isRecoverableNPSupported() {
        return this.m_bSupportsRecoverableNP;
    }

    public boolean isRedriveSupported() {
        return this.m_bSupportsRedrive;
    }

    public boolean isNegotiationMechanismSupported() {
        return this.m_bSupportsNegotiationMechanism;
    }
}

