/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.DeferredLob;
import com.teradata.jdbc.jdbc_4.MetaDataList;
import com.teradata.jdbc.jdbc_4.ParameterProperties;
import com.teradata.jdbc.jdbc_4.parcel.DataInfoParcel;
import com.teradata.jdbc.jdbc_4.parcel.DataInfoXParcel;
import com.teradata.jdbc.jdbc_4.parcel.EndMultiPartIndicDataParcel;
import com.teradata.jdbc.jdbc_4.parcel.EndSLOBDataParcel;
import com.teradata.jdbc.jdbc_4.parcel.EndSLOBDataParcelAltHeader;
import com.teradata.jdbc.jdbc_4.parcel.IndicDataParcel;
import com.teradata.jdbc.jdbc_4.parcel.MultiPartIndicDataParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.SLOBDataParcel;
import com.teradata.jdbc.jdbc_4.parcel.SLOBDataParcelAltHeader;
import com.teradata.jdbc.jdbc_4.parcel.StartSLOBDataParcel;
import com.teradata.jdbc.jdbc_4.parcel.StartSLOBDataParcelAltHeader;
import com.teradata.jdbc.jdbc_4.statemachine.ActivityAnalyzer;
import com.teradata.jdbc.jdbc_4.statemachine.PreparedIndicProtocol;
import com.teradata.jdbc.jdbc_4.statemachine.StatementSendState;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

public class PreparedIndicMultiPartProtocol
extends PreparedIndicProtocol {
    private int numberOfDataParcelsInBuffer;
    private int bufferSize = 0;
    private ArrayList m_listSLOBTokens = new ArrayList();

    public PreparedIndicMultiPartProtocol(StatementSendState statementSendState, ParameterProperties parameterProperties) throws SQLException {
        super(statementSendState, parameterProperties);
        this.setNumberOfDataParcelsInBuffer();
    }

    void initIndicData() throws SQLException {
        if (this.paramProperties != null && this.paramProperties.getNumberOfInAndInOutParams() > 0 && this.paramProperties.numberOfParamSetsLeft() > 0) {
            for (int i = 0; i < this.numberOfDataParcelsInBuffer; ++i) {
                super.initIndicData();
                this.initSlobData(i);
                this.initEndMultiPartIndicData();
            }
        }
    }

    protected void initEndMultiPartIndicData() throws SQLException {
        this.sendState.getPacket().addParcel(new EndMultiPartIndicDataParcel(this.sendState.getController().getSession(), this.sendState.isAltHeader()));
    }

    protected void initSlobData(int n) throws SQLException {
        if (!this.sendState.getController().getSession().isSlobTransmittable()) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.m_listSLOBTokens.get(n);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int[] nArray = (int[])iterator.next();
            int n2 = nArray[0];
            int n3 = nArray[1];
            DeferredLob deferredLob = this.sendState.getController().getSession().unregisterDeferredLob(n2);
            this.sendState.getPacket().addParcel(this.sendState.isAltHeader() ? new StartSLOBDataParcelAltHeader(this.sendState.getController().getSession(), n3) : new StartSLOBDataParcel(this.sendState.getController().getSession(), n3));
            this.sendState.getPacket().addParcel(this.sendState.isAltHeader() ? new SLOBDataParcelAltHeader(this.sendState.getController().getSession(), deferredLob) : new SLOBDataParcel(this.sendState.getController().getSession(), deferredLob));
            this.sendState.getPacket().addParcel(this.sendState.isAltHeader() ? new EndSLOBDataParcelAltHeader(this.sendState.getController().getSession()) : new EndSLOBDataParcel(this.sendState.getController().getSession()));
        }
    }

    protected DataInfoParcel getDataInfoParcel() throws SQLException {
        return new DataInfoXParcel(this.sendState.isAltHeader(), this.paramProperties.getNumberOfInAndInOutParams(), this.sendState.getController().getSession());
    }

    protected IndicDataParcel getIndicDataParcel() throws SQLException {
        int n = this.paramProperties.getParameterSet().getDataSize() + this.paramProperties.getParameterSet().getNullIndicatorBitsSize();
        return new MultiPartIndicDataParcel(n, this.sendState.getController().getSession(), this.sendState.isAltHeader());
    }

    protected int getDataParcelsHeaderLength(boolean bl) {
        return Parcel.calculateHeaderLength(bl) * 2;
    }

    protected int getSize() throws SQLException {
        return this.bufferSize;
    }

    private boolean paramSetIndexPermittedBySQLStatement(int n) throws SQLException {
        MetaDataList metaDataList = this.sendState.getController().getStatement().getMetaDataList();
        if (metaDataList.size() > 0 && ActivityAnalyzer.outParamResultSet(metaDataList.getFirstMetaData().getActivityType()) && !this.sendState.getController().getSession().getConfigResponse().callSPHasDMLArraySupport()) {
            return n == 0;
        }
        return true;
    }

    protected void setNumberOfDataParcelsInBuffer() throws SQLException {
        boolean bl = this.sendState.getController().getSession().isAphSupported();
        int n = this.getBaseSize(bl);
        if (this.paramProperties != null && this.paramProperties.getNumberOfInAndInOutParams() > 0) {
            int n2 = 0;
            int n3 = bl ? this.sendState.getController().getSession().getMaxMessageSize(true, false) : 65104;
            int n4 = Parcel.calculateHeaderLength(bl) * 3 + 4 + 8;
            int n5 = 0;
            for (int i = this.paramProperties.getParameterSetIndex(); i < this.paramProperties.numberOfParamSets() && this.paramSetIndexPermittedBySQLStatement(n5) && n + n2 <= n3; ++i) {
                n += n2;
                n2 = this.getDataParcelsHeaderLength(bl) + this.paramProperties.getDataSize(i);
                if (this.sendState.getController().getSession().isSlobTransmittable()) {
                    ArrayList arrayList = new ArrayList();
                    this.m_listSLOBTokens.add(arrayList);
                    n2 += this.paramProperties.getParameterSet(i).getSlobLength(n3 - (n + n2), n4, arrayList);
                }
                ++n5;
            }
            if (n + n2 > n3) {
                --n5;
            } else {
                n += n2;
            }
            this.numberOfDataParcelsInBuffer = n5;
            if (this.numberOfDataParcelsInBuffer < 1) {
                throw ErrorFactory.makeDriverJDBCException("TJ814", n + n2, n3);
            }
        }
        this.bufferSize = n;
    }

    protected int getNumberOfDataParcelsInBuffer() {
        return this.numberOfDataParcelsInBuffer;
    }
}

