/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2jwt;

import com.teradata.tdgss.jgssp2jwt.JwtMinorStatus;
import com.teradata.tdgss.jgssp2ldap.LdapDH;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.jtdgss.TdgssLogger;
import com.teradata.tdgss.jtdgss.TdgssUtil;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.ietf.jgss.GSSException;

public class JwtUtil {
    public static byte[] encryptBuffer(byte[] byArray, byte[] byArray2, TdgssLogger tdgssLogger) throws GSSException {
        int n = 16;
        if (byArray == null || byArray2 == null) {
            return null;
        }
        LdapDH ldapDH = new LdapDH(tdgssLogger);
        byte[] byArray3 = null;
        String string = "AES/ECB/PKCS5Padding";
        try {
            SecretKey secretKey = ldapDH.BytetoKey("AES", byArray, 0, n);
            Cipher cipher = Cipher.getInstance(string);
            cipher.init(1, secretKey);
            byArray3 = cipher.doFinal(byArray2, 0, byArray2.length);
        }
        catch (RuntimeException runtimeException) {
            throw new TdgssException(11, JwtMinorStatus.JWT_ERR_INT_FAILURE, runtimeException);
        }
        catch (Exception exception) {
            throw new TdgssException(11, JwtMinorStatus.JWT_ERR_INT_FAILURE, exception);
        }
        return byArray3;
    }

    public static byte[] decryptBuffer(byte[] byArray, byte[] byArray2, TdgssLogger tdgssLogger) throws GSSException {
        int n = 16;
        if (byArray == null || byArray2 == null) {
            return null;
        }
        LdapDH ldapDH = new LdapDH(tdgssLogger);
        byte[] byArray3 = null;
        String string = "AES/ECB/PKCS5Padding";
        try {
            SecretKey secretKey = ldapDH.BytetoKey("AES", byArray, 0, n);
            Cipher cipher = Cipher.getInstance(string);
            cipher.init(2, secretKey);
            byArray3 = cipher.doFinal(byArray2, 0, byArray2.length);
        }
        catch (RuntimeException runtimeException) {
            throw new TdgssException(11, JwtMinorStatus.JWT_ERR_INT_FAILURE, runtimeException);
        }
        catch (Exception exception) {
            throw new TdgssException(11, JwtMinorStatus.JWT_ERR_INT_FAILURE, exception);
        }
        return byArray3;
    }

    public static byte[] getEDKey(TdgssLogger tdgssLogger) {
        int n = 16;
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[n];
        secureRandom.nextBytes(byArray);
        if (tdgssLogger.isDebugEnabled()) {
            tdgssLogger.debug(TdgssUtil.dump("", byArray));
        }
        return byArray;
    }
}

