/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2td2;

import com.teradata.tdgss.jgssp2td2.Td2MinorStatus;
import com.teradata.tdgss.jgssp2td2.Td2Util;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.jtdgss.TdgssLogger;
import java.math.BigInteger;
import org.ietf.jgss.GSSException;

public class Td2Token {
    private byte version;
    private byte msgType;
    private byte byteVar;
    private byte ClientOrServer;
    private int msgLength;
    private int fQOP;
    private byte v3fQOP;
    private byte flag;
    private byte[] resForExp;
    private int fCapabilities;
    private BigInteger seqNum;
    private static final int VersionIndex = 0;
    private static final int msgTypeIndex = 1;
    private static final int byteVarIndex = 2;
    private static final int originIndex = 3;
    private static final int msgLengthIndex = 4;
    private static final int fQOPIndex = 8;
    private static final int flagIndex = 12;
    private static final int resForExpIndex = 13;
    private static final int v3flagsIndex = 2;
    private static final int v3fQOPIndex = 3;
    private static final int seqNumIndex = 8;
    public static final int DEFAULT_QOP = 0;
    public static final int TD2QOP = 0;

    public Td2Token(byte by, byte by2, byte by3, byte by4, int n, byte by5, int n2, int n3, BigInteger bigInteger, TdgssLogger tdgssLogger) {
        if ((n & 1) == 1 && (by2 == 7 || by2 == 8)) {
            this.version = by;
            this.msgType = by2;
            this.msgLength = n3;
            this.flag = by5;
            if (by4 != 0) {
                this.flag = (byte)(this.flag | 1);
            }
            this.v3fQOP = (byte)n2;
            this.seqNum = bigInteger == null ? new BigInteger("0") : bigInteger;
        } else {
            this.version = by;
            this.msgType = by2;
            this.byteVar = by3;
            this.ClientOrServer = by4;
            this.msgLength = n3;
            if ((by2 == 1 || by2 == 2) && by3 == 1) {
                this.fCapabilities = n;
            } else {
                this.fQOP = 0;
            }
            this.flag = by5;
            this.flag = (byte)(this.flag | 2);
            this.resForExp = new byte[3];
            int n4 = 13;
            int n5 = 0;
            while (n4 < 16) {
                this.resForExp[n5] = 0;
                ++n4;
                ++n5;
            }
        }
    }

    public Td2Token(byte[] byArray, int n, TdgssLogger tdgssLogger) throws GSSException {
        if (byArray == null) {
            if (tdgssLogger.isDebugEnabled()) {
                tdgssLogger.debug("Input Buffer is NULL");
            }
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_WRONG_MSGINFO);
        }
        if (n < 0 || n > byArray.length) {
            if (tdgssLogger.isDebugEnabled()) {
                tdgssLogger.debug("Offset value is incorrect");
            }
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_WRONG_MSGINFO);
        }
        if (byArray.length - n < 16) {
            if (tdgssLogger.isDebugEnabled()) {
                tdgssLogger.debug("Input buffer is less than token header (16 bytes)");
            }
            throw new TdgssException(11, Td2MinorStatus.TD2_ERR_WRONG_MSGINFO);
        }
        this.checkAndSetLegalVersion(byArray[0]);
        this.checkAndSetLegalmsgType(byArray[1]);
        byte[] byArray2 = new byte[4];
        System.arraycopy(byArray, 4, byArray2, 0, 4);
        this.msgLength = Td2Util.ByteAtoInt(byArray2);
        if (this.msgType == 7 || this.msgType == 8) {
            this.flag = byArray[2];
            this.v3fQOP = byArray[3];
            byte[] byArray3 = new byte[8];
            System.arraycopy(byArray, 8, byArray3, 0, 8);
            this.seqNum = new BigInteger(byArray3);
        } else {
            this.checkAndSetLegalByteVar(byArray[2]);
            this.checkAndSetLegalOrigin(byArray[3]);
            this.checkAndSetLegalQOP(byArray);
            this.flag = byArray[12];
            this.resForExp = new byte[3];
            int n2 = 13;
            int n3 = 0;
            while (n2 < 16) {
                this.resForExp[n3] = byArray[n2];
                ++n2;
                ++n3;
            }
        }
    }

    public byte[] GetTokenBytes() {
        byte[] byArray = new byte[16];
        byArray[0] = this.version;
        byArray[1] = this.msgType;
        byte[] byArray2 = Td2Util.inttobytearray(this.msgLength);
        System.arraycopy(byArray2, 0, byArray, 4, byArray2.length);
        if (this.msgType == 7 || this.msgType == 8) {
            byArray[2] = this.flag;
            byArray[3] = this.v3fQOP;
            byArray2 = Td2Util.BigInttobytearray(this.seqNum);
            System.arraycopy(byArray2, 0, byArray, 8, byArray2.length);
        } else {
            byArray[2] = this.byteVar;
            byArray[3] = this.ClientOrServer;
            byArray2 = (this.msgType == 1 || this.msgType == 2) && this.byteVar == 1 ? Td2Util.inttobytearray(this.fCapabilities) : Td2Util.inttobytearray(this.fQOP);
            System.arraycopy(byArray2, 0, byArray, 8, 4);
            byArray[12] = this.flag;
            int n = 13;
            int n2 = 0;
            while (n < 16) {
                byArray[n] = this.resForExp[n2];
                ++n;
                ++n2;
            }
        }
        return byArray;
    }

    public byte getVersion() {
        return this.version;
    }

    public byte getMsgType() {
        return this.msgType;
    }

    public byte getByteVar() {
        return this.byteVar;
    }

    public byte getClientOrServer() {
        return this.ClientOrServer;
    }

    public int getMsgLength() {
        return this.msgLength;
    }

    public void setMsgLength(int n) {
        this.msgLength = n;
    }

    public int getQOP() {
        if (this.msgType == 7 || this.msgType == 8) {
            return this.v3fQOP;
        }
        return this.fQOP;
    }

    public byte getFlags() {
        return this.flag;
    }

    public int getCapabilities() {
        return this.fCapabilities;
    }

    public BigInteger getSeqNumber() {
        return this.seqNum;
    }

    private void checkAndSetLegalVersion(byte by) throws GSSException {
        if (by != 1 && by != 3) {
            throw new TdgssException(10, Td2MinorStatus.TD2_ERR_WRONG_MSGINFO);
        }
        this.version = by;
    }

    private void checkAndSetLegalmsgType(byte by) throws GSSException {
        if (by != 1 && by != 2 && by != 3 && by != 4 && by != 7 && by != 8 && by != 5) {
            throw new TdgssException(10, Td2MinorStatus.TD2_ERR_WRONG_MSGINFO);
        }
        this.msgType = by;
    }

    private void checkAndSetLegalByteVar(byte by) throws GSSException {
        if (by != 1 && by != 2) {
            throw new TdgssException(10, Td2MinorStatus.TD2_ERR_WRONG_MSGINFO);
        }
        this.byteVar = by;
    }

    private void checkAndSetLegalOrigin(byte by) throws GSSException {
        if (by != 0 && by != 1) {
            throw new TdgssException(10, Td2MinorStatus.TD2_ERR_WRONG_MSGINFO);
        }
        this.ClientOrServer = by;
    }

    private void checkAndSetLegalQOP(byte[] byArray) throws GSSException {
        byte[] byArray2 = new byte[4];
        System.arraycopy(byArray, 8, byArray2, 0, 4);
        int n = Td2Util.ByteAtoInt(byArray2);
        if ((this.msgType == 1 || this.msgType == 2) && this.byteVar == 1) {
            this.fCapabilities = n;
        } else if (n == 0) {
            this.fQOP = 0;
        } else {
            throw new TdgssException(10, Td2MinorStatus.TD2_ERR_WRONG_MSGINFO);
        }
    }
}

