# -*- coding: utf-8 -*-
from Acquisition import aq_acquire
from plone.browserlayer.interfaces import ILocalBrowserLayerType
from plone.registry.interfaces import IRegistry
from plone.resource.directory import FilesystemResourceDirectory
from plone.resource.file import FilesystemFile
from plone.subrequest import subrequest
from Products import CMFPlone
from Products.CMFCore.FSFile import FSFile
from Products.CMFPlone.interfaces import IBundleRegistry
from Products.CMFPlone.interfaces import IResourceRegistry
from Products.Five.browser.resource import DirectoryResource
from Products.Five.browser.resource import FileResource
from zope.component import getUtility
from zope.component import getSiteManager
from zope.interface import alsoProvides
from zope.site.hooks import setSite

import json
import os
import pkg_resources
import uuid


try:
    pkg_resources.get_distribution('plonetheme.barceloneta')
except pkg_resources.DistributionNotFound:
    HAS_BARCELONETA = False
else:
    HAS_BARCELONETA = True
    import plonetheme.barceloneta


def applyBrowserLayers(site):
    request = aq_acquire(site, 'REQUEST')
    sm = getSiteManager(site)
    layers = sm.getAllUtilitiesRegisteredFor(ILocalBrowserLayerType)
    for layer in layers:
        alsoProvides(request, layer)


# some initial script setup
if 'SITE_ID' in os.environ:
    site_id = os.environ['SITE_ID']
else:
    site_id = 'Plone'
print('Using site id: {0}'.format(site_id))

compile_path = ''
if 'COMPILE_DIR' in os.environ:
    compile_path = os.environ['COMPILE_DIR']
print('Target compile path: {0}'.format(compile_path or 'fetch from bundles'))

# app was injected by the script calling instance
current = app  # noqa
for part in site_id.split('/'):
    current = current[part]
portal = current
setSite(portal)
applyBrowserLayers(portal)


# start the juicy stuff
temp_resource_folder = 'temp_resources'
registry = getUtility(IRegistry)
bundles = registry.collectionOfInterface(
    IBundleRegistry, prefix="plone.bundles", check=False)
resources = registry.collectionOfInterface(
    IResourceRegistry, prefix="plone.resources", check=False)  # noqa
lessvariables = registry.records['plone.lessvariables'].value

GRUNTFILE_TEMPLATE = """// This file is generated by "plone-compile-resources"

module.exports = function(grunt) {{
    "use strict";
    var lessPaths = {lesspaths},
        modifyVars = {modifyvars};
    grunt.initConfig({{
        pkg: grunt.file.readJSON("package.json"),
        less: {{
            {less}
        }},
        requirejs: {{
            {requirejs}
        }},
        sed: {{
            {sed}
        }},
        uglify: {{
            {uglify}
        }},
        watch: {{
            scripts: {{
                files: {files},
                tasks: ["requirejs", "less", "sed", "uglify"]
            }}
        }}
    }});

    grunt.loadNpmTasks("grunt-contrib-watch");
    grunt.loadNpmTasks("grunt-contrib-requirejs");
    grunt.loadNpmTasks("grunt-contrib-less");
    grunt.loadNpmTasks("grunt-contrib-uglify");
    grunt.loadNpmTasks("grunt-sed");

    grunt.registerTask("default", ["watch"]);
    grunt.registerTask("compile-all", ["requirejs", "less", "sed", "uglify"]);

{bundleTasks}
}}
"""

SED_CONFIG_TEMPLATE = """
            {name}: {{
              path: "{path}",
              pattern: "{pattern}",
              replacement: "{destination}",
            }},
"""

REQUIREJS_CONFIG_TEMPLATE = """
            "{bkey}": {{
                options: {{
                    baseUrl: "/",
                    exclude: ["jquery"],
                    generateSourceMaps: false,
                    name: "{name}",
                    optimize: "none",
                    out: "{out}",
                    paths: {paths},
                    preserveLicenseComments: false,
                    shim: {shims},
                    wrapShim: true
                }}
            }},
"""
UGLIFY_CONFIG_TEMPLATE = """
        "{bkey}": {{
          options: {{
            sourceMap: {{
              includeSources: false
            }},
            sourceMapName: "{destination}.map"
          }},
          files: {{
            "{destination}": {files}
          }}
        }},
"""

LESS_CONFIG_TEMPLATE = """
            "{name}": {{
                files: [
                    {files}
                ],
                options: {{
                    compress: true,
                    modifyVars: modifyVars,
                    outputSourceFiles: true,
                    paths: lessPaths,
                    plugins: [new require("less-plugin-inline-urls"),],
                    relativeUrls: true,
                    sourceMap: true,
                    sourceMapBasepath: "{base_path}",
                    sourceMapURL: "{sourcemap_url}",
                    strictImports: false,
                    strictMath: false
                }}
            }}\
"""

COMPILE_TASK_TEMPLATE = """\
    grunt.registerTask("compile-{name}", {tasks})\n\
"""


def resource_to_dir(resource, file_type='.js'):
    if resource.__module__ == 'Products.Five.metaclass':
        try:
            return resource.chooseContext().path
        except:
            try:
                return resource.context.path
            except:
                try:
                    if callable(resource):
                        file_name = uuid.uuid4().hex
                        try:
                            os.mkdir(temp_resource_folder)
                        except OSError:
                            pass
                        full_file_name = temp_resource_folder + \
                            '/' + file_name + file_type
                        temp_file = open(full_file_name, 'w')
                        temp_file.write(resource().encode('utf-8'))
                        temp_file.close()

                        return os.getcwd() + '/' + full_file_name
                    else:
                        print "Missing resource type"
                        return None
                except:
                    print "Missing resource type"
                    return None
    elif isinstance(resource, FilesystemFile):
        return resource.path
    elif isinstance(resource, FileResource):
        return resource.chooseContext().path
    elif isinstance(resource, DirectoryResource):
        return resource.context.path
    elif isinstance(resource, FilesystemResourceDirectory):
        return resource.directory
    elif isinstance(resource, FSFile):
        return resource._filepath
    else:
        print "Missing resource type"
        return None

# REQUIRE JS CONFIGURATION


paths = {}
shims = {}
for requirejs, script in resources.items():
    if script.js:
        # Main resource js file
        resource_file = portal.unrestrictedTraverse(script.js, None)
        src = None
        if resource_file:
            local_file = resource_to_dir(resource_file)
        else:
            # In case is not found on traverse we dump it from request to file
            response = subrequest(portal.absolute_url() + '/' + script.js)
            local_file = None
            if response.status == 200:
                js_body = response.getBody()
                file_name = uuid.uuid4().hex
                try:
                    os.mkdir(temp_resource_folder)
                except OSError:
                    pass
                local_file = temp_resource_folder + '/' + file_name + '.js'
                if isinstance(js_body, unicode):
                    js_body = js_body.encode('utf-8')
                with open(local_file, 'w') as temp_file:
                    temp_file.write(js_body)

        if local_file:
            # Extract .js
            paths[requirejs] = local_file[:-3]
            exports = script.export
            deps = script.deps
            inits = script.init
            if exports != '' or deps != '' or inits != '':
                shims[requirejs] = {}
                if exports != '' and exports is not None:
                    shims[requirejs]['exports'] = exports
                if deps != '' and deps is not None:
                    shims[requirejs]['deps'] = deps.split(',')
                if inits != '' and inits is not None:
                    shims[requirejs]['init'] = inits
        else:
            print "No file found: " + script.js
    if script.url:
        # Resources available under name-url name
        paths[requirejs + '-url'] = resource_to_dir(
            portal.unrestrictedTraverse(script.url)
        )


# LESS CONFIGURATION

modify_vars = {}
modify_vars['sitePath'] = '/'
modify_vars['isPlone'] = 'false'
modify_vars['isMockup'] = 'false'
modify_vars['staticPath'] = '\'' + os.path.join(
    os.path.dirname(CMFPlone.__file__),
    'static') + '\''
if HAS_BARCELONETA:
    modify_vars['barcelonetaPath'] = '\'' + os.path.join(
        os.path.dirname(plonetheme.barceloneta.__file__),
        'theme',
    ) + '\''

less_vars_params = {
    'site_url': 'LOCAL',
}

# Storing variables to use them on further vars
for name, value in lessvariables.items():
    less_vars_params[name] = value

for name, value in lessvariables.items():
    t = value.format(**less_vars_params)
    if 'LOCAL' in t:
        t_object = portal.unrestrictedTraverse(
            str(t.replace('LOCAL/', '').replace('\\"', '')),
            None
        )
        if t_object:
            t_file = resource_to_dir(t_object)
            t_file = t_file.replace(os.getcwd() + '/', '')
            modify_vars[name] = "'%s/'" % t_file
        else:
            print "No file found: " + \
                str(t.replace('LOCAL/', '').replace('\\"', ''))  #
    else:
        modify_vars[name] = t

# Path to search for less
less_paths = []

# To replace later with sed
less_directories = {}

for name, value in resources.items():
    for css in value.css:
        # less vars can't have dots on it
        local_src = portal.unrestrictedTraverse(css, None)
        extension = css.split('.')[-1]
        if local_src:
            local_file = resource_to_dir(local_src, file_type=extension)
        else:
            # In case is not found on traverse we dump it from request to file
            response = subrequest(portal.absolute_url() + '/' + css)
            local_file = None
            if response.status == 200:
                css_body = response.getBody()
                file_name = uuid.uuid4().hex
                try:
                    os.mkdir(temp_resource_folder)
                except OSError:
                    pass
                local_file = temp_resource_folder + '/' + file_name + '.js'
                temp_file = open(local_file, 'w')
                if isinstance(css_body, unicode):
                    css_body = css_body.encode('utf-8')
                temp_file.write(css_body)
                temp_file.close()

        if local_file:
            ld_key = css.rsplit('/', 1)[0]
            less_directories[ld_key] = local_file.rsplit('/', 1)[0].replace(
                os.getcwd() + '/',
                ''
            )
            # local_file = local_file.replace(os.getcwd(), '')
            # relative = ''
            # for i in range(len(local_file.split('/'))):
            #     relative += '../'
            # modify_vars[name.replace('.', '_')] = "'%s'" % local_file  # noqa
            modify_vars[name.replace('.', '_')] = "'{0}'".format(
                local_file.split('/')[-1]
            )
            if '/'.join(local_file.split('/')[:-1]) not in less_paths:
                less_paths.append('/'.join(local_file.split('/')[:-1]))
        else:
            print 'No file found: ' + css

# BUNDLE LOOP

require_configs = ''
uglify_cfgs_final = ''
less_cfgs_final = []
sourceMap_url = ''
sed_cfg_final = ''
watch_files = []
sed_count = 0
bundle_grunt_tasks = ''


for bkey, bundle in bundles.items():
    css_target_path = css_target_name = ''
    js_target_path = js_target_name = ''

    if compile_path:
        target_name = bundle.__prefix__.split('/').pop()
        css_target_name = target_name + 'min.css'
        js_target_name = target_name + 'min.js'
        css_target_path = js_target_path = os.path.abspath(compile_path)
    else:
        print('"{0}" bundles compiles paths/filename'.format(bkey))
        if bundle.csscompilation:
            css_compilation = bundle.csscompilation.split('/')
            css_target_name = css_compilation[-1]
            css_target_path = resource_to_dir(portal.unrestrictedTraverse(
                '/'.join(css_compilation[:-1])))
            print('- css path: {0}'.format(css_target_path))
            print('- css name: {0}'.format(css_target_name))
        if bundle.jscompilation:
            js_compilation = bundle.jscompilation.split('/')
            js_target_name = js_compilation[-1]
            js_target_path = resource_to_dir(
                portal.unrestrictedTraverse(
                    '/'.join(js_compilation[:-1])
                )
            )
            print('- js path:  {0}'.format(js_target_path))
            print('- js name:  {0}'.format(js_target_name))
    if bundle.compile:
        less_files = {}
        js_files = []
        js_resources = []
        sed_task_ids = []
        for resource in bundle.resources:
            res_obj = resources[resource]
            if res_obj.js:
                js_object = portal.unrestrictedTraverse(res_obj.js, None)
                if js_object:
                    main_js_path = resource_to_dir(js_object)
                    target_path = resource_to_dir(
                        portal.unrestrictedTraverse(res_obj.js))
                    target_path = '/'.join(target_path.split('/')[:-1])
                    watch_files.append(main_js_path)
                    rjs_paths = paths.copy()
                    if bundle.stub_js_modules:
                        for stub in bundle.stub_js_modules:
                            rjs_paths[stub] = 'empty:'
                    rc = REQUIREJS_CONFIG_TEMPLATE.format(
                        bkey=resource,
                        paths=json.dumps(rjs_paths, indent=22, sort_keys=True),
                        shims=json.dumps(shims),
                        name=main_js_path,
                        out=target_path + '/' + resource + '-compiled.js'
                    )
                    require_configs += rc
                    js_files.append(target_path + '/' +
                                    resource + '-compiled.js')
                    js_resources.append(resource)

            if res_obj.css:
                if not css_target_path:
                    raise KeyError(
                        'Missing or empty <value key="csscompilation" /> '
                        'in {}'.format(bundle.__prefix__))

                for css_file in res_obj.css:
                    css = portal.unrestrictedTraverse(css_file, None)
                    if not css:
                        print "No file found: " + css_file
                        continue
                    # We count how many folders to bundle to plone
                    elements = len(css_file.split('/'))
                    relative_paths = '../' * (elements - 1)

                    main_css_path = resource_to_dir(css)
                    dest_path = '{}/{}'.format(
                        css_target_path, css_target_name)
                    less_files.setdefault(dest_path, [])
                    less_files[dest_path].append(main_css_path)
                    sourceMap_url = css_target_name + '.map'
                    watch_files.append(main_css_path)
                    # replace urls

                    for webpath, direc in less_directories.items():
                        sed_id = 'sed' + str(sed_count)
                        sed_task_ids.append('sed:{0}'.format(sed_id))
                        sed_cfg_final += SED_CONFIG_TEMPLATE.format(
                            path=css_target_path + '/' + css_target_name,
                            name=sed_id,
                            pattern=direc,
                            destination=relative_paths + webpath)
                        sed_count += 1

                    # replace the final missing paths
                    sed_id = 'sed' + str(sed_count)
                    sed_task_ids.append('sed:{0}'.format(sed_id))
                    sed_cfg_final += SED_CONFIG_TEMPLATE.format(
                        path=css_target_path + '/' + css_target_name,
                        name=sed_id,
                        pattern=os.getcwd(),
                        destination='')
                    sed_count += 1

        if less_files:
            less_cfgs_final.append(LESS_CONFIG_TEMPLATE.format(
                name=bkey,
                files=json.dumps(less_files, indent=16),
                sourcemap_url=sourceMap_url,
                base_path=os.getcwd()))

        if js_files:
            if not js_target_path:
                raise KeyError(
                    'Missing or empty <value key="jscompilation" /> '
                    'in {}'.format(bundle.__prefix__))

            uc = UGLIFY_CONFIG_TEMPLATE.format(
                bkey=bkey,
                destination=js_target_path + '/' + js_target_name,
                files=json.dumps(js_files)
            )
            uglify_cfgs_final += uc

        requirejs_tasks = ''
        if js_resources:
            requirejs_tasks = ','.join(
                ['"requirejs:' + r + '"' for r in js_resources]
            )

        # collect tasks in order
        tasks = []
        for js_res in js_resources:
            tasks.append('requirejs:{0}'.format(js_res))
        if less_files:
            tasks.append('less:{0}'.format(bkey))
        tasks += sed_task_ids
        if js_files:
            tasks.append('uglify:{0}'.format(bkey))
        bundle_grunt_tasks += COMPILE_TASK_TEMPLATE.format(
            name=bkey,
            tasks=json.dumps(tasks)
        )

with open('Gruntfile.js', 'w') as gruntfile:
    gruntfile.write(
        GRUNTFILE_TEMPLATE.format(
            less=','.join(less_cfgs_final),
            lesspaths=json.dumps(sorted(less_paths), indent=12),
            modifyvars=json.dumps(
                modify_vars,
                indent=12,
                sort_keys=True
            ).replace('\\\\\\', '\\'),  # replace 3 backslash by one.
            requirejs=require_configs,
            uglify=uglify_cfgs_final,
            sed=sed_cfg_final,
            files=json.dumps(watch_files),
            bundleTasks=bundle_grunt_tasks
        )
    )
