# from typing import List, Dict, Tuple, Optional
#
# from django.db import models
#
# import stringcase
#
# from django_koldar_utils.django_toolbox import django_helpers
# from django_koldar_utils.graphql_toolsbox import error_codes
# from django_koldar_utils.graphql_toolsbox.GraphQLAppError import GraphQLAppError
# from django_koldar_utils.graphql_toolsbox.GraphQLHelper import GraphQLHelper
# from django_graphene_crud_generator.crud_generator.contexts import CRUDRuntimeContext, CRUDBuildContext
# from django_koldar_utils.graphql_toolsbox.graphql_types import TDjangoModelType, TGrapheneArgument
#
#
# class CreateMutationViaSingleInputMixIn:
#
#     def _get_fields_to_check(self, runtime_context: CRUDRuntimeContext) -> List[str]:
#         return list(map(lambda x: x.name, django_helpers.get_unique_field_names(runtime_context.build_context.django_type)))
#
#     def _create_mutation_input_parameter(self, build_context: CRUDBuildContext) -> str:
#         """
#         Name of the parameter in create mutation that defines the element to add
#         """
#         return stringcase.camelcase(build_context.django_type.__name__)
#
#     def _create_mutation_parameters(self, build_context: CRUDBuildContext) -> Dict[str, TGrapheneArgument]:
#         result = dict()
#         input_name = self._create_mutation_input_parameter(build_context)
#         result[input_name] = GraphQLHelper.argument_required_input(input_type=build_context.graphene_input_type)
#         return result
#
#     def _check_if_object_exists(self, django_type: TDjangoModelType, runtime_context: CRUDRuntimeContext) -> Tuple[bool, Optional[models.Model]]:
#         input_name = self._create_mutation_input_parameter(runtime_context.build_context)
#         input = runtime_context.kwargs[input_name]
#         d = dict()
#         available_field = django_helpers.get_primitive_fields(django_type)
#         for f in self._get_fields_to_check(runtime_context):
#             if f not in available_field:
#                 # the field in the django model is not available in the associated graphene input.
#                 # input is generated by the user, hence sometimes the user creates an input which do not have a field
#                 continue
#             d[f] = getattr(input, f)
#         try:
#             result = django_type._default_manager.get(**d)
#             return True, result
#         except:
#             return False, None
#
#     def _add_new_object_in_database(self, django_type: TDjangoModelType, runtime_context: CRUDRuntimeContext) -> any:
#         """
#         Adds a new object in the database. You are ensured that the object does not yet exist in the database
#
#         :param django_type: type of the model to fetch
#         :param info: graphql info value
#         :param args: graphql args
#         :param kwargs: graphql kwargs
#         :return: anything you want. It should repersents the added row though
#         """
#         input_name = self._create_mutation_input_parameter(runtime_context.build_context)
#         input_dict = runtime_context.kwargs[input_name]
#         # create argumejnt and omits the None values
#         create_args = {k: v for k, v in dict(input_dict).items() if v is not None}
#         result = django_type._default_manager.create(**create_args)
#         return result, create_args
#
#     def _check_new_object_return_value(self, result: any, django_type: TDjangoModelType,
#                                        runtime_context: CRUDRuntimeContext):
#         value, create_args = result
#         if value is None:
#             raise GraphQLAppError(error_codes.CREATION_FAILED, object=django_type.__name__, values=create_args)