# coding: utf-8

"""
    SnapTrade

    Connect brokerage accounts to your app for live positions and trading

    The version of the OpenAPI document: 1.0.0
    Contact: api@snaptrade.com
    Created by: https://snaptrade.com/
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from snaptrade_client import schemas  # noqa: F401


class MlegTradeForm(
    schemas.DictSchema
):
    """
    This class is auto generated by Konfig (https://konfigthis.com)

    Inputs for placing a multi-leg order with the brokerage.
    """


    class MetaOapg:
        required = {
            "time_in_force",
            "legs",
            "order_type",
        }
        
        class properties:
        
            @staticmethod
            def order_type() -> typing.Type['MlegOrderTypeStrict']:
                return MlegOrderTypeStrict
        
            @staticmethod
            def time_in_force() -> typing.Type['TimeInForceStrict']:
                return TimeInForceStrict
            
            
            class legs(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    @staticmethod
                    def items() -> typing.Type['MlegLeg']:
                        return MlegLeg
            
                def __new__(
                    cls,
                    arg: typing.Union[typing.Tuple['MlegLeg'], typing.List['MlegLeg']],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'legs':
                    return super().__new__(
                        cls,
                        arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> 'MlegLeg':
                    return super().__getitem__(i)
            
            
            class limit_price(
                schemas.StrBase,
                schemas.NoneBase,
                schemas.Schema,
                schemas.NoneStrMixin
            ):
            
            
                class MetaOapg:
                    format = 'decimal'
            
            
                def __new__(
                    cls,
                    *args: typing.Union[None, str, ],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'limit_price':
                    return super().__new__(
                        cls,
                        *args,
                        _configuration=_configuration,
                    )
            
            
            class stop_price(
                schemas.StrBase,
                schemas.NoneBase,
                schemas.Schema,
                schemas.NoneStrMixin
            ):
            
            
                class MetaOapg:
                    format = 'decimal'
            
            
                def __new__(
                    cls,
                    *args: typing.Union[None, str, ],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'stop_price':
                    return super().__new__(
                        cls,
                        *args,
                        _configuration=_configuration,
                    )
        
            @staticmethod
            def price_effect() -> typing.Type['MlegPriceEffectStrictNullable']:
                return MlegPriceEffectStrictNullable
            __annotations__ = {
                "order_type": order_type,
                "time_in_force": time_in_force,
                "legs": legs,
                "limit_price": limit_price,
                "stop_price": stop_price,
                "price_effect": price_effect,
            }
    
    time_in_force: 'TimeInForceStrict'
    legs: MetaOapg.properties.legs
    order_type: 'MlegOrderTypeStrict'
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["order_type"]) -> 'MlegOrderTypeStrict': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["time_in_force"]) -> 'TimeInForceStrict': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["legs"]) -> MetaOapg.properties.legs: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["limit_price"]) -> MetaOapg.properties.limit_price: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["stop_price"]) -> MetaOapg.properties.stop_price: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["price_effect"]) -> 'MlegPriceEffectStrictNullable': ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["order_type", "time_in_force", "legs", "limit_price", "stop_price", "price_effect", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["order_type"]) -> 'MlegOrderTypeStrict': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["time_in_force"]) -> 'TimeInForceStrict': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["legs"]) -> MetaOapg.properties.legs: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["limit_price"]) -> typing.Union[MetaOapg.properties.limit_price, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["stop_price"]) -> typing.Union[MetaOapg.properties.stop_price, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["price_effect"]) -> typing.Union['MlegPriceEffectStrictNullable', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["order_type", "time_in_force", "legs", "limit_price", "stop_price", "price_effect", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *args: typing.Union[dict, frozendict.frozendict, ],
        time_in_force: 'TimeInForceStrict',
        legs: typing.Union[MetaOapg.properties.legs, list, tuple, ],
        order_type: 'MlegOrderTypeStrict',
        limit_price: typing.Union[MetaOapg.properties.limit_price, None, str, schemas.Unset] = schemas.unset,
        stop_price: typing.Union[MetaOapg.properties.stop_price, None, str, schemas.Unset] = schemas.unset,
        price_effect: typing.Union['MlegPriceEffectStrictNullable', schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'MlegTradeForm':
        return super().__new__(
            cls,
            *args,
            time_in_force=time_in_force,
            legs=legs,
            order_type=order_type,
            limit_price=limit_price,
            stop_price=stop_price,
            price_effect=price_effect,
            _configuration=_configuration,
            **kwargs,
        )

from snaptrade_client.model.mleg_leg import MlegLeg
from snaptrade_client.model.mleg_order_type_strict import MlegOrderTypeStrict
from snaptrade_client.model.mleg_price_effect_strict_nullable import MlegPriceEffectStrictNullable
from snaptrade_client.model.time_in_force_strict import TimeInForceStrict
