# do not import all endpoints into this module because that uses a lot of memory and stack frames
# if you need the ability to import all endpoints from this module, import them with
# from snaptrade_client.apis.path_to_api import path_to_api

import enum


class PathValues(str, enum.Enum):
    _ = "/"
    SNAP_TRADE_REGISTER_USER = "/snapTrade/registerUser"
    SNAP_TRADE_LOGIN = "/snapTrade/login"
    SNAP_TRADE_LIST_USERS = "/snapTrade/listUsers"
    SNAP_TRADE_DELETE_USER = "/snapTrade/deleteUser"
    SNAP_TRADE_RESET_USER_SECRET = "/snapTrade/resetUserSecret"
    AUTHORIZATIONS_AUTHORIZATION_ID_RETURN_RATES = "/authorizations/{authorizationId}/returnRates"
    AUTHORIZATIONS = "/authorizations"
    AUTHORIZATIONS_AUTHORIZATION_ID = "/authorizations/{authorizationId}"
    AUTHORIZATIONS_AUTHORIZATION_ID_REFRESH = "/authorizations/{authorizationId}/refresh"
    AUTHORIZATIONS_AUTHORIZATION_ID_DISABLE = "/authorizations/{authorizationId}/disable"
    SESSION_EVENTS = "/sessionEvents"
    ACCOUNTS = "/accounts"
    HOLDINGS = "/holdings"
    ACCOUNTS_ACCOUNT_ID_HOLDINGS = "/accounts/{accountId}/holdings"
    ACCOUNTS_ACCOUNT_ID = "/accounts/{accountId}"
    ACCOUNTS_ACCOUNT_ID_BALANCES = "/accounts/{accountId}/balances"
    ACCOUNTS_ACCOUNT_ID_POSITIONS = "/accounts/{accountId}/positions"
    ACCOUNTS_ACCOUNT_ID_ORDERS = "/accounts/{accountId}/orders"
    ACCOUNTS_ACCOUNT_ID_RECENT_ORDERS = "/accounts/{accountId}/recentOrders"
    ACCOUNTS_ACCOUNT_ID_RETURN_RATES = "/accounts/{accountId}/returnRates"
    ACCOUNTS_ACCOUNT_ID_ACTIVITIES = "/accounts/{accountId}/activities"
    ACCOUNTS_ACCOUNT_ID_ORDERS_DETAILS = "/accounts/{accountId}/orders/details"
    ACCOUNTS_ACCOUNT_ID_OPTIONS = "/accounts/{accountId}/options"
    ACCOUNTS_ACCOUNT_ID_OPTIONS_CHAIN = "/accounts/{accountId}/optionsChain"
    ACTIVITIES = "/activities"
    PERFORMANCE_CUSTOM = "/performance/custom"
    ACCOUNTS_ACCOUNT_ID_QUOTES = "/accounts/{accountId}/quotes"
    TRADE_IMPACT = "/trade/impact"
    TRADE_TRADE_ID = "/trade/{tradeId}"
    TRADE_PLACE = "/trade/place"
    ACCOUNTS_ACCOUNT_ID_ORDERS_CANCEL = "/accounts/{accountId}/orders/cancel"
    ACCOUNTS_ACCOUNT_ID_TRADING_BRACKET = "/accounts/{accountId}/trading/bracket"
    ACCOUNTS_ACCOUNT_ID_TRADING_OPTIONS = "/accounts/{accountId}/trading/options"
    ACCOUNTS_ACCOUNT_ID_TRADING_INSTRUMENTS_CRYPTOCURRENCY_PAIRS = "/accounts/{accountId}/trading/instruments/cryptocurrencyPairs"
    ACCOUNTS_ACCOUNT_ID_TRADING_INSTRUMENTS_CRYPTOCURRENCY_PAIRS_INSTRUMENT_SYMBOL_QUOTE = "/accounts/{accountId}/trading/instruments/cryptocurrencyPairs/{instrumentSymbol}/quote"
    ACCOUNTS_ACCOUNT_ID_TRADING_CRYPTO_PREVIEW = "/accounts/{accountId}/trading/crypto/preview"
    ACCOUNTS_ACCOUNT_ID_TRADING_CRYPTO = "/accounts/{accountId}/trading/crypto"
    ACCOUNTS_ACCOUNT_ID_TRADING_CANCEL = "/accounts/{accountId}/trading/cancel"
    ACCOUNTS_ACCOUNT_ID_TRADING_REPLACE = "/accounts/{accountId}/trading/replace"
    SNAP_TRADE_PARTNERS = "/snapTrade/partners"
    ACCOUNTS_ACCOUNT_ID_SYMBOLS = "/accounts/{accountId}/symbols"
    BROKERAGES = "/brokerages"
    BROKERAGES_SLUG_INSTRUMENTS = "/brokerages/{slug}/instruments"
    BROKERAGE_AUTHORIZATION_TYPES = "/brokerageAuthorizationTypes"
    CURRENCIES = "/currencies"
    CURRENCIES_RATES = "/currencies/rates"
    CURRENCIES_RATES_CURRENCY_PAIR = "/currencies/rates/{currencyPair}"
    EXCHANGES = "/exchanges"
    SECURITY_TYPES = "/securityTypes"
    SYMBOLS = "/symbols"
    SYMBOLS_QUERY = "/symbols/{query}"
