/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.processing;

import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.messages.JsonSchemaCoreMessageBundle;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.report.MessageProvider;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import io.ray.shaded.com.google.common.base.Function;
import io.ray.shaded.com.google.common.collect.ImmutableMap;
import io.ray.shaded.com.google.common.collect.Maps;
import java.util.Map;

public final class ProcessorMap<K, IN extends MessageProvider, OUT extends MessageProvider> {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonSchemaCoreMessageBundle.class);
    private final Function<IN, K> keyFunction;
    private final Map<K, Processor<IN, OUT>> processors = Maps.newHashMap();
    private Processor<IN, OUT> defaultProcessor = null;

    public ProcessorMap(Function<IN, K> keyFunction) {
        BUNDLE.checkNotNull(keyFunction, "processing.nullFunction");
        this.keyFunction = keyFunction;
    }

    public ProcessorMap<K, IN, OUT> addEntry(K key, Processor<IN, OUT> processor) {
        BUNDLE.checkNotNull(key, "processing.nullKey");
        BUNDLE.checkNotNull(processor, "processing.nullProcessor");
        this.processors.put(key, processor);
        return this;
    }

    public ProcessorMap<K, IN, OUT> setDefaultProcessor(Processor<IN, OUT> defaultProcessor) {
        BUNDLE.checkNotNull(defaultProcessor, "processing.nullProcessor");
        this.defaultProcessor = defaultProcessor;
        return this;
    }

    public Processor<IN, OUT> getProcessor() {
        return new Mapper(this.processors, this.keyFunction, this.defaultProcessor);
    }

    private static final class Mapper<K, IN extends MessageProvider, OUT extends MessageProvider>
    implements Processor<IN, OUT> {
        private final Map<K, Processor<IN, OUT>> processors;
        private final Function<IN, K> f;
        private final Processor<IN, OUT> defaultProcessor;

        private Mapper(Map<K, Processor<IN, OUT>> processors, Function<IN, K> f, Processor<IN, OUT> defaultProcessor) {
            this.processors = ImmutableMap.copyOf(processors);
            this.f = f;
            this.defaultProcessor = defaultProcessor;
        }

        @Override
        public OUT process(ProcessingReport report, IN input) throws ProcessingException {
            K key = this.f.apply(input);
            Processor<IN, OUT> processor = this.processors.get(key);
            if (processor == null) {
                processor = this.defaultProcessor;
            }
            if (processor == null) {
                throw new ProcessingException(new ProcessingMessage().setMessage(BUNDLE.getMessage("processing.noProcessor")).put("key", key));
            }
            return processor.process(report, input);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("map[").append(this.processors.size()).append(" entries with ");
            if (this.defaultProcessor == null) {
                sb.append("no ");
            }
            return sb.append("default processor]").toString();
        }
    }
}

