# coding: utf-8

import re
import six



from huaweicloudsdkcore.utils.http_utils import sanitize_for_serialization


class ListServiceTypesRequest:


    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    sensitive_list = []

    openapi_types = {
        'x_language': 'str',
        'service_type_code': 'str'
    }

    attribute_map = {
        'x_language': 'X-Language',
        'service_type_code': 'service_type_code'
    }

    def __init__(self, x_language=None, service_type_code=None):
        """ListServiceTypesRequest - a model defined in huaweicloud sdk"""
        
        

        self._x_language = None
        self._service_type_code = None
        self.discriminator = None

        if x_language is not None:
            self.x_language = x_language
        if service_type_code is not None:
            self.service_type_code = service_type_code

    @property
    def x_language(self):
        """Gets the x_language of this ListServiceTypesRequest.

        |忽略大小写，默认 zh_cn：中文 en_us：英文|

        :return: The x_language of this ListServiceTypesRequest.
        :rtype: str
        """
        return self._x_language

    @x_language.setter
    def x_language(self, x_language):
        """Sets the x_language of this ListServiceTypesRequest.

        |忽略大小写，默认 zh_cn：中文 en_us：英文|

        :param x_language: The x_language of this ListServiceTypesRequest.
        :type: str
        """
        self._x_language = x_language

    @property
    def service_type_code(self):
        """Gets the service_type_code of this ListServiceTypesRequest.

        |参数名称：云服务类型编码| |参数的约束及描述：云服务类型编码,最大长度64|

        :return: The service_type_code of this ListServiceTypesRequest.
        :rtype: str
        """
        return self._service_type_code

    @service_type_code.setter
    def service_type_code(self, service_type_code):
        """Sets the service_type_code of this ListServiceTypesRequest.

        |参数名称：云服务类型编码| |参数的约束及描述：云服务类型编码,最大长度64|

        :param service_type_code: The service_type_code of this ListServiceTypesRequest.
        :type: str
        """
        self._service_type_code = service_type_code

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                if attr in self.sensitive_list:
                    result[attr] = "****"
                else:
                    result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        import simplejson as json
        if six.PY2:
            import sys
            reload(sys)
            sys.setdefaultencoding("utf-8")
        return json.dumps(sanitize_for_serialization(self), ensure_ascii=False)

    def __repr__(self):
        """For `print`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ListServiceTypesRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
