# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class JitNetworkAccessPortRule(Model):
    """JitNetworkAccessPortRule.

    All required parameters must be populated in order to send to Azure.

    :param number: Required.
    :type number: int
    :param protocol: Required. Possible values include: 'TCP', 'UDP', 'All'
    :type protocol: str or ~azure.mgmt.security.models.Protocol
    :param allowed_source_address_prefix: Mutually exclusive with the
     "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR,
     for example "192.168.0.3" or "192.168.0.0/16".
    :type allowed_source_address_prefix: str
    :param allowed_source_address_prefixes: Mutually exclusive with the
     "allowedSourceAddressPrefix" parameter.
    :type allowed_source_address_prefixes: list[str]
    :param max_request_access_duration: Required. Maximum duration requests
     can be made for. In ISO 8601 duration format. Minimum 5 minutes, maximum 1
     day
    :type max_request_access_duration: str
    """

    _validation = {
        'number': {'required': True},
        'protocol': {'required': True},
        'max_request_access_duration': {'required': True},
    }

    _attribute_map = {
        'number': {'key': 'number', 'type': 'int'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'allowed_source_address_prefix': {'key': 'allowedSourceAddressPrefix', 'type': 'str'},
        'allowed_source_address_prefixes': {'key': 'allowedSourceAddressPrefixes', 'type': '[str]'},
        'max_request_access_duration': {'key': 'maxRequestAccessDuration', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(JitNetworkAccessPortRule, self).__init__(**kwargs)
        self.number = kwargs.get('number', None)
        self.protocol = kwargs.get('protocol', None)
        self.allowed_source_address_prefix = kwargs.get('allowed_source_address_prefix', None)
        self.allowed_source_address_prefixes = kwargs.get('allowed_source_address_prefixes', None)
        self.max_request_access_duration = kwargs.get('max_request_access_duration', None)
