/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.wasm;

import com.dylibso.chicory.log.Logger;
import com.dylibso.chicory.wasm.ControlTree;
import com.dylibso.chicory.wasm.Encoding;
import com.dylibso.chicory.wasm.Module;
import com.dylibso.chicory.wasm.ParserListener;
import com.dylibso.chicory.wasm.exceptions.ChicoryException;
import com.dylibso.chicory.wasm.exceptions.InvalidException;
import com.dylibso.chicory.wasm.exceptions.MalformedException;
import com.dylibso.chicory.wasm.types.ActiveDataSegment;
import com.dylibso.chicory.wasm.types.ActiveElement;
import com.dylibso.chicory.wasm.types.CodeSection;
import com.dylibso.chicory.wasm.types.CustomSection;
import com.dylibso.chicory.wasm.types.DataCountSection;
import com.dylibso.chicory.wasm.types.DataSection;
import com.dylibso.chicory.wasm.types.DeclarativeElement;
import com.dylibso.chicory.wasm.types.Element;
import com.dylibso.chicory.wasm.types.ElementSection;
import com.dylibso.chicory.wasm.types.Export;
import com.dylibso.chicory.wasm.types.ExportSection;
import com.dylibso.chicory.wasm.types.ExternalType;
import com.dylibso.chicory.wasm.types.FunctionBody;
import com.dylibso.chicory.wasm.types.FunctionImport;
import com.dylibso.chicory.wasm.types.FunctionSection;
import com.dylibso.chicory.wasm.types.FunctionType;
import com.dylibso.chicory.wasm.types.Global;
import com.dylibso.chicory.wasm.types.GlobalImport;
import com.dylibso.chicory.wasm.types.GlobalSection;
import com.dylibso.chicory.wasm.types.ImportSection;
import com.dylibso.chicory.wasm.types.Instruction;
import com.dylibso.chicory.wasm.types.Limits;
import com.dylibso.chicory.wasm.types.Memory;
import com.dylibso.chicory.wasm.types.MemoryImport;
import com.dylibso.chicory.wasm.types.MemoryLimits;
import com.dylibso.chicory.wasm.types.MemorySection;
import com.dylibso.chicory.wasm.types.MutabilityType;
import com.dylibso.chicory.wasm.types.NameCustomSection;
import com.dylibso.chicory.wasm.types.OpCode;
import com.dylibso.chicory.wasm.types.PassiveDataSegment;
import com.dylibso.chicory.wasm.types.PassiveElement;
import com.dylibso.chicory.wasm.types.Section;
import com.dylibso.chicory.wasm.types.StartSection;
import com.dylibso.chicory.wasm.types.Table;
import com.dylibso.chicory.wasm.types.TableImport;
import com.dylibso.chicory.wasm.types.TableSection;
import com.dylibso.chicory.wasm.types.TypeSection;
import com.dylibso.chicory.wasm.types.UnknownCustomSection;
import com.dylibso.chicory.wasm.types.ValueType;
import com.dylibso.chicory.wasm.types.WasmEncoding;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public final class Parser {
    private static final int MAGIC_BYTES = 1836278016;
    private final Map<String, Function<byte[], CustomSection>> customParsers;
    private final BitSet includeSections;
    private final Logger logger;
    public static final long MIN_SIGNED_INT = Integer.MIN_VALUE;
    public static final long MAX_SIGNED_INT = Integer.MAX_VALUE;
    public static final long MIN_UNSIGNED_INT = 0L;
    public static final long MAX_UNSIGNED_INT = 0xFFFFFFFFL;
    public static final long MIN_SIGNED_LONG = Long.MIN_VALUE;
    public static final long MAX_SIGNED_LONG = Long.MAX_VALUE;

    public Parser(Logger logger2) {
        this(logger2, new BitSet());
    }

    public Parser(Logger logger2, BitSet includeSections) {
        this(logger2, includeSections, Map.of("name", NameCustomSection::parse));
    }

    public Parser(Logger logger2, BitSet includeSections, Map<String, Function<byte[], CustomSection>> customParsers) {
        this.logger = Objects.requireNonNull(logger2, "logger");
        this.includeSections = Objects.requireNonNull(includeSections, "includeSections");
        this.customParsers = Map.copyOf(customParsers);
    }

    private ByteBuffer readByteBuffer(InputStream is) {
        try {
            ByteBuffer buffer = ByteBuffer.wrap(is.readAllBytes());
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            return buffer;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to read wasm bytes.", e);
        }
    }

    private void onSection(Module module, Section s) {
        switch (s.sectionId()) {
            case 0: {
                module.addCustomSection((CustomSection)s);
                break;
            }
            case 1: {
                module.setTypeSection((TypeSection)s);
                break;
            }
            case 2: {
                module.setImportSection((ImportSection)s);
                break;
            }
            case 3: {
                module.setFunctionSection((FunctionSection)s);
                break;
            }
            case 4: {
                module.setTableSection((TableSection)s);
                break;
            }
            case 5: {
                module.setMemorySection((MemorySection)s);
                break;
            }
            case 6: {
                module.setGlobalSection((GlobalSection)s);
                break;
            }
            case 7: {
                module.setExportSection((ExportSection)s);
                break;
            }
            case 8: {
                module.setStartSection((StartSection)s);
                break;
            }
            case 9: {
                module.setElementSection((ElementSection)s);
                break;
            }
            case 10: {
                module.setCodeSection((CodeSection)s);
                break;
            }
            case 11: {
                module.setDataSection((DataSection)s);
                break;
            }
            case 12: {
                module.setDataCountSection((DataCountSection)s);
                break;
            }
            default: {
                this.logger.warnf("Ignoring section with id: %d", s.sectionId());
            }
        }
    }

    public Module parseModule(InputStream in) {
        Module module = new Module();
        try {
            this.parse(in, s -> this.onSection(module, s));
        }
        catch (MalformedException e) {
            throw new MalformedException("section size mismatch, unexpected end of section or function, " + e.getMessage(), e);
        }
        return module;
    }

    private static int readInt(ByteBuffer buffer) {
        if (buffer.remaining() < 4) {
            throw new MalformedException("length out of bounds");
        }
        return buffer.getInt();
    }

    private static byte readByte(ByteBuffer buffer) {
        if (!buffer.hasRemaining()) {
            throw new MalformedException("length out of bounds");
        }
        return buffer.get();
    }

    private static void readBytes(ByteBuffer buffer, byte[] dest) {
        if (buffer.remaining() < dest.length) {
            throw new MalformedException("length out of bounds");
        }
        buffer.get(dest);
    }

    void parse(InputStream in, ParserListener listener) {
        Objects.requireNonNull(listener, "listener");
        SectionsValidator validator = new SectionsValidator();
        ByteBuffer buffer = this.readByteBuffer(in);
        int magicNumber = Parser.readInt(buffer);
        if (magicNumber != 1836278016) {
            throw new MalformedException("magic header not detected, found: " + magicNumber + " expected: 1836278016");
        }
        int version = Parser.readInt(buffer);
        if (version != 1) {
            throw new MalformedException("unknown binary version, found: " + version + " expected: 1");
        }
        boolean firstTime = true;
        block15: while (buffer.hasRemaining()) {
            byte sectionId = Parser.readByte(buffer);
            long sectionSize = Parser.readVarUInt32(buffer);
            validator.validateSectionType(sectionId);
            if (this.shouldParseSection(sectionId)) {
                switch (sectionId) {
                    case 0: {
                        CustomSection customSection = this.parseCustomSection(buffer, sectionSize, firstTime);
                        firstTime = false;
                        listener.onSection(customSection);
                        continue block15;
                    }
                    case 1: {
                        TypeSection typeSection = Parser.parseTypeSection(buffer);
                        listener.onSection(typeSection);
                        continue block15;
                    }
                    case 2: {
                        ImportSection importSection = Parser.parseImportSection(buffer);
                        listener.onSection(importSection);
                        continue block15;
                    }
                    case 3: {
                        FunctionSection funcSection = Parser.parseFunctionSection(buffer);
                        listener.onSection(funcSection);
                        continue block15;
                    }
                    case 4: {
                        TableSection tableSection = Parser.parseTableSection(buffer);
                        listener.onSection(tableSection);
                        continue block15;
                    }
                    case 5: {
                        MemorySection memorySection = Parser.parseMemorySection(buffer);
                        listener.onSection(memorySection);
                        continue block15;
                    }
                    case 6: {
                        GlobalSection globalSection = Parser.parseGlobalSection(buffer);
                        listener.onSection(globalSection);
                        continue block15;
                    }
                    case 7: {
                        ExportSection exportSection = Parser.parseExportSection(buffer);
                        listener.onSection(exportSection);
                        continue block15;
                    }
                    case 8: {
                        StartSection startSection = Parser.parseStartSection(buffer);
                        listener.onSection(startSection);
                        continue block15;
                    }
                    case 9: {
                        ElementSection elementSection = Parser.parseElementSection(buffer, sectionSize);
                        listener.onSection(elementSection);
                        continue block15;
                    }
                    case 10: {
                        CodeSection codeSection = Parser.parseCodeSection(buffer);
                        listener.onSection(codeSection);
                        continue block15;
                    }
                    case 11: {
                        DataSection dataSection = Parser.parseDataSection(buffer);
                        listener.onSection(dataSection);
                        continue block15;
                    }
                    case 12: {
                        DataCountSection dataCountSection = Parser.parseDataCountSection(buffer);
                        listener.onSection(dataCountSection);
                        continue block15;
                    }
                }
                throw new MalformedException("section size mismatch, malformed section id " + sectionId);
            }
            this.logger.info("Skipping Section with ID due to configuration: " + sectionId);
            buffer.position((int)((long)buffer.position() + sectionSize));
        }
    }

    public void includeSection(int sectionId) {
        this.includeSections.set(sectionId);
    }

    private boolean shouldParseSection(int sectionId) {
        if (this.includeSections.isEmpty()) {
            return true;
        }
        return this.includeSections.get(sectionId);
    }

    private CustomSection parseCustomSection(ByteBuffer buffer, long sectionSize, boolean checkMalformed) {
        int sectionPos = buffer.position();
        String name = Parser.readName(buffer, checkMalformed);
        long size = sectionSize - (long)(buffer.position() - sectionPos);
        if (size < 0L) {
            throw new MalformedException("unexpected end");
        }
        byte[] bytes = new byte[(int)size];
        Parser.readBytes(buffer, bytes);
        Function<byte[], CustomSection> parser = this.customParsers.get(name);
        return parser == null ? new UnknownCustomSection(name, bytes) : parser.apply(bytes);
    }

    private static TypeSection parseTypeSection(ByteBuffer buffer) {
        long typeCount = Parser.readVarUInt32(buffer);
        TypeSection typeSection = new TypeSection((int)typeCount);
        int i2 = 0;
        while ((long)i2 < typeCount) {
            long form = Parser.readVarUInt32(buffer);
            if (form > 127L) {
                throw new MalformedException("integer representation too long");
            }
            if (form != 96L) {
                throw new MalformedException("We don't support non func types. Form " + String.format("0x%02X", form) + " was given but we expected 0x60");
            }
            int paramCount = (int)Parser.readVarUInt32(buffer);
            ValueType[] params = new ValueType[paramCount];
            for (int j = 0; j < paramCount; ++j) {
                params[j] = ValueType.forId((int)Parser.readVarUInt32(buffer));
            }
            int returnCount = (int)Parser.readVarUInt32(buffer);
            ValueType[] returns = new ValueType[returnCount];
            for (int j = 0; j < returnCount; ++j) {
                returns[j] = ValueType.forId((int)Parser.readVarUInt32(buffer));
            }
            typeSection.addFunctionType(FunctionType.of(params, returns));
            ++i2;
        }
        return typeSection;
    }

    private static ImportSection parseImportSection(ByteBuffer buffer) {
        long importCount = Parser.readVarUInt32(buffer);
        ImportSection importSection = new ImportSection((int)importCount);
        int i2 = 0;
        while ((long)i2 < importCount) {
            ExternalType descType;
            String moduleName = Parser.readName(buffer);
            String importName = Parser.readName(buffer);
            try {
                descType = ExternalType.byId((int)Parser.readVarUInt32(buffer));
            }
            catch (Exception e) {
                throw new MalformedException("malformed import kind", e);
            }
            switch (descType) {
                case FUNCTION: {
                    if (moduleName.isEmpty() && importName.isEmpty()) {
                        throw new MalformedException("malformed import kind");
                    }
                    importSection.addImport(new FunctionImport(moduleName, importName, (int)Parser.readVarUInt32(buffer)));
                    break;
                }
                case TABLE: {
                    long rawTableType = Parser.readVarUInt32(buffer);
                    assert (rawTableType == 112L || rawTableType == 111L);
                    ValueType tableType = rawTableType == 112L ? ValueType.FuncRef : ValueType.ExternRef;
                    byte limitType = Parser.readByte(buffer);
                    assert (limitType == 0 || limitType == 1);
                    int min = (int)Parser.readVarUInt32(buffer);
                    Limits limits = limitType > 0 ? new Limits(min, Parser.readVarUInt32(buffer)) : new Limits(min);
                    importSection.addImport(new TableImport(moduleName, importName, tableType, limits));
                    break;
                }
                case MEMORY: {
                    byte limitType = Parser.readByte(buffer);
                    assert (limitType == 0 || limitType == 1);
                    int min = (int)Math.min(65536L, Parser.readVarUInt32(buffer));
                    MemoryLimits limits = limitType > 0 ? new MemoryLimits(min, (int)Math.min(65536L, Parser.readVarUInt32(buffer))) : new MemoryLimits(min, 65536);
                    importSection.addImport(new MemoryImport(moduleName, importName, limits));
                    break;
                }
                case GLOBAL: {
                    ValueType globalValType = ValueType.forId((int)Parser.readVarUInt32(buffer));
                    MutabilityType globalMut = MutabilityType.forId(Parser.readByte(buffer));
                    importSection.addImport(new GlobalImport(moduleName, importName, globalMut, globalValType));
                    break;
                }
                default: {
                    throw new MalformedException("malformed import kind");
                }
            }
            ++i2;
        }
        return importSection;
    }

    private static FunctionSection parseFunctionSection(ByteBuffer buffer) {
        long functionCount = Parser.readVarUInt32(buffer);
        FunctionSection functionSection = new FunctionSection((int)functionCount);
        int i2 = 0;
        while ((long)i2 < functionCount) {
            long typeIndex = Parser.readVarUInt32(buffer);
            functionSection.addFunctionType((int)typeIndex);
            ++i2;
        }
        return functionSection;
    }

    private static TableSection parseTableSection(ByteBuffer buffer) {
        long tableCount = Parser.readVarUInt32(buffer);
        TableSection tableSection = new TableSection((int)tableCount);
        int i2 = 0;
        while ((long)i2 < tableCount) {
            ValueType tableType = ValueType.refTypeForId((int)Parser.readVarUInt32(buffer));
            byte limitType = Parser.readByte(buffer);
            if (limitType != 0 && limitType != 1) {
                throw new MalformedException("integer representation too long, integer too large");
            }
            long min = Parser.readVarUInt32(buffer);
            Limits limits = limitType > 0 ? new Limits(min, Parser.readVarUInt32(buffer)) : new Limits(min);
            tableSection.addTable(new Table(tableType, limits));
            ++i2;
        }
        return tableSection;
    }

    private static MemorySection parseMemorySection(ByteBuffer buffer) {
        long memoryCount = Parser.readVarUInt32(buffer);
        MemorySection memorySection = new MemorySection((int)memoryCount);
        int i2 = 0;
        while ((long)i2 < memoryCount) {
            MemoryLimits limits = Parser.parseMemoryLimits(buffer);
            memorySection.addMemory(new Memory(limits));
            ++i2;
        }
        return memorySection;
    }

    private static MemoryLimits parseMemoryLimits(ByteBuffer buffer) {
        byte limitType = Parser.readByte(buffer);
        if (limitType != 0 && limitType != 1) {
            throw new MalformedException("integer representation too long, integer too large");
        }
        int initial = (int)Parser.readVarUInt32(buffer);
        if (limitType != 1) {
            return new MemoryLimits(initial);
        }
        int maximum = (int)Parser.readVarUInt32(buffer);
        return new MemoryLimits(initial, maximum);
    }

    private static GlobalSection parseGlobalSection(ByteBuffer buffer) {
        long globalCount = Parser.readVarUInt32(buffer);
        GlobalSection globalSection = new GlobalSection((int)globalCount);
        int i2 = 0;
        while ((long)i2 < globalCount) {
            ValueType valueType = ValueType.forId((int)Parser.readVarUInt32(buffer));
            MutabilityType mutabilityType = MutabilityType.forId(Parser.readByte(buffer));
            Instruction[] init = Parser.parseExpression(buffer);
            globalSection.addGlobal(new Global(valueType, mutabilityType, List.of(init)));
            ++i2;
        }
        return globalSection;
    }

    private static ExportSection parseExportSection(ByteBuffer buffer) {
        long exportCount = Parser.readVarUInt32(buffer);
        ExportSection exportSection = new ExportSection((int)exportCount);
        int i2 = 0;
        while ((long)i2 < exportCount) {
            String name = Parser.readName(buffer, false);
            ExternalType exportType = ExternalType.byId((int)Parser.readVarUInt32(buffer));
            int index = (int)Parser.readVarUInt32(buffer);
            exportSection.addExport(new Export(name, index, exportType));
            ++i2;
        }
        return exportSection;
    }

    private static StartSection parseStartSection(ByteBuffer buffer) {
        return new StartSection(Parser.readVarUInt32(buffer));
    }

    private static ElementSection parseElementSection(ByteBuffer buffer, long sectionSize) {
        int initialPosition = buffer.position();
        long elementCount = Parser.readVarUInt32(buffer);
        ElementSection elementSection = new ElementSection((int)elementCount);
        int i2 = 0;
        while ((long)i2 < elementCount) {
            elementSection.addElement(Parser.parseSingleElement(buffer));
            ++i2;
        }
        if ((long)buffer.position() != (long)initialPosition + sectionSize) {
            throw new MalformedException("section size mismatch");
        }
        return elementSection;
    }

    private static Element parseSingleElement(ByteBuffer buffer) {
        ValueType type;
        int flags = (int)Parser.readVarUInt32(buffer);
        boolean active = (flags & 1) == 0;
        boolean declarative = !active && (flags & 2) != 0;
        boolean passive = !active && !declarative;
        boolean hasTableIdx = active && (flags & 2) != 0;
        boolean alwaysFuncRef = active && !hasTableIdx;
        boolean exprInit = (flags & 4) != 0;
        boolean hasElemKind = !exprInit && !alwaysFuncRef;
        boolean hasRefType = exprInit && !alwaysFuncRef;
        int tableIdx = 0;
        List<Instruction> offset = List.of();
        if (active) {
            if (hasTableIdx) {
                tableIdx = Math.toIntExact(Parser.readVarUInt32(buffer));
            }
            offset = List.of(Parser.parseExpression(buffer));
        }
        if (alwaysFuncRef) {
            type = ValueType.FuncRef;
        } else if (hasElemKind) {
            int ek = (int)Parser.readVarUInt32(buffer);
            switch (ek) {
                case 0: {
                    type = ValueType.FuncRef;
                    break;
                }
                default: {
                    throw new ChicoryException("Invalid element kind");
                }
            }
        } else {
            assert (hasRefType);
            type = ValueType.refTypeForId(Math.toIntExact(Parser.readVarUInt32(buffer)));
        }
        int initCnt = Math.toIntExact(Parser.readVarUInt32(buffer));
        ArrayList<List<Instruction>> inits = new ArrayList<List<Instruction>>(initCnt);
        if (exprInit) {
            for (int i2 = 0; i2 < initCnt; ++i2) {
                inits.add(List.of(Parser.parseExpression(buffer)));
            }
        } else {
            for (int i3 = 0; i3 < initCnt; ++i3) {
                inits.add(List.of(new Instruction(-1, OpCode.REF_FUNC, new long[]{Parser.readVarUInt32(buffer)}), new Instruction(-1, OpCode.END, new long[0])));
            }
        }
        if (declarative) {
            return new DeclarativeElement(type, inits);
        }
        if (passive) {
            return new PassiveElement(type, inits);
        }
        assert (active);
        return new ActiveElement(type, inits, tableIdx, offset);
    }

    private static long[] readFuncIndices(ByteBuffer buffer) {
        long funcIndexCount = Parser.readVarUInt32(buffer);
        long[] funcIndices = new long[(int)funcIndexCount];
        int j = 0;
        while ((long)j < funcIndexCount) {
            funcIndices[j] = Parser.readVarUInt32(buffer);
            ++j;
        }
        return funcIndices;
    }

    private static Instruction[][] readExprs(ByteBuffer buffer) {
        long exprIndexCount = Parser.readVarUInt32(buffer);
        Instruction[][] exprs = new Instruction[(int)exprIndexCount][];
        int j = 0;
        while ((long)j < exprIndexCount) {
            Instruction[] instr2 = Parser.parseExpression(buffer);
            exprs[j] = instr2;
            ++j;
        }
        return exprs;
    }

    private static List<ValueType> parseCodeSectionLocalTypes(ByteBuffer buffer) {
        long distinctTypesCount = Parser.readVarUInt32(buffer);
        ArrayList<ValueType> locals = new ArrayList<ValueType>();
        int i2 = 0;
        while ((long)i2 < distinctTypesCount) {
            long numberOfLocals = Parser.readVarUInt32(buffer);
            if (numberOfLocals > 50000L) {
                throw new MalformedException("too many locals");
            }
            ValueType type = ValueType.forId((int)Parser.readVarUInt32(buffer));
            int j = 0;
            while ((long)j < numberOfLocals) {
                locals.add(type);
                ++j;
            }
            ++i2;
        }
        return locals;
    }

    private static CodeSection parseCodeSection(ByteBuffer buffer) {
        long funcBodyCount = Parser.readVarUInt32(buffer);
        ControlTree root = new ControlTree();
        CodeSection codeSection = new CodeSection((int)funcBodyCount);
        int i2 = 0;
        while ((long)i2 < funcBodyCount) {
            ArrayDeque<Instruction> blockScope = new ArrayDeque<Instruction>();
            int depth = 0;
            long funcEndPoint = Parser.readVarUInt32(buffer) + (long)buffer.position();
            List<ValueType> locals = Parser.parseCodeSectionLocalTypes(buffer);
            ArrayList<Instruction> instructions = new ArrayList<Instruction>();
            boolean lastInstruction = false;
            ControlTree currentControlFlow = null;
            do {
                Instruction instruction = Parser.parseInstruction(buffer);
                boolean bl = lastInstruction = (long)buffer.position() >= funcEndPoint;
                if (instructions.isEmpty()) {
                    currentControlFlow = root.spawn(0, instruction);
                }
                switch (instruction.opcode()) {
                    case MEMORY_INIT: 
                    case DATA_DROP: {
                        codeSection.setRequiresDataCount(true);
                    }
                }
                switch (instruction.opcode()) {
                    case BLOCK: 
                    case LOOP: 
                    case IF: {
                        instruction.setDepth(++depth);
                        blockScope.push(instruction);
                        instruction.setScope((Instruction)blockScope.peek());
                        break;
                    }
                    case END: {
                        instruction.setDepth(depth--);
                        instruction.setScope(blockScope.isEmpty() ? instruction : (Instruction)blockScope.pop());
                        break;
                    }
                    default: {
                        instruction.setDepth(depth);
                    }
                }
                switch (instruction.opcode()) {
                    case BLOCK: 
                    case LOOP: {
                        currentControlFlow = currentControlFlow.spawn(instructions.size(), instruction);
                        break;
                    }
                    case IF: {
                        currentControlFlow = currentControlFlow.spawn(instructions.size(), instruction);
                        int defaultJmp = instructions.size() + 1;
                        currentControlFlow.addCallback(end -> {
                            if (instruction.labelFalse() == defaultJmp) {
                                instruction.setLabelFalse((Integer)end);
                            }
                        });
                        instruction.setLabelTrue(defaultJmp);
                        instruction.setLabelFalse(defaultJmp);
                        break;
                    }
                    case ELSE: {
                        assert (currentControlFlow.instruction().opcode() == OpCode.IF);
                        currentControlFlow.instruction().setLabelFalse(instructions.size() + 1);
                        currentControlFlow.addCallback(instruction::setLabelTrue);
                        break;
                    }
                    case BR_IF: {
                        instruction.setLabelFalse(instructions.size() + 1);
                    }
                    case BR: {
                        ControlTree reference = currentControlFlow;
                        for (int offset = (int)instruction.operands()[0]; offset > 0; --offset) {
                            if (reference == null) {
                                throw new InvalidException("unknown label");
                            }
                            reference = reference.parent();
                        }
                        reference.addCallback(instruction::setLabelTrue);
                        break;
                    }
                    case BR_TABLE: {
                        instruction.setLabelTable(new int[instruction.operands().length]);
                        int idx = 0;
                        while (idx < instruction.labelTable().length) {
                            ControlTree reference = currentControlFlow;
                            for (int offset = (int)instruction.operands()[idx]; offset > 0; --offset) {
                                if (reference == null) {
                                    throw new InvalidException("unknown label");
                                }
                                reference = reference.parent();
                            }
                            int finalIdx = idx++;
                            reference.addCallback(end -> {
                                instruction.labelTable()[finalIdx] = end;
                            });
                        }
                        break;
                    }
                    case END: {
                        Instruction former;
                        currentControlFlow.setFinalInstructionNumber(instructions.size(), instruction);
                        currentControlFlow = currentControlFlow.parent();
                        if (!lastInstruction || instructions.size() <= 1 || (former = instructions.get(instructions.size() - 1)).opcode() != OpCode.END) break;
                        instruction.setScope(former.scope());
                    }
                }
                if (lastInstruction && instruction.opcode() != OpCode.END) {
                    throw new MalformedException("END opcode expected, section size mismatch");
                }
                instructions.add(instruction);
            } while (!lastInstruction);
            FunctionBody functionBody = new FunctionBody(locals, instructions);
            codeSection.addFunctionBody(functionBody);
            ++i2;
        }
        return codeSection;
    }

    private static DataSection parseDataSection(ByteBuffer buffer) {
        long dataSegmentCount = Parser.readVarUInt32(buffer);
        DataSection dataSection = new DataSection((int)dataSegmentCount);
        int i2 = 0;
        while ((long)i2 < dataSegmentCount) {
            long mode = Parser.readVarUInt32(buffer);
            if (mode == 0L) {
                Instruction[] offset = Parser.parseExpression(buffer);
                byte[] data = new byte[(int)Parser.readVarUInt32(buffer)];
                Parser.readBytes(buffer, data);
                dataSection.addDataSegment(new ActiveDataSegment(0L, List.of(offset), data));
            } else if (mode == 1L) {
                byte[] data = new byte[(int)Parser.readVarUInt32(buffer)];
                Parser.readBytes(buffer, data);
                dataSection.addDataSegment(new PassiveDataSegment(data));
            } else if (mode == 2L) {
                long memoryId = Parser.readVarUInt32(buffer);
                Instruction[] offset = Parser.parseExpression(buffer);
                byte[] data = new byte[(int)Parser.readVarUInt32(buffer)];
                Parser.readBytes(buffer, data);
                dataSection.addDataSegment(new ActiveDataSegment(memoryId, List.of(offset), data));
            } else {
                throw new ChicoryException("Failed to parse data segment with data mode: " + mode);
            }
            ++i2;
        }
        return dataSection;
    }

    private static DataCountSection parseDataCountSection(ByteBuffer buffer) {
        long dataCount = Parser.readVarUInt32(buffer);
        return new DataCountSection((int)dataCount);
    }

    private static Instruction parseInstruction(ByteBuffer buffer) {
        OpCode op;
        int address2 = buffer.position();
        int b = Parser.readByte(buffer) & 0xFF;
        if (b == 252) {
            b = (int)(64512L + Parser.readVarUInt32(buffer));
        }
        if ((op = OpCode.byOpCode(b)) == null) {
            throw new MalformedException("illegal opcode, op value " + b);
        }
        WasmEncoding[] signature = OpCode.getSignature(op);
        switch (op) {
            case MEMORY_GROW: 
            case MEMORY_SIZE: {
                byte zero2 = Parser.readByte(buffer);
                if (zero2 == 0) break;
                throw new MalformedException("zero byte expected");
            }
        }
        if (signature.length == 0) {
            return new Instruction(address2, op, new long[0]);
        }
        ArrayList<Long> operands = new ArrayList<Long>();
        block11: for (WasmEncoding sig : signature) {
            switch (sig) {
                case VARUINT: {
                    operands.add(Parser.readVarUInt32(buffer));
                    continue block11;
                }
                case VARSINT32: {
                    operands.add(Parser.readVarSInt32(buffer));
                    continue block11;
                }
                case VARSINT64: {
                    operands.add(Parser.readVarSInt64(buffer));
                    continue block11;
                }
                case FLOAT64: {
                    operands.add(Parser.readFloat64(buffer));
                    continue block11;
                }
                case FLOAT32: {
                    operands.add(Parser.readFloat32(buffer));
                    continue block11;
                }
                case VEC_VARUINT: {
                    int vcount = (int)Parser.readVarUInt32(buffer);
                    for (int j = 0; j < vcount; ++j) {
                        operands.add(Parser.readVarUInt32(buffer));
                    }
                    continue block11;
                }
            }
        }
        long[] operandsArray = new long[operands.size()];
        for (int i2 = 0; i2 < operands.size(); ++i2) {
            operandsArray[i2] = (Long)operands.get(i2);
        }
        Parser.verifyAlignment(op, operandsArray);
        return new Instruction(address2, op, operandsArray);
    }

    private static void verifyAlignment(OpCode op, long[] operands) {
        int align = -1;
        switch (op) {
            case I32_LOAD8_U: 
            case I32_LOAD8_S: 
            case I64_LOAD8_U: 
            case I64_LOAD8_S: 
            case I32_STORE8: 
            case I64_STORE8: {
                align = 8;
                break;
            }
            case I32_LOAD16_U: 
            case I32_LOAD16_S: 
            case I64_LOAD16_U: 
            case I64_LOAD16_S: 
            case I32_STORE16: 
            case I64_STORE16: {
                align = 16;
                break;
            }
            case I32_LOAD: 
            case F32_LOAD: 
            case I64_LOAD32_U: 
            case I64_LOAD32_S: 
            case I64_STORE32: 
            case I32_STORE: 
            case F32_STORE: {
                align = 32;
                break;
            }
            case I64_LOAD: 
            case F64_LOAD: 
            case I64_STORE: 
            case F64_STORE: {
                align = 64;
            }
        }
        if (align > 0 && !(Math.pow(2.0, operands[0]) <= (double)(align / 8))) {
            throw new InvalidException("alignment must not be larger than natural alignment (" + operands[0] + ")");
        }
    }

    private static Instruction[] parseExpression(ByteBuffer buffer) {
        Instruction i2;
        ArrayList<Instruction> expr2 = new ArrayList<Instruction>();
        while ((i2 = Parser.parseInstruction(buffer)).opcode() != OpCode.END) {
            expr2.add(i2);
        }
        return expr2.toArray(new Instruction[0]);
    }

    public static long readVarUInt32(ByteBuffer buffer) {
        long value2 = Encoding.readUnsignedLeb128(buffer, 5);
        if (value2 < 0L || value2 > 0xFFFFFFFFL) {
            throw new MalformedException("integer too large");
        }
        return value2;
    }

    public static long readVarSInt32(ByteBuffer buffer) {
        long value2 = Encoding.readSigned32Leb128(buffer);
        if (value2 > Integer.MAX_VALUE || value2 < Integer.MIN_VALUE) {
            throw new MalformedException("integer too large");
        }
        return value2;
    }

    public static long readVarSInt64(ByteBuffer buffer) {
        long value2 = Encoding.readSigned64Leb128(buffer);
        if (value2 > Long.MAX_VALUE || value2 < Long.MIN_VALUE) {
            throw new MalformedException("integer too large");
        }
        return value2;
    }

    public static long readFloat64(ByteBuffer buffer) {
        return buffer.getLong();
    }

    public static long readFloat32(ByteBuffer buffer) {
        return Parser.readInt(buffer);
    }

    public static String readName(ByteBuffer buffer) {
        return Parser.readName(buffer, true);
    }

    public static String readName(ByteBuffer buffer, boolean checkMalformed) {
        int length = (int)Parser.readVarUInt32(buffer);
        byte[] bytes = new byte[length];
        try {
            Parser.readBytes(buffer, bytes);
        }
        catch (BufferUnderflowException e) {
            throw new MalformedException("length out of bounds");
        }
        String name = new String(bytes, StandardCharsets.UTF_8);
        if (checkMalformed && !Parser.isValidIdentifier(name)) {
            throw new MalformedException("malformed UTF-8 encoding");
        }
        return name;
    }

    private static boolean isValidIdentifier(String string) {
        return string.chars().allMatch(ch -> ch < 128 || Character.isUnicodeIdentifierPart(ch));
    }

    private static class SectionsValidator {
        private boolean hasStart = false;

        SectionsValidator() {
        }

        public void validateSectionType(byte sectionId) {
            switch (sectionId) {
                case 8: {
                    if (this.hasStart) {
                        throw new MalformedException("unexpected content after last section");
                    }
                    this.hasStart = true;
                }
            }
        }
    }
}

