/*
 * Decompiled with CFR 0.152.
 */
package compiler;

import bridge.ContractInstanceInSDC;
import bridge.SourceLanguage;
import bridge.StorageLayout;
import compiler.ABI;
import compiler.AbstractSolcRunner;
import compiler.StandardSolcRunner;
import compiler.data.Contract;
import compiler.data.ContractSource;
import compiler.data.Error;
import compiler.data.Input;
import compiler.data.Output;
import compiler.data.SolcSettings;
import compiler.data.SolidityOptimization;
import compiler.data.SourceParsed;
import java.io.File;
import java.math.BigInteger;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import utils.Either;
import utils.EitherKt;
import utils.LazyKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001:\u0001/B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u0013J\n\u0010'\u001a\u0004\u0018\u00010 H\u0002J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00130\fH\u0014J\u0014\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020+0*H$J\b\u0010,\u001a\u00020\u0013H$J*\u0010-\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\f0\u00192\b\u0010.\u001a\u0004\u0018\u00010 H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0011\u001a\u0004\b\u0014\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R3\u0010\u0018\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\f0\u00198FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0011\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001d\u0010\u001f\u001a\u0004\u0018\u00010 8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u0011\u001a\u0004\b!\u0010\"\u00a8\u00060"}, d2={"Lcompiler/AbstractSolcRunner;", "", "address", "Ljava/math/BigInteger;", "optimize", "", "runDir", "Ljava/nio/file/Path;", "(Ljava/math/BigInteger;ZLjava/nio/file/Path;)V", "getAddress", "()Ljava/math/BigInteger;", "contractInstances", "", "Lbridge/ContractInstanceInSDC;", "getContractInstances", "()Ljava/util/List;", "contractInstances$delegate", "Lkotlin/Lazy;", "errors", "", "getErrors", "errors$delegate", "getOptimize", "()Z", "result", "Lutils/Either;", "getResult", "()Lutils/Either;", "result$delegate", "getRunDir", "()Ljava/nio/file/Path;", "solOutput", "Lcompiler/data/Output;", "getSolOutput", "()Lcompiler/data/Output;", "solOutput$delegate", "ast", "Lkotlinx/serialization/json/JsonObject;", "file", "compileContracts", "getAllowedPaths", "getContractSource", "", "Lcompiler/AbstractSolcRunner$Source;", "getSolcExecutable", "postProcess", "res", "Source", "Shared"})
@SourceDebugExtension(value={"SMAP\nAbstractSolcRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractSolcRunner.kt\ncompiler/AbstractSolcRunner\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n125#2:130\n152#2,2:131\n154#2:134\n76#2:145\n96#2,2:146\n135#2,9:148\n215#2:157\n216#2:166\n144#2:167\n98#2,3:168\n1#3:133\n1#3:165\n1747#4,3:135\n766#4:138\n857#4,2:139\n1549#4:141\n1620#4,3:142\n766#4:158\n857#4,2:159\n1549#4:161\n1620#4,3:162\n*S KotlinDebug\n*F\n+ 1 AbstractSolcRunner.kt\ncompiler/AbstractSolcRunner\n*L\n48#1:130\n48#1:131,2\n48#1:134\n96#1:145\n96#1:146,2\n97#1:148,9\n97#1:157\n97#1:166\n97#1:167\n96#1:168,3\n97#1:165\n87#1:135,3\n91#1:138\n91#1:139,2\n91#1:141\n91#1:142,3\n102#1:158\n102#1:159,2\n103#1:161\n103#1:162,3\n*E\n"})
public abstract class AbstractSolcRunner {
    @NotNull
    private final BigInteger address;
    private final boolean optimize;
    @Nullable
    private final Path runDir;
    @NotNull
    private final Lazy solOutput$delegate;
    @NotNull
    private final Lazy result$delegate;
    @NotNull
    private final Lazy errors$delegate;
    @NotNull
    private final Lazy contractInstances$delegate;

    public AbstractSolcRunner(@NotNull BigInteger address2, boolean optimize, @Nullable Path runDir) {
        Intrinsics.checkNotNullParameter(address2, "address");
        this.address = address2;
        this.optimize = optimize;
        this.runDir = runDir;
        this.solOutput$delegate = LazyKt.lazy((Function0)new Function0<Output>(this){
            final /* synthetic */ AbstractSolcRunner this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Output invoke() {
                return AbstractSolcRunner.access$compileContracts(this.this$0);
            }
        });
        this.result$delegate = LazyKt.lazy((Function0)new Function0<Either<? extends List<? extends ContractInstanceInSDC>, ? extends List<? extends String>>>(this){
            final /* synthetic */ AbstractSolcRunner this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Either<List<ContractInstanceInSDC>, List<String>> invoke() {
                return AbstractSolcRunner.access$postProcess(this.this$0, this.this$0.getSolOutput());
            }
        });
        this.errors$delegate = LazyKt.lazy((Function0)new Function0<List<? extends String>>(this){
            final /* synthetic */ AbstractSolcRunner this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<String> invoke() {
                return (List)EitherKt.toValue(this.this$0.getResult(), errors.1.INSTANCE, errors.2.INSTANCE);
            }
        });
        this.contractInstances$delegate = LazyKt.lazy((Function0)new Function0<List<? extends ContractInstanceInSDC>>(this){
            final /* synthetic */ AbstractSolcRunner this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<ContractInstanceInSDC> invoke() {
                return (List)EitherKt.toValue(this.this$0.getResult(), contractInstances.1.INSTANCE, contractInstances.2.INSTANCE);
            }
        });
    }

    public /* synthetic */ AbstractSolcRunner(BigInteger bigInteger, boolean bl, Path path, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            BigInteger bigInteger2 = BigInteger.TWO.pow(24);
            Intrinsics.checkNotNullExpressionValue(bigInteger2, "pow(...)");
            bigInteger = bigInteger2;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            path = null;
        }
        this(bigInteger, bl, path);
    }

    @NotNull
    public final BigInteger getAddress() {
        return this.address;
    }

    public final boolean getOptimize() {
        return this.optimize;
    }

    @Nullable
    public final Path getRunDir() {
        return this.runDir;
    }

    @Nullable
    public final Output getSolOutput() {
        Lazy lazy2 = this.solOutput$delegate;
        return (Output)lazy2.getValue();
    }

    @NotNull
    public final Either<List<ContractInstanceInSDC>, List<String>> getResult() {
        Lazy lazy2 = this.result$delegate;
        return (Either)lazy2.getValue();
    }

    @Nullable
    public final JsonObject ast(@NotNull String file) {
        Intrinsics.checkNotNullParameter(file, "file");
        Object object = this.getSolOutput();
        return object != null && (object = ((Output)object).getSources()) != null && (object = (SourceParsed)object.get(file)) != null ? ((SourceParsed)object).getAst() : null;
    }

    @NotNull
    public final List<String> getErrors() {
        Lazy lazy2 = this.errors$delegate;
        return (List)lazy2.getValue();
    }

    @NotNull
    public final List<ContractInstanceInSDC> getContractInstances() {
        Lazy lazy2 = this.contractInstances$delegate;
        return (List)lazy2.getValue();
    }

    @NotNull
    protected abstract Map<String, Source> getContractSource();

    @NotNull
    protected abstract String getSolcExecutable();

    @NotNull
    protected List<String> getAllowedPaths() {
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private final Output compileContracts() {
        void $this$mapTo$iv$iv;
        List<String> allowedPaths = CollectionsKt.toMutableList((Collection)this.getAllowedPaths());
        String[] $this$map$iv = this.getContractSource();
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            ContractSource contractSource;
            void it2;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object k = it2.getKey();
            Source x = (Source)it2.getValue();
            if (x instanceof Source.Literal) {
                contractSource = new ContractSource(((Source.Literal)x).getContractSource(), null, 2, null);
            } else if (x instanceof Source.FromFile) {
                Boolean bl2;
                File file;
                File f = new File(((Source.FromFile)x).getPath());
                File file2 = file = f.getParentFile();
                if (file2 != null) {
                    void parentFile;
                    Intrinsics.checkNotNull(file2);
                    File file3 = file;
                    Object k2 = k;
                    boolean bl3 = false;
                    String string = parentFile.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue(string, "getAbsolutePath(...)");
                    bl2 = allowedPaths.add(string);
                    k = k2;
                } else {
                    bl2 = null;
                }
                contractSource = new ContractSource(null, f, 1, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            collection.add(TuplesKt.to(k, contractSource));
        }
        Map sources = MapsKt.toMap((List)destination$iv$iv);
        Pair[] pairArray = new Pair[2];
        stringArray = new String[]{"abi", "evm.deployedBytecode.object", "evm.bytecode.object", "evm.methodIdentifiers", "evm.deployedBytecode.sourceMap", "storageLayout", "transientStorageLayout"};
        pairArray[0] = TuplesKt.to("*", CollectionsKt.listOf(stringArray));
        pairArray[1] = TuplesKt.to("", CollectionsKt.listOf("ast"));
        Input solidityInput = new Input(null, sources, new SolcSettings(MapsKt.mapOf(TuplesKt.to("*", MapsKt.mapOf(pairArray))), new SolidityOptimization(this.optimize)), 1, null);
        return new StandardSolcRunner(this.getSolcExecutable(), allowedPaths, this.runDir).run(solidityInput);
    }

    /*
     * WARNING - void declaration
     */
    private final Either<List<ContractInstanceInSDC>, List<String>> postProcess(Output res2) {
        void $this$flatMapTo$iv$iv;
        Object destination$iv$iv;
        boolean bl;
        block14: {
            if (res2 == null) {
                return new Either.Left(CollectionsKt.emptyList());
            }
            Iterable $this$any$iv = res2.getErrors();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Error it2 = (Error)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it2.getSeverity(), "error")) continue;
                    bl = true;
                    break block14;
                }
                bl = false;
            }
        }
        if (bl) {
            void $this$mapTo$iv$iv;
            Error it3;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = res2.getErrors();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it3 = (Error)element$iv$iv;
                boolean bl3 = false;
                if (!Intrinsics.areEqual(it3.getSeverity(), "error")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it3 = (Error)item$iv$iv;
                Object object = destination$iv$iv;
                boolean bl4 = false;
                object.add(it3.getMessage());
            }
            return EitherKt.toRight((List)destination$iv$iv);
        }
        int i2 = 0;
        Map<String, Map<String, Contract>> $this$flatMap$iv = res2.getContracts();
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator2 = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$mapNotNullTo$iv$iv;
            Map contracts;
            Map.Entry element$iv$iv;
            Map.Entry bl4 = element$iv$iv = iterator2.next();
            boolean bl5 = false;
            Map $this$mapNotNull$iv = contracts = (Map)bl4.getValue();
            boolean $i$f$mapNotNull = false;
            Map map2 = $this$mapNotNull$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv.entrySet().iterator();
            while (iterator3.hasNext()) {
                ContractInstanceInSDC contractInstanceInSDC;
                Map.Entry element$iv$iv$iv;
                Map.Entry element$iv$iv2 = element$iv$iv$iv = iterator3.next();
                boolean bl6 = false;
                Map.Entry entry = element$iv$iv2;
                boolean bl7 = false;
                String contractName = (String)entry.getKey();
                Contract contract = (Contract)entry.getValue();
                if (Intrinsics.areEqual(contract.getEvm().getBytecode().getObject(), "")) {
                    contractInstanceInSDC = null;
                } else {
                    String string;
                    String string2;
                    BigInteger bigInteger;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    ABI it4;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    Object object = contract.getAbi();
                    boolean $i$f$filter = false;
                    String string3 = $this$filter$iv;
                    Collection destination$iv$iv4 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv3 : $this$filterTo$iv$iv) {
                        it4 = (ABI)element$iv$iv3;
                        boolean bl8 = false;
                        if (!Intrinsics.areEqual(it4.getType(), "function")) continue;
                        destination$iv$iv4.add(element$iv$iv3);
                    }
                    $this$filter$iv = (List)destination$iv$iv4;
                    boolean $i$f$map = false;
                    $this$filterTo$iv$iv = $this$map$iv;
                    destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        it4 = (ABI)item$iv$iv;
                        Collection collection = destination$iv$iv4;
                        boolean bl9 = false;
                        String sig = ABI.toCanonicalSig$default(it4, false, 1, null);
                        String string4 = contract.getEvm().getMethodIdentifiers().get(sig);
                        if (string4 == null) {
                            string4 = "";
                        }
                        collection.add(it4.toMethod(string4));
                    }
                    List methods = (List)destination$iv$iv4;
                    object = SourceLanguage.Solidity;
                    Intrinsics.checkNotNull(contract.getEvm().getDeployedBytecode().getObject());
                    String string5 = contract.getEvm().getBytecode().getObject();
                    Intrinsics.checkNotNull(string5);
                    string3 = string5;
                    Intrinsics.checkNotNull(contract.getEvm().getDeployedBytecode().getSourceMap());
                    Object object2 = this.address;
                    int n = i2;
                    i2 = n + 1;
                    BigInteger bigInteger2 = BigInteger.valueOf(n);
                    Intrinsics.checkNotNullExpressionValue(bigInteger2, "valueOf(...)");
                    Object object3 = bigInteger2;
                    Intrinsics.checkNotNullExpressionValue(((BigInteger)object2).add((BigInteger)object3), "add(...)");
                    object2 = contract.getStorageLayout();
                    object3 = contract.getTransientStorageLayout();
                    Set set2 = SetsKt.emptySet();
                    List list = CollectionsKt.emptyList();
                    contractInstanceInSDC = new ContractInstanceInSDC(contractName, "", (SourceLanguage)((Object)object), "", bigInteger, false, methods, string2, string3, string, null, null, (StorageLayout)object2, (StorageLayout)object3, set2, null, null, null, null, null, list, null, null, null, null, null, null, null, null, null, 804228096, null);
                }
                if (contractInstanceInSDC == null) continue;
                ContractInstanceInSDC it$iv$iv = contractInstanceInSDC;
                boolean bl10 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv3;
            CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
        }
        return EitherKt.toLeft((List)destination$iv$iv2);
    }

    public AbstractSolcRunner() {
        this(null, false, null, 7, null);
    }

    public static final /* synthetic */ Output access$compileContracts(AbstractSolcRunner $this) {
        return $this.compileContracts();
    }

    public static final /* synthetic */ Either access$postProcess(AbstractSolcRunner $this, Output res2) {
        return $this.postProcess(res2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lcompiler/AbstractSolcRunner$Source;", "", "()V", "FromFile", "Literal", "Lcompiler/AbstractSolcRunner$Source$FromFile;", "Lcompiler/AbstractSolcRunner$Source$Literal;", "Shared"})
    public static abstract class Source {
        private Source() {
        }

        public /* synthetic */ Source(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcompiler/AbstractSolcRunner$Source$FromFile;", "Lcompiler/AbstractSolcRunner$Source;", "path", "", "(Ljava/lang/String;)V", "getPath", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Shared"})
        public static final class FromFile
        extends Source {
            @NotNull
            private final String path;

            public FromFile(@NotNull String path) {
                Intrinsics.checkNotNullParameter(path, "path");
                super(null);
                this.path = path;
            }

            @NotNull
            public final String getPath() {
                return this.path;
            }

            @NotNull
            public final String component1() {
                return this.path;
            }

            @NotNull
            public final FromFile copy(@NotNull String path) {
                Intrinsics.checkNotNullParameter(path, "path");
                return new FromFile(path);
            }

            public static /* synthetic */ FromFile copy$default(FromFile fromFile, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = fromFile.path;
                }
                return fromFile.copy(string);
            }

            @NotNull
            public String toString() {
                return "FromFile(path=" + this.path + ")";
            }

            public int hashCode() {
                return this.path.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FromFile)) {
                    return false;
                }
                FromFile fromFile = (FromFile)other;
                return Intrinsics.areEqual(this.path, fromFile.path);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcompiler/AbstractSolcRunner$Source$Literal;", "Lcompiler/AbstractSolcRunner$Source;", "contractSource", "", "(Ljava/lang/String;)V", "getContractSource", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Shared"})
        public static final class Literal
        extends Source {
            @NotNull
            private final String contractSource;

            public Literal(@NotNull String contractSource) {
                Intrinsics.checkNotNullParameter(contractSource, "contractSource");
                super(null);
                this.contractSource = contractSource;
            }

            @NotNull
            public final String getContractSource() {
                return this.contractSource;
            }

            @NotNull
            public final String component1() {
                return this.contractSource;
            }

            @NotNull
            public final Literal copy(@NotNull String contractSource) {
                Intrinsics.checkNotNullParameter(contractSource, "contractSource");
                return new Literal(contractSource);
            }

            public static /* synthetic */ Literal copy$default(Literal literal, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = literal.contractSource;
                }
                return literal.copy(string);
            }

            @NotNull
            public String toString() {
                return "Literal(contractSource=" + this.contractSource + ")";
            }

            public int hashCode() {
                return this.contractSource.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Literal)) {
                    return false;
                }
                Literal literal = (Literal)other;
                return Intrinsics.areEqual(this.contractSource, literal.contractSource);
            }
        }
    }
}

