/*
 * Decompiled with CFR 0.152.
 */
package ksp.parser;

import com.google.devtools.ksp.processing.CodeGenerator;
import com.google.devtools.ksp.processing.Dependencies;
import com.google.devtools.ksp.processing.KSPLogger;
import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.processing.SymbolProcessor;
import com.google.devtools.ksp.processing.SymbolProcessorEnvironment;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSDeclaration;
import com.google.devtools.ksp.symbol.KSDeclarationContainer;
import com.google.devtools.ksp.symbol.KSFile;
import com.google.devtools.ksp.symbol.KSFunctionDeclaration;
import com.google.devtools.ksp.symbol.KSName;
import com.google.devtools.ksp.symbol.KSValueParameter;
import com.google.devtools.ksp.symbol.KSVisitorVoid;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import ksp.parser.TACCmdPrinterGeneratorProcessor;
import ksp.parser.TACKspUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lksp/parser/TACCmdPrinterGeneratorProcessor;", "Lcom/google/devtools/ksp/processing/SymbolProcessor;", "environment", "Lcom/google/devtools/ksp/processing/SymbolProcessorEnvironment;", "(Lcom/google/devtools/ksp/processing/SymbolProcessorEnvironment;)V", "customCmdPrinters", "", "", "getCustomCmdPrinters", "()Ljava/util/Map;", "directArgTypesPrint", "generatedClassName", "getGeneratedClassName", "()Ljava/lang/String;", "checkAmbiguity", "", "decl", "Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "process", "", "Lcom/google/devtools/ksp/symbol/KSAnnotated;", "resolver", "Lcom/google/devtools/ksp/processing/Resolver;", "processConstructorParameter", "parameter", "Lcom/google/devtools/ksp/symbol/KSValueParameter;", "KspGeneration"})
public final class TACCmdPrinterGeneratorProcessor
implements SymbolProcessor {
    @NotNull
    private final SymbolProcessorEnvironment environment;
    @NotNull
    private final String generatedClassName;
    @NotNull
    private final Map<String, String> customCmdPrinters;
    @NotNull
    private final Map<String, String> directArgTypesPrint;

    public TACCmdPrinterGeneratorProcessor(@NotNull SymbolProcessorEnvironment environment) {
        Intrinsics.checkNotNullParameter(environment, "environment");
        this.environment = environment;
        this.generatedClassName = "printCmd";
        Pair[] pairArray = new Pair[]{TuplesKt.to("AnnotationCmd", "printer(mapOfMetaMap)"), TuplesKt.to("SummaryCmd", "printer(mapOfMetaMap)")};
        this.customCmdPrinters = MapsKt.mapOf(pairArray);
        pairArray = new Pair[]{TuplesKt.to("vc.data.TACExpr", "printExpr(mapOfMetaMap)"), TuplesKt.to("vc.data.TACSymbol", "printer(mapOfMetaMap)"), TuplesKt.to("vc.data.TACSymbol.Var", "printer(mapOfMetaMap)"), TuplesKt.to("vc.data.TACSymbol.Const", "printer(mapOfMetaMap)"), TuplesKt.to("kotlin.String", "Quoted()"), TuplesKt.to("tac.NBId", "toString()")};
        this.directArgTypesPrint = MapsKt.mapOf(pairArray);
    }

    @NotNull
    public final String getGeneratedClassName() {
        return this.generatedClassName;
    }

    @NotNull
    public final Map<String, String> getCustomCmdPrinters() {
        return this.customCmdPrinters;
    }

    private final String processConstructorParameter(KSValueParameter parameter) {
        Object object;
        KSName kSName = parameter.getType().resolve().getDeclaration().getQualifiedName();
        Intrinsics.checkNotNull(kSName);
        String tyFqn = kSName.asString();
        if (TACKspUtilsKt.isEnumType(parameter)) {
            KSName kSName2 = parameter.getName();
            object = "${" + (kSName2 != null ? kSName2.asString() : null) + ".toString().Quoted()}";
        } else if (TACKspUtilsKt.isListOf(parameter, "vc.data.TACSymbol")) {
            object = "${" + parameter + ".joinToString(\" \") {it.printer(mapOfMetaMap)}}";
        } else {
            String string = tyFqn;
            if (this.directArgTypesPrint.containsKey(string)) {
                KSName kSName3 = parameter.getName();
                Intrinsics.checkNotNull(kSName3);
                String string2 = kSName3.asString();
                String string3 = this.directArgTypesPrint.get(tyFqn);
                Intrinsics.checkNotNull(string3);
                object = "${" + string2 + "." + string3 + "}";
            } else {
                this.environment.getLogger().error("Do not know how to automatically print " + tyFqn, parameter);
                object = "[ERROR]";
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<KSAnnotated> process(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        Map cmdPrinterGenerations = new LinkedHashMap();
        KSClassDeclaration kSClassDeclaration = resolver.getClassDeclarationByName(resolver.getKSNameFromString("vc.data.TACCmd.Simple"));
        if (kSClassDeclaration == null) {
            return CollectionsKt.emptyList();
        }
        KSClassDeclaration tacSimpleRoot = kSClassDeclaration;
        if (tacSimpleRoot.getContainingFile() == null) {
            return CollectionsKt.emptyList();
        }
        if (!SequencesKt.contains(resolver.getNewFiles(), tacSimpleRoot.getContainingFile())) {
            return CollectionsKt.emptyList();
        }
        new KSVisitorVoid(this, cmdPrinterGenerations){
            final /* synthetic */ TACCmdPrinterGeneratorProcessor this$0;
            final /* synthetic */ Map<String, String> $cmdPrinterGenerations;
            {
                this.this$0 = $receiver;
                this.$cmdPrinterGenerations = $cmdPrinterGenerations;
            }

            /*
             * WARNING - void declaration
             */
            public void visitDeclaration(@NotNull KSDeclaration declaration, @NotNull Unit data) {
                Object element$iv;
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                Intrinsics.checkNotNullParameter(data, "data");
                super.visitDeclaration(declaration, data);
                if (declaration instanceof KSDeclarationContainer) {
                    Sequence<KSDeclaration> $this$forEach$iv = ((KSDeclarationContainer)((Object)declaration)).getDeclarations();
                    boolean $i$f$forEach = false;
                    Iterator<KSDeclaration> iterator2 = $this$forEach$iv.iterator();
                    while (iterator2.hasNext()) {
                        element$iv = iterator2.next();
                        KSDeclaration it2 = element$iv;
                        boolean bl = false;
                        this.visitDeclaration(it2, data);
                    }
                }
                if (!(declaration instanceof KSClassDeclaration) || !TACKspUtilsKt.isConcreteSubClassOf((KSClassDeclaration)declaration, "vc.data.TACCmd.Simple")) {
                    return;
                }
                KSName kSName = declaration.getQualifiedName();
                KSPLogger.info$default(TACCmdPrinterGeneratorProcessor.access$getEnvironment$p(this.this$0).getLogger(), "visiting declaration of " + (kSName != null ? kSName.asString() : null), null, 2, null);
                switch (process.WhenMappings.$EnumSwitchMapping$0[((KSClassDeclaration)declaration).getClassKind().ordinal()]) {
                    case 1: {
                        KSName kSName2 = declaration.getQualifiedName();
                        Intrinsics.checkNotNull(kSName2);
                        this.$cmdPrinterGenerations.put(kSName2.asString(), "\"" + declaration.getSimpleName().asString() + "\"");
                        break;
                    }
                    case 2: {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        void $this$filterTo$iv$iv;
                        Iterable $this$filter$iv;
                        if (this.this$0.getCustomCmdPrinters().containsKey(declaration.getSimpleName().asString())) {
                            KSName kSName3 = declaration.getQualifiedName();
                            Intrinsics.checkNotNull(kSName3);
                            String string = kSName3.asString();
                            String string2 = this.this$0.getCustomCmdPrinters().get(declaration.getSimpleName().asString());
                            Intrinsics.checkNotNull(string2);
                            this.$cmdPrinterGenerations.put(string, string2);
                            break;
                        }
                        if (TACCmdPrinterGeneratorProcessor.access$checkAmbiguity(this.this$0, (KSClassDeclaration)declaration)) {
                            TACCmdPrinterGeneratorProcessor.access$getEnvironment$p(this.this$0).getLogger().error("ambiguous parameter types " + declaration.getSimpleName().asString(), declaration);
                        }
                        KSFunctionDeclaration kSFunctionDeclaration = ((KSClassDeclaration)declaration).getPrimaryConstructor();
                        Intrinsics.checkNotNull(kSFunctionDeclaration);
                        element$iv = kSFunctionDeclaration.getParameters();
                        boolean $i$f$filter22 = false;
                        void bl = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            KSValueParameter it3 = (KSValueParameter)element$iv$iv;
                            boolean bl2 = false;
                            KSName kSName4 = it3.getType().resolve().getDeclaration().getQualifiedName();
                            Intrinsics.checkNotNull(kSName4);
                            if (!(!Intrinsics.areEqual(kSName4.asString(), "tac.MetaMap"))) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        TACCmdPrinterGeneratorProcessor $i$f$filter22 = this.this$0;
                        boolean $i$f$map = false;
                        destination$iv$iv = $this$map$iv;
                        Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void parameter;
                            KSValueParameter bl2 = (KSValueParameter)item$iv$iv;
                            Collection collection = destination$iv$iv2;
                            boolean bl3 = false;
                            KSPLogger kSPLogger = TACCmdPrinterGeneratorProcessor.access$getEnvironment$p($i$f$filter22).getLogger();
                            KSName kSName5 = parameter.getName();
                            String string = kSName5 != null ? kSName5.asString() : null;
                            if (string == null) {
                                string = "";
                            }
                            KSPLogger.info$default(kSPLogger, " processing parameter: " + string, null, 2, null);
                            collection.add(TACCmdPrinterGeneratorProcessor.access$processConstructorParameter($i$f$filter22, (KSValueParameter)parameter));
                        }
                        String constructorArgs = CollectionsKt.joinToString$default((List)destination$iv$iv2, " ", null, null, 0, null, null, 62, null);
                        String metaParamString = "$metaRef";
                        String fullCall = "\"" + declaration.getSimpleName().asString() + metaParamString + " " + constructorArgs + "\"";
                        KSName kSName6 = declaration.getQualifiedName();
                        Intrinsics.checkNotNull(kSName6);
                        this.$cmdPrinterGenerations.put(kSName6.asString(), fullCall);
                        break;
                    }
                    default: {
                        TACCmdPrinterGeneratorProcessor.access$getEnvironment$p(this.this$0).getLogger().error("Do not know how to automatically parse class type " + declaration.getSimpleName().asString(), declaration);
                        KSName kSName7 = declaration.getQualifiedName();
                        Intrinsics.checkNotNull(kSName7);
                        this.$cmdPrinterGenerations.put(kSName7.asString(), "Todo()");
                    }
                }
            }
        }.visitDeclaration((KSDeclaration)tacSimpleRoot, Unit.INSTANCE);
        String generatedFile2 = StringsKt.trimIndent("\npackage vc.data.parser\nimport tac.MetaMap\nimport vc.data.TACCmd\n/**\n*   Generated by [" + Reflection.getOrCreateKotlinClass(this.getClass()).getQualifiedName() + "]\n*/\nfun TACCmd.Simple.printCmd(mapOfMetaMap: MutableMap<MetaMap,Int>) : String {\n    val metaRef = printMetaString(mapOfMetaMap, meta)\n    return when(this) {\n        " + CollectionsKt.joinToString$default(cmdPrinterGenerations.entrySet(), "\n\t\t", null, null, 0, null, process.generatedFile.1.INSTANCE, 30, null) + "\n   }\n}\n");
        CodeGenerator codeGenerator = this.environment.getCodeGenerator();
        Object object = new KSFile[1];
        Intrinsics.checkNotNull(tacSimpleRoot.getContainingFile());
        OutputStream out2 = codeGenerator.createNewFile(new Dependencies(false, (KSFile)object), "vc.data.parser", this.generatedClassName, "kt");
        object = out2;
        Object object2 = Charsets.UTF_8;
        Object object3 = new OutputStreamWriter((OutputStream)object, (Charset)object2);
        int n = 8192;
        object = object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
        object2 = null;
        try {
            BufferedWriter os = (BufferedWriter)object;
            boolean bl = false;
            os.write(generatedFile2);
            object3 = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        return CollectionsKt.emptyList();
    }

    private final boolean checkAmbiguity(KSClassDeclaration decl2) {
        return TACKspUtilsKt.IsConsecutiveListsInConstructor(decl2);
    }

    public static final /* synthetic */ SymbolProcessorEnvironment access$getEnvironment$p(TACCmdPrinterGeneratorProcessor $this) {
        return $this.environment;
    }

    public static final /* synthetic */ boolean access$checkAmbiguity(TACCmdPrinterGeneratorProcessor $this, KSClassDeclaration decl2) {
        return $this.checkAmbiguity(decl2);
    }

    public static final /* synthetic */ String access$processConstructorParameter(TACCmdPrinterGeneratorProcessor $this, KSValueParameter parameter) {
        return $this.processConstructorParameter(parameter);
    }
}

