/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.AlreadySelectedException;
import org.apache.commons.cli.AmbiguousOptionException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.apache.commons.cli.Util;

public class DefaultParser
implements CommandLineParser {
    protected CommandLine cmd;
    protected Options options;
    protected boolean stopAtNonOption;
    protected String currentToken;
    protected Option currentOption;
    protected boolean skipParsing;
    protected List expectedOpts;
    private final boolean allowPartialMatching;
    private final Boolean stripLeadingAndTrailingQuotes;

    public static Builder builder() {
        return new Builder();
    }

    public DefaultParser() {
        this.allowPartialMatching = true;
        this.stripLeadingAndTrailingQuotes = null;
    }

    public DefaultParser(boolean allowPartialMatching) {
        this.allowPartialMatching = allowPartialMatching;
        this.stripLeadingAndTrailingQuotes = null;
    }

    private DefaultParser(boolean allowPartialMatching, Boolean stripLeadingAndTrailingQuotes) {
        this.allowPartialMatching = allowPartialMatching;
        this.stripLeadingAndTrailingQuotes = stripLeadingAndTrailingQuotes;
    }

    private void checkRequiredArgs() throws ParseException {
        if (this.currentOption != null && this.currentOption.requiresArg()) {
            throw new MissingArgumentException(this.currentOption);
        }
    }

    protected void checkRequiredOptions() throws MissingOptionException {
        if (!this.expectedOpts.isEmpty()) {
            throw new MissingOptionException(this.expectedOpts);
        }
    }

    private String getLongPrefix(String token2) {
        String t = Util.stripLeadingHyphens(token2);
        String opt = null;
        for (int i2 = t.length() - 2; i2 > 1; --i2) {
            String prefix = t.substring(0, i2);
            if (!this.options.hasLongOption(prefix)) continue;
            opt = prefix;
            break;
        }
        return opt;
    }

    private List<String> getMatchingLongOptions(String token2) {
        if (this.allowPartialMatching) {
            return this.options.getMatchingOptions(token2);
        }
        ArrayList<String> matches2 = new ArrayList<String>(1);
        if (this.options.hasLongOption(token2)) {
            Option option2 = this.options.getOption(token2);
            matches2.add(option2.getLongOpt());
        }
        return matches2;
    }

    protected void handleConcatenatedOptions(String token2) throws ParseException {
        for (int i2 = 1; i2 < token2.length(); ++i2) {
            String ch = String.valueOf(token2.charAt(i2));
            if (!this.options.hasOption(ch)) {
                this.handleUnknownToken(this.stopAtNonOption && i2 > 1 ? token2.substring(i2) : token2);
                break;
            }
            this.handleOption(this.options.getOption(ch));
            if (this.currentOption == null || token2.length() == i2 + 1) continue;
            this.currentOption.addValueForProcessing(this.stripLeadingAndTrailingQuotesDefaultOff(token2.substring(i2 + 1)));
            break;
        }
    }

    private void handleLongOption(String token2) throws ParseException {
        if (token2.indexOf(61) == -1) {
            this.handleLongOptionWithoutEqual(token2);
        } else {
            this.handleLongOptionWithEqual(token2);
        }
    }

    private void handleLongOptionWithEqual(String token2) throws ParseException {
        int pos = token2.indexOf(61);
        String value2 = token2.substring(pos + 1);
        String opt = token2.substring(0, pos);
        List<String> matchingOpts = this.getMatchingLongOptions(opt);
        if (matchingOpts.isEmpty()) {
            this.handleUnknownToken(this.currentToken);
        } else {
            if (matchingOpts.size() > 1 && !this.options.hasLongOption(opt)) {
                throw new AmbiguousOptionException(opt, matchingOpts);
            }
            String key = this.options.hasLongOption(opt) ? opt : matchingOpts.get(0);
            Option option2 = this.options.getOption(key);
            if (option2.acceptsArg()) {
                this.handleOption(option2);
                this.currentOption.addValueForProcessing(this.stripLeadingAndTrailingQuotesDefaultOff(value2));
                this.currentOption = null;
            } else {
                this.handleUnknownToken(this.currentToken);
            }
        }
    }

    private void handleLongOptionWithoutEqual(String token2) throws ParseException {
        List<String> matchingOpts = this.getMatchingLongOptions(token2);
        if (matchingOpts.isEmpty()) {
            this.handleUnknownToken(this.currentToken);
        } else {
            if (matchingOpts.size() > 1 && !this.options.hasLongOption(token2)) {
                throw new AmbiguousOptionException(token2, matchingOpts);
            }
            String key = this.options.hasLongOption(token2) ? token2 : matchingOpts.get(0);
            this.handleOption(this.options.getOption(key));
        }
    }

    private void handleOption(Option option2) throws ParseException {
        this.checkRequiredArgs();
        option2 = (Option)option2.clone();
        this.updateRequiredOptions(option2);
        this.cmd.addOption(option2);
        this.currentOption = option2.hasArg() ? option2 : null;
    }

    private void handleProperties(Properties properties) throws ParseException {
        if (properties == null) {
            return;
        }
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            boolean selected;
            String option2 = e.nextElement().toString();
            Option opt = this.options.getOption(option2);
            if (opt == null) {
                throw new UnrecognizedOptionException("Default option wasn't defined", option2);
            }
            OptionGroup group = this.options.getOptionGroup(opt);
            boolean bl = selected = group != null && group.getSelected() != null;
            if (this.cmd.hasOption(option2) || selected) continue;
            String value2 = properties.getProperty(option2);
            if (opt.hasArg()) {
                if (opt.getValues() == null || opt.getValues().length == 0) {
                    opt.addValueForProcessing(this.stripLeadingAndTrailingQuotesDefaultOff(value2));
                }
            } else if (!"yes".equalsIgnoreCase(value2) && !"true".equalsIgnoreCase(value2) && !"1".equalsIgnoreCase(value2)) continue;
            this.handleOption(opt);
            this.currentOption = null;
        }
    }

    private void handleShortAndLongOption(String token2) throws ParseException {
        String t = Util.stripLeadingHyphens(token2);
        int pos = t.indexOf(61);
        if (t.length() == 1) {
            if (this.options.hasShortOption(t)) {
                this.handleOption(this.options.getOption(t));
            } else {
                this.handleUnknownToken(token2);
            }
        } else if (pos == -1) {
            if (this.options.hasShortOption(t)) {
                this.handleOption(this.options.getOption(t));
            } else if (!this.getMatchingLongOptions(t).isEmpty()) {
                this.handleLongOptionWithoutEqual(token2);
            } else {
                String opt = this.getLongPrefix(t);
                if (opt != null && this.options.getOption(opt).acceptsArg()) {
                    this.handleOption(this.options.getOption(opt));
                    this.currentOption.addValueForProcessing(this.stripLeadingAndTrailingQuotesDefaultOff(t.substring(opt.length())));
                    this.currentOption = null;
                } else if (this.isJavaProperty(t)) {
                    this.handleOption(this.options.getOption(t.substring(0, 1)));
                    this.currentOption.addValueForProcessing(this.stripLeadingAndTrailingQuotesDefaultOff(t.substring(1)));
                    this.currentOption = null;
                } else {
                    this.handleConcatenatedOptions(token2);
                }
            }
        } else {
            String opt = t.substring(0, pos);
            String value2 = t.substring(pos + 1);
            if (opt.length() == 1) {
                Option option2 = this.options.getOption(opt);
                if (option2 != null && option2.acceptsArg()) {
                    this.handleOption(option2);
                    this.currentOption.addValueForProcessing(value2);
                    this.currentOption = null;
                } else {
                    this.handleUnknownToken(token2);
                }
            } else if (this.isJavaProperty(opt)) {
                this.handleOption(this.options.getOption(opt.substring(0, 1)));
                this.currentOption.addValueForProcessing(opt.substring(1));
                this.currentOption.addValueForProcessing(value2);
                this.currentOption = null;
            } else {
                this.handleLongOptionWithEqual(token2);
            }
        }
    }

    private void handleToken(String token2) throws ParseException {
        this.currentToken = token2;
        if (this.skipParsing) {
            this.cmd.addArg(token2);
        } else if ("--".equals(token2)) {
            this.skipParsing = true;
        } else if (this.currentOption != null && this.currentOption.acceptsArg() && this.isArgument(token2)) {
            this.currentOption.addValueForProcessing(this.stripLeadingAndTrailingQuotesDefaultOn(token2));
        } else if (token2.startsWith("--")) {
            this.handleLongOption(token2);
        } else if (token2.startsWith("-") && !"-".equals(token2)) {
            this.handleShortAndLongOption(token2);
        } else {
            this.handleUnknownToken(token2);
        }
        if (this.currentOption != null && !this.currentOption.acceptsArg()) {
            this.currentOption = null;
        }
    }

    private void handleUnknownToken(String token2) throws ParseException {
        if (token2.startsWith("-") && token2.length() > 1 && !this.stopAtNonOption) {
            throw new UnrecognizedOptionException("Unrecognized option: " + token2, token2);
        }
        this.cmd.addArg(token2);
        if (this.stopAtNonOption) {
            this.skipParsing = true;
        }
    }

    private boolean isArgument(String token2) {
        return !this.isOption(token2) || this.isNegativeNumber(token2);
    }

    private boolean isJavaProperty(String token2) {
        String opt = token2.substring(0, 1);
        Option option2 = this.options.getOption(opt);
        return option2 != null && (option2.getArgs() >= 2 || option2.getArgs() == -2);
    }

    private boolean isLongOption(String token2) {
        String t;
        if (token2 == null || !token2.startsWith("-") || token2.length() == 1) {
            return false;
        }
        int pos = token2.indexOf("=");
        String string = t = pos == -1 ? token2 : token2.substring(0, pos);
        if (!this.getMatchingLongOptions(t).isEmpty()) {
            return true;
        }
        return this.getLongPrefix(token2) != null && !token2.startsWith("--");
    }

    private boolean isNegativeNumber(String token2) {
        try {
            Double.parseDouble(token2);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isOption(String token2) {
        return this.isLongOption(token2) || this.isShortOption(token2);
    }

    private boolean isShortOption(String token2) {
        String optName;
        if (token2 == null || !token2.startsWith("-") || token2.length() == 1) {
            return false;
        }
        int pos = token2.indexOf("=");
        String string = optName = pos == -1 ? token2.substring(1) : token2.substring(1, pos);
        if (this.options.hasShortOption(optName)) {
            return true;
        }
        return !optName.isEmpty() && this.options.hasShortOption(String.valueOf(optName.charAt(0)));
    }

    @Override
    public CommandLine parse(Options options2, String[] arguments) throws ParseException {
        return this.parse(options2, arguments, null);
    }

    @Override
    public CommandLine parse(Options options2, String[] arguments, boolean stopAtNonOption) throws ParseException {
        return this.parse(options2, arguments, null, stopAtNonOption);
    }

    public CommandLine parse(Options options2, String[] arguments, Properties properties) throws ParseException {
        return this.parse(options2, arguments, properties, false);
    }

    public CommandLine parse(Options options2, String[] arguments, Properties properties, boolean stopAtNonOption) throws ParseException {
        this.options = options2;
        this.stopAtNonOption = stopAtNonOption;
        this.skipParsing = false;
        this.currentOption = null;
        this.expectedOpts = new ArrayList(options2.getRequiredOptions());
        for (OptionGroup group : options2.getOptionGroups()) {
            group.setSelected(null);
        }
        this.cmd = new CommandLine();
        if (arguments != null) {
            for (String argument2 : arguments) {
                this.handleToken(argument2);
            }
        }
        this.checkRequiredArgs();
        this.handleProperties(properties);
        this.checkRequiredOptions();
        return this.cmd;
    }

    private String stripLeadingAndTrailingQuotesDefaultOff(String token2) {
        if (this.stripLeadingAndTrailingQuotes != null && this.stripLeadingAndTrailingQuotes.booleanValue()) {
            return Util.stripLeadingAndTrailingQuotes(token2);
        }
        return token2;
    }

    private String stripLeadingAndTrailingQuotesDefaultOn(String token2) {
        if (this.stripLeadingAndTrailingQuotes == null || this.stripLeadingAndTrailingQuotes.booleanValue()) {
            return Util.stripLeadingAndTrailingQuotes(token2);
        }
        return token2;
    }

    private void updateRequiredOptions(Option option2) throws AlreadySelectedException {
        if (option2.isRequired()) {
            this.expectedOpts.remove(option2.getKey());
        }
        if (this.options.getOptionGroup(option2) != null) {
            OptionGroup group = this.options.getOptionGroup(option2);
            if (group.isRequired()) {
                this.expectedOpts.remove(group);
            }
            group.setSelected(option2);
        }
    }

    public static final class Builder {
        private boolean allowPartialMatching = true;
        private Boolean stripLeadingAndTrailingQuotes;

        private Builder() {
        }

        public DefaultParser build() {
            return new DefaultParser(this.allowPartialMatching, this.stripLeadingAndTrailingQuotes);
        }

        public Builder setAllowPartialMatching(boolean allowPartialMatching) {
            this.allowPartialMatching = allowPartialMatching;
            return this;
        }

        public Builder setStripLeadingAndTrailingQuotes(Boolean stripLeadingAndTrailingQuotes) {
            this.stripLeadingAndTrailingQuotes = stripLeadingAndTrailingQuotes;
            return this;
        }
    }
}

