/*
 * Decompiled with CFR 0.152.
 */
package org.komputing.khash.keccak;

import com.ionspin.kotlin.bignum.BigNumber;
import com.ionspin.kotlin.bignum.integer.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.komputing.khash.keccak.KeccakParameter;
import org.komputing.khash.keccak.extensions.IntArrayExtensionsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J!\u0010\u0014\u001a\u00020\u00122\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00160\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017J\u0014\u0010\u0018\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0014\u0010\u001b\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/komputing/khash/keccak/Keccak;", "", "()V", "BIT_65", "Lcom/ionspin/kotlin/bignum/integer/BigInteger;", "MAX_64_BITS", "convertFrom64ToLittleEndian", "", "uLong", "convertFromLittleEndianTo64", "data", "convertToUInt", "", "digest", "value", "parameter", "Lorg/komputing/khash/keccak/KeccakParameter;", "doF", "", "uState", "roundB", "state", "", "([[Lcom/ionspin/kotlin/bignum/integer/BigInteger;)V", "leftRotate64", "rotate", "", "leftRotate64Safely", "keccak"})
public final class Keccak {
    @NotNull
    public static final Keccak INSTANCE = new Keccak();
    @NotNull
    private static final BigInteger BIT_65 = BigInteger.Companion.getONE().shl(64);
    @NotNull
    private static final BigInteger MAX_64_BITS = (BigInteger)BIT_65.minus((BigNumber)BigInteger.Companion.getONE());

    private Keccak() {
    }

    @NotNull
    public final byte[] digest(@NotNull byte[] value2, @NotNull KeccakParameter parameter) {
        int i2;
        int n;
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter((Object)parameter, "parameter");
        int[] uState = new int[200];
        int[] uMessage = this.convertToUInt(value2);
        int blockSize = 0;
        for (int inputOffset = 0; inputOffset < uMessage.length; inputOffset += blockSize) {
            int n2 = uMessage.length - inputOffset;
            int n3 = parameter.getRateInBytes();
            n = 0;
            n2 = 0;
            blockSize = Math.min(n2, n3);
            if (n2 >= blockSize) continue;
            do {
                i2 = n2++;
                uState[i2] = uState[i2] ^ uMessage[i2 + inputOffset];
            } while (n2 < blockSize);
            if (blockSize != parameter.getRateInBytes()) continue;
            this.doF(uState);
            blockSize = 0;
        }
        uState[blockSize] = uState[blockSize] ^ parameter.getD();
        if ((parameter.getD() & 0x80) != 0 && blockSize == parameter.getRateInBytes() - 1) {
            this.doF(uState);
        }
        uState[parameter.getRateInBytes() - 1] = uState[parameter.getRateInBytes() - 1] ^ 0x80;
        this.doF(uState);
        i2 = 0;
        List byteResults = new ArrayList();
        int tOutputLen = parameter.getOutputLengthInBytes();
        while (tOutputLen > 0) {
            n = parameter.getRateInBytes();
            boolean bl = false;
            n = 0;
            blockSize = Math.min(tOutputLen, n);
            if (n < blockSize) {
                do {
                    int i3 = n++;
                    byteResults.add((byte)uState[i3]);
                } while (n < blockSize);
            }
            if ((tOutputLen -= blockSize) <= 0) continue;
            this.doF(uState);
        }
        return CollectionsKt.toByteArray(byteResults);
    }

    private final void doF(int[] uState) {
        int[] data;
        int j;
        int i2;
        int n;
        int n2;
        BigInteger[][] bigIntegerArray = new BigInteger[5][];
        for (n2 = 0; n2 < 5; ++n2) {
            n = n2;
            int n3 = 0;
            BigInteger[] bigIntegerArray2 = new BigInteger[5];
            int n4 = n;
            BigInteger[][] bigIntegerArray3 = bigIntegerArray;
            while (n3 < 5) {
                int n5 = n3++;
                bigIntegerArray2[n5] = BigInteger.Companion.getZERO();
            }
            bigIntegerArray3[n4] = bigIntegerArray2;
        }
        BigInteger[][] lState = bigIntegerArray;
        n2 = 0;
        do {
            i2 = n2++;
            n = 0;
            do {
                j = n++;
                data = new int[8];
                int index = 8 * (i2 + 5 * j);
                ArraysKt.copyInto(uState, data, 0, index, index + data.length);
                lState[i2][j] = this.convertFromLittleEndianTo64(data);
            } while (n <= 4);
        } while (n2 <= 4);
        this.roundB(lState);
        IntArrayExtensionsKt.fillWith$default(uState, 0, 0, 0, 6, null);
        n2 = 0;
        do {
            i2 = n2++;
            n = 0;
            do {
                j = n++;
                data = this.convertFrom64ToLittleEndian(lState[i2][j]);
                ArraysKt.copyInto$default(data, uState, 8 * (i2 + 5 * j), 0, 0, 12, null);
            } while (n <= 4);
        } while (n2 <= 4);
    }

    private final void roundB(BigInteger[][] state) {
        int lfsrState = 1;
        int n = 0;
        do {
            int i2;
            int i3;
            int round = n++;
            BigInteger[] c = new BigInteger[5];
            BigInteger[] d2 = new BigInteger[5];
            int n2 = 0;
            do {
                i3 = n2++;
                c[i3] = state[i3][0].xor(state[i3][1]).xor(state[i3][2]).xor(state[i3][3]).xor(state[i3][4]);
            } while (n2 <= 4);
            n2 = 0;
            do {
                i3 = n2++;
                BigInteger bigInteger = c[(i3 + 4) % 5];
                Intrinsics.checkNotNull(bigInteger);
                BigInteger bigInteger2 = bigInteger;
                bigInteger = c[(i3 + 1) % 5];
                Intrinsics.checkNotNull(bigInteger);
                d2[i3] = bigInteger2.xor(this.leftRotate64(bigInteger, 1));
            } while (n2 <= 4);
            n2 = 0;
            do {
                i3 = n2++;
                int n3 = 0;
                do {
                    int j = n3++;
                    BigInteger[] bigIntegerArray = state[i3];
                    BigInteger bigInteger = state[i3][j];
                    BigInteger bigInteger3 = d2[i3];
                    Intrinsics.checkNotNull(bigInteger3);
                    bigIntegerArray[j] = bigInteger.xor(bigInteger3);
                } while (n3 <= 4);
            } while (n2 <= 4);
            int x = 1;
            int y = 0;
            BigInteger current = state[x][y];
            int n4 = 0;
            do {
                i2 = n4++;
                int tX = x;
                x = y;
                y = (2 * tX + 3 * y) % 5;
                BigInteger shiftValue = current;
                current = state[x][y];
                state[x][y] = this.leftRotate64Safely(shiftValue, (i2 + 1) * (i2 + 2) / 2);
            } while (n4 <= 23);
            n4 = 0;
            do {
                int i4;
                int j = n4++;
                BigInteger[] t = new BigInteger[5];
                int n5 = 0;
                do {
                    i4 = n5++;
                    t[i4] = state[i4][j];
                } while (n5 <= 4);
                n5 = 0;
                do {
                    i4 = n5++;
                    BigInteger bigInteger = t[(i4 + 1) % 5];
                    Intrinsics.checkNotNull(bigInteger);
                    BigInteger invertVal = bigInteger.xor(MAX_64_BITS);
                    BigInteger[] bigIntegerArray = state[i4];
                    bigInteger = t[i4];
                    Intrinsics.checkNotNull(bigInteger);
                    BigInteger bigInteger4 = bigInteger;
                    bigInteger = t[(i4 + 2) % 5];
                    Intrinsics.checkNotNull(bigInteger);
                    bigIntegerArray[j] = bigInteger4.xor(invertVal.and(bigInteger));
                } while (n5 <= 4);
            } while (n4 <= 4);
            n4 = 0;
            do {
                i2 = n4++;
                lfsrState = (lfsrState << 1 ^ (lfsrState >> 7) * 113) % 256;
                int bitPosition = (1 << i2) - 1;
                if ((lfsrState & 2) == 0) continue;
                state[0][0] = state[0][0].xor(BigInteger.Companion.getONE().shl(bitPosition));
            } while (n4 <= 6);
        } while (n <= 23);
    }

    private final int[] convertToUInt(byte[] data) {
        int n = 0;
        int n2 = data.length;
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = data[n3] & 0xFF;
        }
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    private final BigInteger convertFromLittleEndianTo64(int[] data) {
        String string;
        Collection collection;
        Object $this$mapTo$iv$iv;
        Object $this$map$iv = data;
        boolean $i$f$map = false;
        int[] nArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((int[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv;
        int n = ((void)iterator2).length;
        for (int j = 0; j < n; ++j) {
            void it2;
            void item$iv$iv;
            void var12_13 = item$iv$iv = iterator2[j];
            collection = destination$iv$iv;
            boolean bl = false;
            void var14_15 = it2;
            int n2 = 16;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue(Integer.toString((int)var14_15, CharsKt.checkRadix(n2)), "java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
            collection.add(string);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it3;
            Object item$iv$iv = iterator2.next();
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            string = it3.length() == 2 ? it3 : Intrinsics.stringPlus("0", it3);
            collection.add(string);
        }
        String value2 = CollectionsKt.joinToString$default(CollectionsKt.reversed((List)destination$iv$iv), "", null, null, 0, null, null, 62, null);
        return BigInteger.Companion.parseString(value2, 16);
    }

    /*
     * WARNING - void declaration
     */
    private final int[] convertFrom64ToLittleEndian(BigInteger uLong) {
        String asHex = uLong.toString(16);
        String asHexPadded = Intrinsics.stringPlus(StringsKt.repeat("0", 16 - asHex.length()), asHex);
        int n = 0;
        int[] nArray = new int[8];
        while (n < 8) {
            int n2;
            void pos;
            int n3 = n++;
            int n4 = (7 - n3) * 2;
            boolean bl = false;
            boolean bl2 = false;
            int n5 = n4;
            int n6 = n3;
            int[] nArray2 = nArray;
            boolean bl3 = false;
            String string = asHexPadded;
            int n7 = pos + 2;
            boolean bl4 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring((int)pos, n7);
            Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string = string3;
            n7 = 16;
            bl4 = false;
            nArray2[n6] = n2 = Integer.parseInt(string, CharsKt.checkRadix(n7));
        }
        return nArray;
    }

    private final BigInteger leftRotate64Safely(BigInteger $this$leftRotate64Safely, int rotate) {
        return this.leftRotate64($this$leftRotate64Safely, rotate % 64);
    }

    private final BigInteger leftRotate64(BigInteger $this$leftRotate64, int rotate) {
        return $this$leftRotate64.shr(64 - rotate).add($this$leftRotate64.shl(rotate)).mod(BIT_65);
    }
}

