/*
 * Decompiled with CFR 0.152.
 */
package parallel;

import datastructures.stdcollections.ListsKt;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import parallel.Parallel;
import parallel.ParallelKt;
import parallel.RPCJob;
import parallel.Sem;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B-\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u001c\u0010\u0005\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001a\u001a\u00020\u000bH\u0016J\u001a\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R&\u0010\u0005\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0014\u0010\u0017\u001a\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001e"}, d2={"Lparallel/RPCJob;", "T", "Lparallel/Parallel;", "timeout", "Lkotlin/time/Duration;", "job", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "", "(Lkotlin/time/Duration;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "completeFlag", "", "deps", "", "getDeps", "()Ljava/util/List;", "future", "Ljava/util/concurrent/CompletableFuture;", "getFuture", "()Ljava/util/concurrent/CompletableFuture;", "setFuture", "(Ljava/util/concurrent/CompletableFuture;)V", "Lkotlin/jvm/functions/Function1;", "result", "getResult", "()Ljava/lang/Object;", "done", "schedule", "ioPool", "Ljava/util/concurrent/ExecutorService;", "GeneralUtils"})
public final class RPCJob<T>
extends Parallel<T> {
    @Nullable
    private final Duration timeout;
    @NotNull
    private final Function1<Continuation<? super T>, Object> job;
    public volatile CompletableFuture<T> future;
    private boolean completeFlag;

    private RPCJob(Duration timeout, Function1<? super Continuation<? super T>, ? extends Object> job) {
        Intrinsics.checkNotNullParameter(job, "job");
        super(null);
        this.timeout = timeout;
        this.job = job;
    }

    @Override
    @NotNull
    public List<Parallel<?>> getDeps() {
        return ListsKt.listOf();
    }

    @NotNull
    public final CompletableFuture<T> getFuture() {
        CompletableFuture<T> completableFuture = this.future;
        if (completableFuture != null) {
            return completableFuture;
        }
        Intrinsics.throwUninitializedPropertyAccessException("future");
        return null;
    }

    public final void setFuture(@NotNull CompletableFuture<T> completableFuture) {
        Intrinsics.checkNotNullParameter(completableFuture, "<set-?>");
        this.future = completableFuture;
    }

    @Override
    public T getResult() {
        if (!this.getFuture().isDone()) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return this.getFuture().get();
    }

    @Override
    public boolean done() {
        return this.future != null && this.getFuture().isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<Parallel<?>> schedule(@NotNull ExecutorService ioPool) {
        Intrinsics.checkNotNullParameter(ioPool, "ioPool");
        ParallelKt.access$getLogger$p().debug(schedule.1.INSTANCE);
        Sem semaphore = new Sem(ParallelKt.access$getSemaphoreId$p().incrementAndGet());
        CompletableFuture<Object> completableFuture = CompletableFuture.supplyAsync(() -> RPCJob.schedule$lambda$1(semaphore, this), ioPool);
        Intrinsics.checkNotNullExpressionValue(completableFuture, "supplyAsync(...)");
        this.setFuture(completableFuture);
        Sem sem = semaphore;
        synchronized (sem) {
            boolean bl = false;
            long startTimeMillis = System.currentTimeMillis();
            boolean hitTimeout = false;
            while (!this.completeFlag && !hitTimeout) {
                if (this.timeout != null) {
                    long timeRemainingMillis = Duration.getInWholeMilliseconds-impl(this.timeout.unbox-impl()) - (System.currentTimeMillis() - startTimeMillis);
                    if (timeRemainingMillis < 0L) {
                        hitTimeout = true;
                        continue;
                    }
                    semaphore.wait(timeRemainingMillis);
                    continue;
                }
                semaphore.wait();
            }
            if (hitTimeout) {
                this.getFuture().cancel(true);
            }
            Unit unit = Unit.INSTANCE;
        }
        this.getFuture().get();
        return ListsKt.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object schedule$lambda$1(Sem $semaphore, RPCJob this$0) {
        Object object;
        Intrinsics.checkNotNullParameter($semaphore, "$semaphore");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        ParallelKt.access$getLogger$p().debug(schedule.2.1.INSTANCE);
        try {
            object = BuildersKt.runBlocking$default(null, new Function2<CoroutineScope, Continuation<? super T>, Object>(this$0, null){
                int label;
                final /* synthetic */ RPCJob<T> this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(object);
                            this.label = 1;
                            R r2 = RPCJob.access$getJob$p(this.this$0).invoke(this);
                            if (r2 != object2) return r2;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure($result);
                            R r2 = $result;
                            return r2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super T> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 1, null);
        }
        finally {
            Sem sem = $semaphore;
            synchronized (sem) {
                boolean bl = false;
                this$0.completeFlag = true;
                $semaphore.notifyAll();
                Unit unit = Unit.INSTANCE;
            }
        }
        Object r2 = object;
        return r2;
    }

    public /* synthetic */ RPCJob(Duration timeout, Function1 job, DefaultConstructorMarker $constructor_marker) {
        this(timeout, job);
    }

    public static final /* synthetic */ Function1 access$getJob$p(RPCJob $this) {
        return $this.job;
    }
}

