/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import spec.CVLKeywords;
import spec.CVLWarningLogger;
import spec.cvlast.CVLCmd;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLLhs;
import spec.cvlast.CVLScope;
import spec.cvlast.EVMBuiltinTypes;
import spec.cvlast.transformer.CVLCmdTransformer;
import spec.cvlast.transformer.CVLExpTransformer;
import spec.cvlast.typechecker.CVLError;
import spec.cvlast.typechecker.MethodVariableNotInRule;
import spec.cvlast.typechecker.QuantifierChecker;
import utils.CollectingResult;
import utils.ErrorCollector;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0007\u001a\u00020\nH\u0016J&\u0010\u000b\u001a\u0018\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00020\u0005j\b\u0012\u0004\u0012\u00020\u0002`\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u000e"}, d2={"Lspec/cvlast/CVLCmdAddtionalChecks;", "Lspec/cvlast/transformer/CVLCmdTransformer;", "Lspec/cvlast/typechecker/CVLError;", "()V", "decl", "Lutils/CollectingResult;", "Lspec/cvlast/CVLCmd;", "cmd", "Lspec/cvlast/CVLCmd$Simple$Declaration;", "def", "Lspec/cvlast/CVLCmd$Simple$Definition;", "verifyMethodVariableDeclaration", "", "Lutils/VoidResult;", "Shared"})
final class CVLCmdAddtionalChecks
extends CVLCmdTransformer<CVLError> {
    public CVLCmdAddtionalChecks() {
        super((CVLExpTransformer)new CVLExpTransformer<CVLError>(){

            @Override
            @NotNull
            public CollectingResult<CVLExp, CVLError> quant(@NotNull CVLExp.QuantifierExp exp) {
                Intrinsics.checkNotNullParameter(exp, "exp");
                return CollectingResult.Companion.bind((CollectingResult)QuantifierChecker.INSTANCE.expr(CollectingResult.Companion.getOk(), exp.getBody()), (Function1)new Function1<Unit, CollectingResult<? extends CVLExp, ? extends CVLError>>(this, exp){
                    final /* synthetic */ 1 this$0;
                    final /* synthetic */ CVLExp.QuantifierExp $exp;
                    {
                        this.this$0 = $receiver;
                        this.$exp = $exp;
                        super(1);
                    }

                    @NotNull
                    public final CollectingResult<CVLExp, CVLError> invoke(@NotNull Unit it2) {
                        Intrinsics.checkNotNullParameter(it2, "it");
                        return CVLExpTransformer.DefaultImpls.quant(this.this$0, this.$exp);
                    }
                });
            }

            @Override
            @NotNull
            public CollectingResult<CVLLhs, CVLError> lhs(@NotNull CVLLhs lhs) {
                return CVLExpTransformer.DefaultImpls.lhs(this, lhs);
            }

            @Override
            @NotNull
            public CollectingResult<CVLLhs.Id, CVLError> idLhs(@NotNull CVLLhs.Id idLhs2) {
                return CVLExpTransformer.DefaultImpls.idLhs(this, idLhs2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp, CVLError> expr(@NotNull CVLExp exp) {
                return CVLExpTransformer.DefaultImpls.expr(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp, CVLError> application(@NotNull CVLExp.ApplicationExp exp) {
                return CVLExpTransformer.DefaultImpls.application(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp, CVLError> applyExp(@NotNull CVLExp.ApplyExp exp) {
                return CVLExpTransformer.DefaultImpls.applyExp(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.ApplyExp.CVLBuiltIn, CVLError> builtin(@NotNull CVLExp.ApplyExp.CVLBuiltIn exp) {
                return CVLExpTransformer.DefaultImpls.builtin(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.RelopExp, CVLError> relop(@NotNull CVLExp.RelopExp exp) {
                return CVLExpTransformer.DefaultImpls.relop(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.RelopExp.ArithRelopExp, CVLError> arithRelop(@NotNull CVLExp.RelopExp.ArithRelopExp exp) {
                return CVLExpTransformer.DefaultImpls.arithRelop(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp, CVLError> const(@NotNull CVLExp.Constant exp) {
                return CVLExpTransformer.DefaultImpls.const(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLLhs.Array, CVLError> arrayLhs(@NotNull CVLLhs.Array arrayLhs2) {
                return CVLExpTransformer.DefaultImpls.arrayLhs(this, arrayLhs2);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.UnresolvedApplyExp, CVLError> unresolvedApplyExp(@NotNull CVLExp.UnresolvedApplyExp exp) {
                return CVLExpTransformer.DefaultImpls.unresolvedApplyExp(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.AddressFunctionCallExp, CVLError> addressFunctionCall(@NotNull CVLExp.AddressFunctionCallExp exp) {
                return CVLExpTransformer.DefaultImpls.addressFunctionCall(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.RelopExp.ArithRelopExp.GeExp, CVLError> ge(@NotNull CVLExp.RelopExp.ArithRelopExp.GeExp exp) {
                return CVLExpTransformer.DefaultImpls.ge(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.RelopExp.ArithRelopExp.GtExp, CVLError> gt(@NotNull CVLExp.RelopExp.ArithRelopExp.GtExp exp) {
                return CVLExpTransformer.DefaultImpls.gt(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.RelopExp.ArithRelopExp.LeExp, CVLError> le(@NotNull CVLExp.RelopExp.ArithRelopExp.LeExp exp) {
                return CVLExpTransformer.DefaultImpls.le(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.RelopExp.ArithRelopExp.LtExp, CVLError> lt(@NotNull CVLExp.RelopExp.ArithRelopExp.LtExp exp) {
                return CVLExpTransformer.DefaultImpls.lt(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.RelopExp.EqExp, CVLError> eq(@NotNull CVLExp.RelopExp.EqExp exp) {
                return CVLExpTransformer.DefaultImpls.eq(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.RelopExp.NeExp, CVLError> ne(@NotNull CVLExp.RelopExp.NeExp exp) {
                return CVLExpTransformer.DefaultImpls.ne(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.BinaryExp.AddExp, CVLError> add(@NotNull CVLExp.BinaryExp.AddExp exp) {
                return CVLExpTransformer.DefaultImpls.add(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp, CVLError> enumConstant(@NotNull CVLExp.Constant.EnumConstant exp) {
                return CVLExpTransformer.DefaultImpls.enumConstant(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.Constant.BoolLit, CVLError> boolLit(@NotNull CVLExp.Constant.BoolLit exp) {
                return CVLExpTransformer.DefaultImpls.boolLit(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.Constant.NumberLit, CVLError> numberLit(@NotNull CVLExp.Constant.NumberLit exp) {
                return CVLExpTransformer.DefaultImpls.numberLit(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.Constant.StringLit, CVLError> stringLit(@NotNull CVLExp.Constant.StringLit exp) {
                return CVLExpTransformer.DefaultImpls.stringLit(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.Constant.StructLit, CVLError> structLit(@NotNull CVLExp.Constant.StructLit exp) {
                return CVLExpTransformer.DefaultImpls.structLit(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.Constant.SignatureLiteralExp, CVLError> signatureLit(@NotNull CVLExp.Constant.SignatureLiteralExp exp) {
                return CVLExpTransformer.DefaultImpls.signatureLit(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.ApplyExp.Ghost, CVLError> ghost(@NotNull CVLExp.ApplyExp.Ghost exp) {
                return CVLExpTransformer.DefaultImpls.ghost(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.CastExpr, CVLError> castExpression(@NotNull CVLExp.CastExpr exp) {
                return CVLExpTransformer.DefaultImpls.castExpression(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp, CVLError> definition(@NotNull CVLExp.ApplyExp.Definition exp) {
                return CVLExpTransformer.DefaultImpls.definition(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.ApplyExp.CVLFunction, CVLError> call(@NotNull CVLExp.ApplyExp.CVLFunction exp) {
                return CVLExpTransformer.DefaultImpls.call(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.BinaryExp.DivExp, CVLError> div(@NotNull CVLExp.BinaryExp.DivExp exp) {
                return CVLExpTransformer.DefaultImpls.div(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.BinaryExp.ModExp, CVLError> mod(@NotNull CVLExp.BinaryExp.ModExp exp) {
                return CVLExpTransformer.DefaultImpls.mod(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.BinaryExp.ExponentExp, CVLError> exponent(@NotNull CVLExp.BinaryExp.ExponentExp exp) {
                return CVLExpTransformer.DefaultImpls.exponent(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.BinaryExp.IffExp, CVLError> iff(@NotNull CVLExp.BinaryExp.IffExp exp) {
                return CVLExpTransformer.DefaultImpls.iff(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.BinaryExp.ImpliesExp, CVLError> implies(@NotNull CVLExp.BinaryExp.ImpliesExp exp) {
                return CVLExpTransformer.DefaultImpls.implies(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.BinaryExp.BwOrExp, CVLError> bwor(@NotNull CVLExp.BinaryExp.BwOrExp exp) {
                return CVLExpTransformer.DefaultImpls.bwor(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.BinaryExp.BwXOrExp, CVLError> bwxor(@NotNull CVLExp.BinaryExp.BwXOrExp exp) {
                return CVLExpTransformer.DefaultImpls.bwxor(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.BinaryExp.BwAndExp, CVLError> bwand(@NotNull CVLExp.BinaryExp.BwAndExp exp) {
                return CVLExpTransformer.DefaultImpls.bwand(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.BinaryExp.BwLeftShiftExp, CVLError> bwlsh(@NotNull CVLExp.BinaryExp.BwLeftShiftExp exp) {
                return CVLExpTransformer.DefaultImpls.bwlsh(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.BinaryExp.BwRightShiftExp, CVLError> bwrsh(@NotNull CVLExp.BinaryExp.BwRightShiftExp exp) {
                return CVLExpTransformer.DefaultImpls.bwrsh(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.BinaryExp.BwRightShiftWithZerosExp, CVLError> bwrshwzeros(@NotNull CVLExp.BinaryExp.BwRightShiftWithZerosExp exp) {
                return CVLExpTransformer.DefaultImpls.bwrshwzeros(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.UnaryExp.BwNotExp, CVLError> bwnot(@NotNull CVLExp.UnaryExp.BwNotExp exp) {
                return CVLExpTransformer.DefaultImpls.bwnot(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.ApplyExp.ContractFunction, CVLError> invokeExp(@NotNull CVLExp.ApplyExp.ContractFunction exp) {
                return CVLExpTransformer.DefaultImpls.invokeExp(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.ArrayLitExp, CVLError> arrayexp(@NotNull CVLExp.ArrayLitExp exp) {
                return CVLExpTransformer.DefaultImpls.arrayexp(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.CondExp, CVLError> condexp(@NotNull CVLExp.CondExp exp) {
                return CVLExpTransformer.DefaultImpls.condexp(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.BinaryExp.LandExp, CVLError> land(@NotNull CVLExp.BinaryExp.LandExp exp) {
                return CVLExpTransformer.DefaultImpls.land(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.BinaryExp.LorExp, CVLError> lor(@NotNull CVLExp.BinaryExp.LorExp exp) {
                return CVLExpTransformer.DefaultImpls.lor(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.BinaryExp.MulExp, CVLError> mul(@NotNull CVLExp.BinaryExp.MulExp exp) {
                return CVLExpTransformer.DefaultImpls.mul(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.UnaryExp.LNotExp, CVLError> neg(@NotNull CVLExp.UnaryExp.LNotExp exp) {
                return CVLExpTransformer.DefaultImpls.neg(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.FieldSelectExp, CVLError> fieldSel(@NotNull CVLExp.FieldSelectExp exp) {
                return CVLExpTransformer.DefaultImpls.fieldSel(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.SetMemExp, CVLError> setmem(@NotNull CVLExp.SetMemExp exp) {
                return CVLExpTransformer.DefaultImpls.setmem(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.ArrayDerefExp, CVLError> arrayderef(@NotNull CVLExp.ArrayDerefExp exp) {
                return CVLExpTransformer.DefaultImpls.arrayderef(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.BinaryExp.SubExp, CVLError> sub(@NotNull CVLExp.BinaryExp.SubExp exp) {
                return CVLExpTransformer.DefaultImpls.sub(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp.UnaryExp.UnaryMinusExp, CVLError> unaryMinus(@NotNull CVLExp.UnaryExp.UnaryMinusExp exp) {
                return CVLExpTransformer.DefaultImpls.unaryMinus(this, exp);
            }

            @Override
            @NotNull
            public CollectingResult<CVLExp, CVLError> variable(@NotNull CVLExp.VariableExp exp) {
                return CVLExpTransformer.DefaultImpls.variable(this, exp);
            }
        });
    }

    private final CollectingResult<Unit, CVLError> verifyMethodVariableDeclaration(CVLCmd.Simple.Declaration cmd2) {
        if (!Intrinsics.areEqual(cmd2.getCvlType(), EVMBuiltinTypes.INSTANCE.getMethod())) {
            return CollectingResult.Companion.getOk();
        }
        CVLScope.Item.RuleScopeItem ruleScopeItem = cmd2.getScope().enclosingRule();
        if (ruleScopeItem == null) {
            return CollectingResult.Companion.asError(new MethodVariableNotInRule(cmd2.getCvlRange()));
        }
        CVLScope.Item.RuleScopeItem enclosingRuleScopeItem = ruleScopeItem;
        if (enclosingRuleScopeItem.isDerivedFromInvariant()) {
            return CollectingResult.Companion.getOk();
        }
        if (!Intrinsics.areEqual(enclosingRuleScopeItem, CollectionsKt.last(cmd2.getScope().getScopeStack()))) {
            return CollectingResult.Companion.asError(new MethodVariableNotInRule(cmd2.getCvlRange()));
        }
        return CollectingResult.Companion.getOk();
    }

    @Override
    @NotNull
    public CollectingResult<CVLCmd, CVLError> decl(@NotNull CVLCmd.Simple.Declaration cmd2) {
        Intrinsics.checkNotNullParameter(cmd2, "cmd");
        return ErrorCollector.Companion.collectingErrors((Function1)new Function1<ErrorCollector<CVLError>, CVLCmd>(this, cmd2){
            final /* synthetic */ CVLCmdAddtionalChecks this$0;
            final /* synthetic */ CVLCmd.Simple.Declaration $cmd;
            {
                this.this$0 = $receiver;
                this.$cmd = $cmd;
                super(1);
            }

            @NotNull
            public final CVLCmd invoke(@NotNull ErrorCollector<CVLError> $this$collectingErrors) {
                Intrinsics.checkNotNullParameter($this$collectingErrors, "$this$collectingErrors");
                $this$collectingErrors.collect(CVLCmdAddtionalChecks.access$verifyMethodVariableDeclaration(this.this$0, this.$cmd));
                return (CVLCmd)$this$collectingErrors.bind(CVLCmdAddtionalChecks.access$decl$s688801304(this.this$0, this.$cmd));
            }
        });
    }

    @Override
    @NotNull
    public CollectingResult<CVLCmd, CVLError> def(@NotNull CVLCmd.Simple.Definition cmd2) {
        Intrinsics.checkNotNullParameter(cmd2, "cmd");
        if (!(!Intrinsics.areEqual(cmd2.getType(), EVMBuiltinTypes.INSTANCE.getMethod()))) {
            boolean bl = false;
            String string = "The typechecker should have prevented method-typed definitions";
            throw new IllegalStateException(string.toString());
        }
        if (cmd2.getExp() instanceof CVLExp.ApplyExp.ContractFunction && !((CVLExp.ApplyExp.ContractFunction)cmd2.getExp()).getNoRevert()) {
            CVLWarningLogger.INSTANCE.syntaxWarning(((CVLExp.ApplyExp.ContractFunction)cmd2.getExp()).getCallableName() + " is called with `@withrevert`, it's return values " + cmd2.getIdL() + " are undefined if this call reverts. Make sure to check that `!" + CVLKeywords.lastReverted.getKeyword() + "` before using them", cmd2.getCvlRange());
        }
        return super.def(cmd2);
    }

    public static final /* synthetic */ CollectingResult access$verifyMethodVariableDeclaration(CVLCmdAddtionalChecks $this, CVLCmd.Simple.Declaration cmd2) {
        return $this.verifyMethodVariableDeclaration(cmd2);
    }

    public static final /* synthetic */ CollectingResult access$decl$s688801304(CVLCmdAddtionalChecks $this, CVLCmd.Simple.Declaration cmd2) {
        return super.decl(cmd2);
    }
}

