/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast.typechecker;

import java.math.BigInteger;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLRange;
import spec.cvlast.CVLType;
import spec.cvlast.typechecker.CVLError;
import spec.cvlast.typechecker.CVLErrorCategory;
import spec.cvlast.typechecker.CVLErrorExample;
import spec.cvlast.typechecker.CVLErrorType;
import spec.cvlast.typechecker.NotConvertible$;
import utils.CollectingResult;
import utils.ExtStdlibKt;

@Serializable
@CVLErrorType(category=CVLErrorCategory.TYPECHECKING, description="\n        This error message indicates that you tried to use a value that cannot be automatically converted to the\n        expected type.  You may need to insert an explicit cast.  See {ref}`subtyping` for more information on types.\n        ")
@CVLErrorExample.Container(value={@CVLErrorExample(exampleCVLWithRange="\n        function example(env e) {\n            uint256 x = #e#;\n        }\n        ", exampleMessage="`e` has type `env`, which cannot be converted to the expected type `uint256`."), @CVLErrorExample(exampleCVLWithRange="sort s; function f(s x) { mathint y = #x# + 5; }"), @CVLErrorExample(exampleCVLWithRange="function f() { env e; uint x = #returnsStruct(e)#; }"), @CVLErrorExample(exampleCVLWithRange="function f() { bool b = #13#; }"), @CVLErrorExample(exampleCVLWithRange="function f() { bool[] b; bool bb = #b#; }"), @CVLErrorExample(exampleCVLWithRange="function f() { address[] a; address x; a = #x#; }"), @CVLErrorExample(exampleCVLWithRange="function f() { PrimaryContract.ExampleEnum x = #10#; }"), @CVLErrorExample(exampleCVLWithRange="function f() { PrimaryContract.ExampleEnum x = #1#; }", exampleMessage="Invalid enum literal.  Did you mean `PrimaryContract.ExampleEnum.MEMBER2`?"), @CVLErrorExample(exampleCVLWithRange="function f() { bytes32 u1 = #0x10000000000000000000000000000000000000000000000000000000000000000#; }"), @CVLErrorExample(exampleCVLWithRange="function f() { address a1 = #0x10000000000000000000000000000000000000001#; }")})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001d\u001eB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B-\b\u0011\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fB\u0017\b\u0002\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0010J&\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u00c1\u0001\u00a2\u0006\u0002\b\u001cR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lspec/cvlast/typechecker/NotConvertible;", "Lspec/cvlast/typechecker/CVLError;", "expression", "Lspec/cvlast/CVLExp;", "expectedType", "Lspec/cvlast/CVLType;", "(Lspec/cvlast/CVLExp;Lspec/cvlast/CVLType;)V", "seen1", "", "location", "Lspec/cvlast/CVLRange;", "message", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILspec/cvlast/CVLRange;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Lspec/cvlast/CVLRange;Ljava/lang/String;)V", "getLocation", "()Lspec/cvlast/CVLRange;", "getMessage", "()Ljava/lang/String;", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$Shared", "$serializer", "Companion", "Shared"})
public final class NotConvertible
extends CVLError {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CVLRange location;
    @NotNull
    private final String message;
    @JvmField
    @NotNull
    private static final KSerializer<Object>[] $childSerializers;

    private NotConvertible(CVLRange location, String message2) {
        super(null);
        this.location = location;
        this.message = message2;
    }

    @Override
    @NotNull
    public CVLRange getLocation() {
        return this.location;
    }

    @Override
    @NotNull
    public String getMessage() {
        return this.message;
    }

    public NotConvertible(@NotNull CVLExp expression, @NotNull CVLType expectedType) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(expectedType, "expectedType");
        this(expression.getRangeOrEmpty(), Companion.specialize(expression, expectedType));
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$Shared(NotConvertible self, CompositeEncoder output, SerialDescriptor serialDesc) {
        CVLError.write$Self(self, output, serialDesc);
        KSerializer<Object>[] kSerializerArray = $childSerializers;
        output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)kSerializerArray[0], self.getLocation());
        output.encodeStringElement(serialDesc, 1, self.getMessage());
    }

    @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
    public /* synthetic */ NotConvertible(int seen1, CVLRange location, String message2, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen1)) {
            PluginExceptionsKt.throwMissingFieldException(seen1, 3, $serializer.INSTANCE.getDescriptor());
        }
        super(seen1, serializationConstructorMarker);
        this.location = location;
        this.message = message2;
    }

    public static final /* synthetic */ KSerializer[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        KSerializer[] kSerializerArray = new KSerializer[]{CVLRange.Companion.serializer(), null};
        $childSerializers = kSerializerArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lspec/cvlast/typechecker/NotConvertible$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lspec/cvlast/typechecker/NotConvertible;", "specialize", "", "expression", "Lspec/cvlast/CVLExp;", "expectedType", "Lspec/cvlast/CVLType;", "Shared"})
    @SourceDebugExtension(value={"SMAP\nCVLErrorClasses.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CVLErrorClasses.kt\nspec/cvlast/typechecker/NotConvertible$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2355:1\n1#2:2356\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final String specialize(@NotNull CVLExp expression, @NotNull CVLType expectedType) {
            block11: {
                block9: {
                    block10: {
                        Intrinsics.checkNotNullParameter(expression, "expression");
                        Intrinsics.checkNotNullParameter(expectedType, "expectedType");
                        if (!(expression instanceof CVLExp.Constant)) break block9;
                        v0 = expectedType instanceof CVLType.PureCVLType.Enum != false ? (CVLType.PureCVLType.Enum)expectedType : null;
                        if (v0 == null) break block10;
                        it = v0;
                        $i$a$-let-NotConvertible$Companion$specialize$1 = false;
                        v1 = expression.eval();
                        if (v1 == null || (v1 = v1.getN()) == null) ** GOTO lbl-1000
                        it = var7_7 = v1;
                        $i$a$-takeIf-NotConvertible$Companion$specialize$1$1 = false;
                        v1 = ExtStdlibKt.isInt((BigInteger)it) != false ? var7_7 : null;
                        if (v1 != null) {
                            it = v1.intValue();
                            $i$a$-let-NotConvertible$Companion$specialize$1$2 = false;
                            v2 = CollectionsKt.getOrNull(((CVLType.PureCVLType.Enum)expectedType).getElements(), it);
                            if (v2 != null) {
                                constantName = v2;
                                $i$a$-let-NotConvertible$Companion$specialize$1$2$1 = false;
                                v3 = "Invalid enum literal.  Did you mean `" + ((CVLType.PureCVLType.Enum)expectedType).getName() + "." + constantName + "`?";
                            } else {
                                v3 = null;
                            }
                        } else lbl-1000:
                        // 2 sources

                        {
                            v3 = null;
                        }
                        v0 = v3;
                        if (v3 != null) break block11;
                    }
                    v0 = "Literal value `" + expression + "` cannot be assigned to type `" + expectedType + "`.";
                    break block11;
                }
                expressionType = expression.getCVLType();
                if (expressionType instanceof CVLType.VM) {
                    reason = ((CVLType.VM)expressionType).getDescriptor().converterTo((CVLType.PureCVLType)expectedType, ((CVLType.VM)expressionType).getContext().getVisitor());
                    if (!(reason instanceof CollectingResult.Error)) {
                        $i$a$-check-NotConvertible$Companion$specialize$2 = false;
                        var5_5 = "we should only reach here if the conversion isn't possible";
                        throw new IllegalStateException(var5_5.toString());
                    }
                    v0 = "`" + expression + "` has type `" + expression.getCVLType() + "` (from the VM), which cannot be converted to the expected CVL type `" + expectedType + "`.\nReason(s):\n    " + CollectionsKt.joinToString$default(((CollectingResult.Error)reason).getMessages(), "\n\t", null, null, 0, null, null, 62, null);
                } else {
                    v0 = "`" + expression + "` has type `" + expression.getCVLType() + "`, which cannot be converted to the expected type `" + expectedType + "`.";
                }
            }
            return v0;
        }

        @NotNull
        public final KSerializer<NotConvertible> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

