/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.util.List;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import utils.CompilerVersion;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0017B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0000H\u0096\u0002J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\f\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0018"}, d2={"Lutils/CompilerVersion;", "", "major", "", "minor", "patch", "(III)V", "getMajor", "()I", "getMinor", "getPatch", "compareTo", "other", "component1", "component2", "component3", "copy", "equals", "", "", "hashCode", "toString", "", "Companion", "GeneralUtils"})
public final class CompilerVersion
implements Comparable<CompilerVersion> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int major;
    private final int minor;
    private final int patch;

    public CompilerVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getPatch() {
        return this.patch;
    }

    @Override
    public int compareTo(@NotNull CompilerVersion other) {
        Intrinsics.checkNotNullParameter(other, "other");
        Function1[] function1Array = new Function1[]{compareTo.1.INSTANCE, compareTo.2.INSTANCE, compareTo.3.INSTANCE};
        return ComparisonsKt.compareBy(function1Array).compare(this, other);
    }

    @NotNull
    public String toString() {
        return this.major + "." + this.minor + "." + this.patch;
    }

    public final int component1() {
        return this.major;
    }

    public final int component2() {
        return this.minor;
    }

    public final int component3() {
        return this.patch;
    }

    @NotNull
    public final CompilerVersion copy(int major, int minor, int patch) {
        return new CompilerVersion(major, minor, patch);
    }

    public static /* synthetic */ CompilerVersion copy$default(CompilerVersion compilerVersion, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = compilerVersion.major;
        }
        if ((n4 & 2) != 0) {
            n2 = compilerVersion.minor;
        }
        if ((n4 & 4) != 0) {
            n3 = compilerVersion.patch;
        }
        return compilerVersion.copy(n, n2, n3);
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.major);
        result2 = result2 * 31 + Integer.hashCode(this.minor);
        result2 = result2 * 31 + Integer.hashCode(this.patch);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CompilerVersion)) {
            return false;
        }
        CompilerVersion compilerVersion = (CompilerVersion)other;
        if (this.major != compilerVersion.major) {
            return false;
        }
        if (this.minor != compilerVersion.minor) {
            return false;
        }
        return this.patch == compilerVersion.patch;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lutils/CompilerVersion$Companion;", "", "()V", "fromStringOrNull", "Lutils/CompilerVersion;", "s", "", "GeneralUtils"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final CompilerVersion fromStringOrNull(@NotNull String s) {
            CompilerVersion compilerVersion;
            Intrinsics.checkNotNullParameter(s, "s");
            String[] stringArray = new String[]{"."};
            List splitByDot = StringsKt.split$default((CharSequence)s, stringArray, false, 0, 6, null);
            if (splitByDot.size() != 3) {
                return null;
            }
            Integer n = StringsKt.toIntOrNull((String)splitByDot.get(0));
            if (n != null) {
                int major = ((Number)n).intValue();
                boolean bl = false;
                Integer n2 = StringsKt.toIntOrNull((String)splitByDot.get(1));
                if (n2 != null) {
                    int minor = ((Number)n2).intValue();
                    boolean bl2 = false;
                    Integer n3 = StringsKt.toIntOrNull((String)splitByDot.get(2));
                    if (n3 != null) {
                        int patch = ((Number)n3).intValue();
                        boolean bl3 = false;
                        compilerVersion = new CompilerVersion(major, minor, patch);
                    } else {
                        compilerVersion = null;
                    }
                } else {
                    compilerVersion = null;
                }
            } else {
                compilerVersion = null;
            }
            return compilerVersion;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

