/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.Closeable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import log.ArtifactManagerFactory;
import log.IArtifactsManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import utils.ArtifactFileUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0004J\u0012\u0010\r\u001a\u00020\n2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\bJ\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00042\b\b\u0002\u0010\u0011\u001a\u00020\u0006J\"\u0010\u000f\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u00042\b\b\u0002\u0010\u0011\u001a\u00020\u0006J\u000e\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0016\u001a\u0004\u0018\u00010\u0004*\u00020\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lutils/OutPrinter;", "", "()V", "_file", "", "isInit", "", "resultsFile", "Ljava/io/PrintWriter;", "close", "", "dumpThreads", "filename", "init", "customPrintWriter", "print", "x", "toStdout", "t", "", "printErrorToScreen", "printWarningToScreen", "toStringFull", "Ljava/lang/management/ThreadInfo;", "Shared"})
public final class OutPrinter {
    @NotNull
    public static final OutPrinter INSTANCE = new OutPrinter();
    @NotNull
    private static final String _file = ArtifactFileUtils.INSTANCE.getResultFile();
    private static boolean isInit;
    @NotNull
    private static PrintWriter resultsFile;

    private OutPrinter() {
    }

    public final void init(@Nullable PrintWriter customPrintWriter) {
        if (!isInit) {
            isInit = true;
            if (customPrintWriter == null) {
                IArtifactsManager.DefaultImpls.registerArtifact$default(ArtifactManagerFactory.INSTANCE.invoke(), _file, null, 2, null);
                resultsFile = new PrintWriter(ArtifactManagerFactory.INSTANCE.invoke().getArtifactHandle(_file));
            } else {
                resultsFile = customPrintWriter;
            }
        }
    }

    public static /* synthetic */ void init$default(OutPrinter outPrinter, PrintWriter printWriter, int n, Object object) {
        if ((n & 1) != 0) {
            printWriter = null;
        }
        outPrinter.init(printWriter);
    }

    public final void close() {
        if (isInit) {
            resultsFile.close();
            isInit = false;
        }
    }

    public final void printWarningToScreen(@NotNull String x) {
        Intrinsics.checkNotNullParameter(x, "x");
        System.out.println((Object)("Warning: " + x));
    }

    public final void printErrorToScreen(@NotNull String x) {
        Intrinsics.checkNotNullParameter(x, "x");
        System.out.println((Object)("Error: " + x));
    }

    public final void print(@NotNull String x, boolean toStdout) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.print(null, x, toStdout);
    }

    public static /* synthetic */ void print$default(OutPrinter outPrinter, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        outPrinter.print(string, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void print(@Nullable Throwable t, @NotNull String x, boolean toStdout) {
        Intrinsics.checkNotNullParameter(x, "x");
        if (toStdout) {
            System.out.println((Object)x);
        }
        try {
            PrintWriter printWriter;
            PrintWriter printWriter2 = printWriter = resultsFile;
            synchronized (printWriter2) {
                Unit unit;
                boolean bl = false;
                Appendable appendable = ((Appendable)resultsFile).append(x);
                Intrinsics.checkNotNullExpressionValue(appendable, "append(...)");
                Intrinsics.checkNotNullExpressionValue(appendable.append('\n'), "append(...)");
                Throwable throwable = t;
                if (throwable != null) {
                    throwable.printStackTrace(resultsFile);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                Unit unit2 = unit;
            }
            resultsFile.flush();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static /* synthetic */ void print$default(OutPrinter outPrinter, Throwable throwable, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        outPrinter.print(throwable, string, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dumpThreads(@NotNull String filename) {
        Intrinsics.checkNotNullParameter(filename, "filename");
        IArtifactsManager.DefaultImpls.registerArtifact$default(ArtifactManagerFactory.INSTANCE.invoke(), filename, null, 2, null);
        Closeable closeable = ArtifactManagerFactory.INSTANCE.invoke().getArtifactHandle(filename);
        Throwable throwable = null;
        try {
            OutputStreamWriter file = (OutputStreamWriter)closeable;
            boolean bl = false;
            ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
            Intrinsics.checkNotNullExpressionValue(threadMXBean, "getThreadMXBean(...)");
            ThreadMXBean threadMXBean2 = threadMXBean;
            ThreadInfo[] threadInfoArray = threadMXBean2.dumpAllThreads(true, true);
            Intrinsics.checkNotNullExpressionValue(threadInfoArray, "dumpAllThreads(...)");
            for (ThreadInfo threadInfo : threadInfoArray) {
                Intrinsics.checkNotNull(threadInfo);
                file.append(INSTANCE.toStringFull(threadInfo));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    private final String toStringFull(ThreadInfo $this$toStringFull) {
        int i2;
        StringBuilder sb = new StringBuilder("\"" + $this$toStringFull.getThreadName() + "\"" + ($this$toStringFull.isDaemon() ? " daemon" : "") + " prio=" + $this$toStringFull.getPriority() + " Id=" + $this$toStringFull.getThreadId() + " " + $this$toStringFull.getThreadState());
        if ($this$toStringFull.getLockName() != null) {
            sb.append(" on " + $this$toStringFull.getLockName());
        }
        if ($this$toStringFull.getLockOwnerName() != null) {
            sb.append(" owned by \"" + $this$toStringFull.getLockOwnerName() + "\" Id=" + $this$toStringFull.getLockOwnerId());
        }
        if ($this$toStringFull.isSuspended()) {
            sb.append(" (suspended)");
        }
        if ($this$toStringFull.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        for (i2 = 0; i2 < $this$toStringFull.getStackTrace().length; ++i2) {
            MonitorInfo[] monitorInfoArray;
            StackTraceElement ste;
            Intrinsics.checkNotNullExpressionValue($this$toStringFull.getStackTrace()[i2], "get(...)");
            sb.append("\tat " + ste);
            sb.append('\n');
            if (i2 == 0 && $this$toStringFull.getLockInfo() != null) {
                Thread.State ts;
                Intrinsics.checkNotNullExpressionValue((Object)$this$toStringFull.getThreadState(), "getThreadState(...)");
                switch (WhenMappings.$EnumSwitchMapping$0[ts.ordinal()]) {
                    case 1: {
                        sb.append("\t-  blocked on " + $this$toStringFull.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case 2: {
                        sb.append("\t-  waiting on " + $this$toStringFull.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case 3: {
                        sb.append("\t-  waiting on " + $this$toStringFull.getLockInfo());
                        sb.append('\n');
                    }
                }
            }
            Intrinsics.checkNotNullExpressionValue($this$toStringFull.getLockedMonitors(), "getLockedMonitors(...)");
            for (MonitorInfo monitorInfo : monitorInfoArray) {
                Intrinsics.checkNotNull(monitorInfo);
                MonitorInfo mi = monitorInfo;
                if (mi.getLockedStackDepth() != i2) continue;
                sb.append("\t-  locked " + mi);
                sb.append('\n');
            }
        }
        if (i2 < $this$toStringFull.getStackTrace().length) {
            sb.append("\t...");
            sb.append('\n');
        }
        LockInfo[] lockInfoArray = $this$toStringFull.getLockedSynchronizers();
        Intrinsics.checkNotNullExpressionValue(lockInfoArray, "getLockedSynchronizers(...)");
        LockInfo[] locks = lockInfoArray;
        if (locks.length > 0) {
            sb.append("\n\tNumber of locked synchronizers = " + locks.length);
            sb.append('\n');
            for (LockInfo li : locks) {
                sb.append("\t- " + li);
                sb.append('\n');
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    static {
        resultsFile = new PrintWriter(new OutputStreamWriter(OutputStream.nullOutputStream()));
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Thread.State.values().length];
            try {
                nArray[Thread.State.BLOCKED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Thread.State.WAITING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Thread.State.TIMED_WAITING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

