/*
 * Decompiled with CFR 0.152.
 */
package utils;

import config.Config;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import utils.ExtStdlibKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u0004J\u001a\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u0004H\u0007J\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004J\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004J\u0014\u0010\u000e\u001a\u00020\b*\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u0004J\u0014\u0010\u000f\u001a\u00020\b*\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lutils/SignUtilities;", "", "()V", "defaultBitwidth", "", "isInSignedBounds", "", "n", "Ljava/math/BigInteger;", "bitWidth", "isInUnsignedBounds", "maxSignedValueOfBitwidth", "maxUnsignedValueOfBitwidth", "minSignedValueOfBitwidth", "from2sComplement", "to2sComplement", "Shared"})
@SourceDebugExtension(value={"SMAP\nSignUtilities.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SignUtilities.kt\nutils/SignUtilities\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n1#2:65\n*E\n"})
public final class SignUtilities {
    @NotNull
    public static final SignUtilities INSTANCE = new SignUtilities();
    private static final int defaultBitwidth = Config.INSTANCE.getVMConfig().getRegisterBitwidth();

    private SignUtilities() {
    }

    @NotNull
    public final BigInteger minSignedValueOfBitwidth(int bitWidth) {
        if (!(bitWidth > 0)) {
            boolean bl = false;
            String string = "Value out of bounds for bitwidth: " + bitWidth;
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger bigInteger = BigInteger.TWO.pow(bitWidth - 1);
        Intrinsics.checkNotNullExpressionValue(bigInteger, "pow(...)");
        BigInteger bigInteger2 = bigInteger.negate();
        Intrinsics.checkNotNullExpressionValue(bigInteger2, "negate(...)");
        return bigInteger2;
    }

    @NotNull
    public final BigInteger maxSignedValueOfBitwidth(int bitWidth) {
        return this.maxUnsignedValueOfBitwidth(bitWidth - 1);
    }

    @NotNull
    public final BigInteger maxUnsignedValueOfBitwidth(int bitWidth) {
        if (!(bitWidth >= 0)) {
            boolean bl = false;
            String string = "Value out of bounds for bitwidth: " + bitWidth;
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger bigInteger = BigInteger.TWO.pow(bitWidth);
        Intrinsics.checkNotNullExpressionValue(bigInteger, "pow(...)");
        return ExtStdlibKt.minus(bigInteger, 1);
    }

    @JvmOverloads
    public final boolean isInUnsignedBounds(@NotNull BigInteger n, int bitWidth) {
        Intrinsics.checkNotNullParameter(n, "n");
        return n.compareTo(BigInteger.ZERO) >= 0 && n.compareTo(this.maxUnsignedValueOfBitwidth(bitWidth)) <= 0;
    }

    public static /* synthetic */ boolean isInUnsignedBounds$default(SignUtilities signUtilities, BigInteger bigInteger, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = defaultBitwidth;
        }
        return signUtilities.isInUnsignedBounds(bigInteger, n);
    }

    public final boolean isInSignedBounds(@NotNull BigInteger n, int bitWidth) {
        Intrinsics.checkNotNullParameter(n, "n");
        return n.compareTo(this.minSignedValueOfBitwidth(bitWidth)) >= 0 && n.compareTo(this.maxSignedValueOfBitwidth(bitWidth)) <= 0;
    }

    public static /* synthetic */ boolean isInSignedBounds$default(SignUtilities signUtilities, BigInteger bigInteger, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = defaultBitwidth;
        }
        return signUtilities.isInSignedBounds(bigInteger, n);
    }

    @NotNull
    public final BigInteger from2sComplement(@NotNull BigInteger $this$from2sComplement, int bitWidth) {
        BigInteger bigInteger;
        Intrinsics.checkNotNullParameter($this$from2sComplement, "<this>");
        if (!this.isInUnsignedBounds($this$from2sComplement, bitWidth)) {
            boolean bl = false;
            String string = "converting " + $this$from2sComplement + " from 2s-complement form, but it's not in range.";
            throw new IllegalArgumentException(string.toString());
        }
        if ($this$from2sComplement.compareTo(this.maxSignedValueOfBitwidth(bitWidth)) > 0) {
            BigInteger bigInteger2 = $this$from2sComplement;
            BigInteger bigInteger3 = BigInteger.TWO.pow(bitWidth);
            Intrinsics.checkNotNullExpressionValue(bigInteger3, "pow(...)");
            BigInteger bigInteger4 = bigInteger2.subtract(bigInteger3);
            bigInteger = bigInteger4;
            Intrinsics.checkNotNullExpressionValue(bigInteger4, "subtract(...)");
        } else {
            bigInteger = $this$from2sComplement;
        }
        return bigInteger;
    }

    public static /* synthetic */ BigInteger from2sComplement$default(SignUtilities signUtilities, BigInteger bigInteger, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = defaultBitwidth;
        }
        return signUtilities.from2sComplement(bigInteger, n);
    }

    @NotNull
    public final BigInteger to2sComplement(@NotNull BigInteger $this$to2sComplement, int bitWidth) {
        BigInteger bigInteger;
        Intrinsics.checkNotNullParameter($this$to2sComplement, "<this>");
        if (!this.isInSignedBounds($this$to2sComplement, bitWidth)) {
            boolean bl = false;
            String string = "converting " + $this$to2sComplement + " from mathint to 2s-complement form, but it's not in range.";
            throw new IllegalArgumentException(string.toString());
        }
        if ($this$to2sComplement.compareTo(BigInteger.ZERO) < 0) {
            BigInteger bigInteger2 = $this$to2sComplement;
            BigInteger bigInteger3 = BigInteger.TWO.pow(bitWidth);
            Intrinsics.checkNotNullExpressionValue(bigInteger3, "pow(...)");
            BigInteger bigInteger4 = bigInteger2.add(bigInteger3);
            bigInteger = bigInteger4;
            Intrinsics.checkNotNullExpressionValue(bigInteger4, "add(...)");
        } else {
            bigInteger = $this$to2sComplement;
        }
        return bigInteger;
    }

    public static /* synthetic */ BigInteger to2sComplement$default(SignUtilities signUtilities, BigInteger bigInteger, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = defaultBitwidth;
        }
        return signUtilities.to2sComplement(bigInteger, n);
    }

    @JvmOverloads
    public final boolean isInUnsignedBounds(@NotNull BigInteger n) {
        Intrinsics.checkNotNullParameter(n, "n");
        return SignUtilities.isInUnsignedBounds$default(this, n, 0, 2, null);
    }
}

