"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, RequestMetadata
import pydantic
from pydantic import model_serializer
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class TestWebhookRequestBodyTypedDict(TypedDict):
    __test__ = False  # pyright: ignore[reportGeneralTypeIssues]

    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class TestWebhookRequestBody(BaseModel):
    __test__ = False

    testmode: OptionalNullable[bool] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["testmode"]
        nullable_fields = ["testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class TestWebhookRequestTypedDict(TypedDict):
    __test__ = False  # pyright: ignore[reportGeneralTypeIssues]

    id: str
    r"""Provide the ID of the item you want to perform this operation on."""
    request_body: NotRequired[TestWebhookRequestBodyTypedDict]


class TestWebhookRequest(BaseModel):
    __test__ = False

    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Provide the ID of the item you want to perform this operation on."""

    request_body: Annotated[
        Optional[TestWebhookRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None


class TestWebhookWebhooksDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    __test__ = False  # pyright: ignore[reportGeneralTypeIssues]

    href: str
    type: str


class TestWebhookWebhooksDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    __test__ = False

    href: str

    type: str


class TestWebhookWebhooksLinksTypedDict(TypedDict):
    __test__ = False  # pyright: ignore[reportGeneralTypeIssues]

    documentation: TestWebhookWebhooksDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class TestWebhookWebhooksLinks(BaseModel):
    __test__ = False

    documentation: TestWebhookWebhooksDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class TestWebhookWebhooksResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[TestWebhookWebhooksLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""


class TestWebhookWebhooksResponseBody(Exception):
    r"""An error response object."""

    data: TestWebhookWebhooksResponseBodyData

    def __init__(self, data: TestWebhookWebhooksResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, TestWebhookWebhooksResponseBodyData)


class TestWebhookDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    __test__ = False  # pyright: ignore[reportGeneralTypeIssues]

    href: str
    type: str


class TestWebhookDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    __test__ = False

    href: str

    type: str


class TestWebhookLinksTypedDict(TypedDict):
    __test__ = False  # pyright: ignore[reportGeneralTypeIssues]

    documentation: TestWebhookDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class TestWebhookLinks(BaseModel):
    __test__ = False

    documentation: TestWebhookDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class TestWebhookResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[TestWebhookLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""


class TestWebhookResponseBody(Exception):
    r"""An error response object."""

    data: TestWebhookResponseBodyData

    def __init__(self, data: TestWebhookResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, TestWebhookResponseBodyData)
