import { IDictionary } from '@elyra/services';
import { Dialog } from '@jupyterlab/apputils';
export declare const KFP_SCHEMA = "kfp";
export declare const RUNTIMES_NAMESPACE = "runtimes";
export declare const RUNTIME_IMAGES_NAMESPACE = "runtime-images";
export declare const COMPONENTS_NAMESPACE = "components";
export interface IRuntime {
    name: string;
    display_name: string;
    schema_name: string;
}
export interface ISchema {
    name: string;
    display_name: string;
}
export declare class PipelineService {
    /**
     * Returns a list of external runtime configurations available as
     * `runtimes metadata`. This is used to submit the pipeline to be
     * executed on these runtimes.
     */
    static getRuntimes(showError?: boolean, action?: string): Promise<any>;
    /**
     * Submit the pipeline to be executed on an external runtime (e.g. Kbeflow Pipelines)
     *
     * @param pipeline
     * @param runtimeName
     */
    static getRuntimeComponents(runtimeName: string): Promise<any>;
    /**
     * Submit the pipeline to be executed on an external runtime (e.g. Kbeflow Pipelines)
     *
     * @param pipeline
     * @param runtimeName
     */
    static getComponentProperties(runtimeName: string, componentId: string): Promise<any>;
    /**
     * Returns a list of runtime schema
     */
    static getRuntimesSchema(showError?: boolean): Promise<any>;
    /**
     * Returns a list of external runtime configurations
     * based on the runtimePlatform (Airflow or Kubeflow)
     */
    static filterRuntimes: (runtimes: IRuntime[], runtimePlatform: string) => IRuntime[];
    /**
     * Returns a list of external schema configurations
     * based a list of runtimes instances
     */
    static filterValidSchema: (runtimes: IRuntime[], schema: ISchema[]) => ISchema[];
    /**
     * Sorts given list of runtimes by the display_name property
     */
    static sortRuntimesByDisplayName: (runtimes: IRuntime[]) => void;
    /**
     * Return a list of configured docker images that are used as runtimes environments
     * to run the pipeline nodes.
     */
    static getRuntimeImages(): Promise<any>;
    static getDisplayName(name: string, metadataArr: IDictionary<any>[]): string;
    /**
     * The runtime name is currently based on the schema name (one schema per runtime)
     * @param name
     * @param metadataArr
     */
    static getRuntimeName(name: string, metadataArr: IDictionary<any>[]): string;
    /**
     * Creates a Dialog for passing to makeServerRequest
     */
    static getWaitDialog(title?: string, body?: string): Dialog<any>;
    /**
     * Submit the pipeline to be executed on an external runtime (e.g. Kbeflow Pipelines)
     *
     * @param pipeline
     * @param runtimeName
     */
    static submitPipeline(pipeline: any, runtimeName: string): Promise<any>;
    /**
     * Export a pipeline to different formats (e.g. DSL, YAML, etc). These formats
     * are understood by a given runtime.
     *
     * @param pipeline
     * @param pipeline_export_format
     * @param pipeline_export_path
     * @param overwrite
     */
    static exportPipeline(pipeline: any, pipeline_export_format: string, pipeline_export_path: string, overwrite: boolean): Promise<any>;
    static getNodeType(filepath: string): string;
    /**
     * Check if a given file is allowed to be added to the pipeline
     * @param item
     */
    static isSupportedNode(file: any): boolean;
    static getPipelineRelativeNodePath(pipelinePath: string, nodePath: string): string;
    static getWorkspaceRelativeNodePath(pipelinePath: string, nodePath: string): string;
    static setNodePathsRelativeToPipeline(pipeline: any, pipelinePath: string): any;
    static setNodePathsRelativeToWorkspace(pipeline: any, pipelinePath: string): any;
}
