import { LabShell } from '@jupyterlab/application';
/**
 * A utilities class for static functions.
 */
export default class Utils {
    /**
     * Utility to create a one node pipeline to submit a single file as a pipeline
     */
    static generateSingleFilePipeline(filename: string, runtime_platform: string, runtime_config: string, runtimeImage: string, dependencies: string[] | undefined, envObject: {
        [key: string]: string;
    }, cpu?: number, gpu?: number, memory?: number): any;
    /**
     * Break an array into an array of "chunks", each "chunk" having "n" elements.
     * The final "chuck" may have less than "n" elements.
     * Example:
     * chunkArray(['a', 'b', 'c', 'd', 'e', 'f', 'g'], 4)
     * -> [['a', 'b', 'c', 'd'], ['e', 'f', 'g']]
     */
    static chunkArray<T>(arr: T[], n: number): T[][];
    /**
     * Check if the object is not an array, but the result of a Dialog instead
     */
    static isDialogResult(runtimesObj: any): boolean;
    /**
     * From a given widget, find the application shell and return it
     */
    static getLabShell: (widget: any) => LabShell;
}
