# coding: utf-8

"""
    Kalshi Trade API Manual Endpoints

    Manually defined OpenAPI spec for endpoints being migrated to spec-first approach

    The version of the OpenAPI document: 3.4.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from kalshi_python_sync.models.market import Market
from typing import Optional, Set
from typing_extensions import Self

class EventData(BaseModel):
    """
    EventData
    """ # noqa: E501
    event_ticker: StrictStr = Field(description="Unique identifier for this event.")
    series_ticker: StrictStr = Field(description="Unique identifier for the series this event belongs to.")
    sub_title: StrictStr = Field(description="Shortened descriptive title for the event.")
    title: StrictStr = Field(description="Full title of the event.")
    collateral_return_type: StrictStr = Field(description="Specifies how collateral is returned when markets settle (e.g., 'binary' for standard yes/no markets).")
    mutually_exclusive: StrictBool = Field(description="If true, only one market in this event can resolve to 'yes'. If false, multiple markets can resolve to 'yes'.")
    category: StrictStr = Field(description="Event category (deprecated, use series-level category instead).")
    strike_date: Optional[datetime] = Field(default=None, description="The specific date this event is based on. Only filled when the event uses a date strike (mutually exclusive with strike_period).")
    strike_period: Optional[StrictStr] = Field(default=None, description="The time period this event covers (e.g., 'week', 'month'). Only filled when the event uses a period strike (mutually exclusive with strike_date).")
    markets: Optional[List[Market]] = Field(default=None, description="Array of markets associated with this event. Only populated when 'with_nested_markets=true' is specified in the request.")
    available_on_brokers: StrictBool = Field(description="Whether this event is available to trade on brokers.")
    product_metadata: Optional[Dict[str, Any]] = Field(description="Additional metadata for the event.")
    __properties: ClassVar[List[str]] = ["event_ticker", "series_ticker", "sub_title", "title", "collateral_return_type", "mutually_exclusive", "category", "strike_date", "strike_period", "markets", "available_on_brokers", "product_metadata"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EventData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in markets (list)
        _items = []
        if self.markets:
            for _item_markets in self.markets:
                if _item_markets:
                    _items.append(_item_markets.to_dict())
            _dict['markets'] = _items
        # set to None if strike_date (nullable) is None
        # and model_fields_set contains the field
        if self.strike_date is None and "strike_date" in self.model_fields_set:
            _dict['strike_date'] = None

        # set to None if strike_period (nullable) is None
        # and model_fields_set contains the field
        if self.strike_period is None and "strike_period" in self.model_fields_set:
            _dict['strike_period'] = None

        # set to None if product_metadata (nullable) is None
        # and model_fields_set contains the field
        if self.product_metadata is None and "product_metadata" in self.model_fields_set:
            _dict['product_metadata'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EventData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "event_ticker": obj.get("event_ticker"),
            "series_ticker": obj.get("series_ticker"),
            "sub_title": obj.get("sub_title"),
            "title": obj.get("title"),
            "collateral_return_type": obj.get("collateral_return_type"),
            "mutually_exclusive": obj.get("mutually_exclusive"),
            "category": obj.get("category"),
            "strike_date": obj.get("strike_date"),
            "strike_period": obj.get("strike_period"),
            "markets": [Market.from_dict(_item) for _item in obj["markets"]] if obj.get("markets") is not None else None,
            "available_on_brokers": obj.get("available_on_brokers"),
            "product_metadata": obj.get("product_metadata")
        })
        return _obj


