# coding: utf-8

"""
    Kalshi Trade API Manual Endpoints

    Manually defined OpenAPI spec for endpoints being migrated to spec-first approach

    The version of the OpenAPI document: 3.4.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class Trade(BaseModel):
    """
    Trade
    """ # noqa: E501
    trade_id: StrictStr = Field(description="Unique identifier for this trade")
    ticker: StrictStr = Field(description="Unique identifier for the market")
    price: Union[StrictFloat, StrictInt] = Field(description="Trade price (deprecated - use yes_price or no_price)")
    count: StrictInt = Field(description="Number of contracts bought or sold in this trade")
    yes_price: StrictInt = Field(description="Yes price for this trade in cents")
    no_price: StrictInt = Field(description="No price for this trade in cents")
    yes_price_dollars: StrictStr = Field(description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    no_price_dollars: StrictStr = Field(description="US dollar amount as a fixed-point decimal string with exactly 4 decimal places")
    taker_side: StrictStr = Field(description="Side for the taker of this trade")
    created_time: Optional[datetime] = Field(default=None, description="Timestamp when this trade was executed")
    __properties: ClassVar[List[str]] = ["trade_id", "ticker", "price", "count", "yes_price", "no_price", "yes_price_dollars", "no_price_dollars", "taker_side", "created_time"]

    @field_validator('taker_side')
    def taker_side_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['yes', 'no']):
            raise ValueError("must be one of enum values ('yes', 'no')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Trade from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Trade from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "trade_id": obj.get("trade_id"),
            "ticker": obj.get("ticker"),
            "price": obj.get("price"),
            "count": obj.get("count"),
            "yes_price": obj.get("yes_price"),
            "no_price": obj.get("no_price"),
            "yes_price_dollars": obj.get("yes_price_dollars"),
            "no_price_dollars": obj.get("no_price_dollars"),
            "taker_side": obj.get("taker_side"),
            "created_time": obj.get("created_time")
        })
        return _obj


