# coding: utf-8

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.

    The version of the OpenAPI document: 1.13.2
    Contact: info@songtradr.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictFloat, StrictInt, StrictStr, conlist

from typing import List, Optional, Union

from songtradr_api_client_python.models.recording_for_similarity_search_dto import RecordingForSimilaritySearchDTO
from songtradr_api_client_python.models.recording_large_dto import RecordingLargeDTO
from songtradr_api_client_python.models.recording_list_dto import RecordingListDTO
from songtradr_api_client_python.models.recording_medium_dto import RecordingMediumDTO
from songtradr_api_client_python.models.recording_minimal_with_musical_features_dto import RecordingMinimalWithMusicalFeaturesDTO
from songtradr_api_client_python.models.recording_minimal_with_taggrams_dto import RecordingMinimalWithTaggramsDTO
from songtradr_api_client_python.models.recording_minimal_with_tagstrengths_dto import RecordingMinimalWithTagstrengthsDTO
from songtradr_api_client_python.models.recording_small_dto import RecordingSmallDTO
from songtradr_api_client_python.models.search_recording_granular_abstraction_dto import SearchRecordingGranularAbstractionDTO
from songtradr_api_client_python.models.search_recording_granular_dto import SearchRecordingGranularDTO

from songtradr_api_client_python.api_client import ApiClient
from songtradr_api_client_python.api_response import ApiResponse
from songtradr_api_client_python.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class RecordingApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def recordings_by_ids_with_musical_features(self, ids : Annotated[StrictStr, Field(..., description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")], **kwargs) -> List[RecordingMinimalWithMusicalFeaturesDTO]:  # noqa: E501
        """AI generated moods, musical features and more for recordings.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.recordings_by_ids_with_musical_features(ids, async_req=True)
        >>> result = thread.get()

        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[RecordingMinimalWithMusicalFeaturesDTO]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the recordings_by_ids_with_musical_features_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.recordings_by_ids_with_musical_features_with_http_info(ids, **kwargs)  # noqa: E501

    @validate_arguments
    def recordings_by_ids_with_musical_features_with_http_info(self, ids : Annotated[StrictStr, Field(..., description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")], **kwargs) -> ApiResponse:  # noqa: E501
        """AI generated moods, musical features and more for recordings.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.recordings_by_ids_with_musical_features_with_http_info(ids, async_req=True)
        >>> result = thread.get()

        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[RecordingMinimalWithMusicalFeaturesDTO], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'ids'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method recordings_by_ids_with_musical_features" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['ids']:
            _path_params['ids'] = _params['ids']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearer-jwt']  # noqa: E501

        _response_types_map = {
            '200': "List[RecordingMinimalWithMusicalFeaturesDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/api/v1/public/recording/{ids}/musicalFeatures', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def recordings_by_ids_with_similarities(self, ids : Annotated[StrictStr, Field(..., description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")], **kwargs) -> List[RecordingForSimilaritySearchDTO]:  # noqa: E501
        """Similar recordings for a list of recordings.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.recordings_by_ids_with_similarities(ids, async_req=True)
        >>> result = thread.get()

        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[RecordingForSimilaritySearchDTO]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the recordings_by_ids_with_similarities_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.recordings_by_ids_with_similarities_with_http_info(ids, **kwargs)  # noqa: E501

    @validate_arguments
    def recordings_by_ids_with_similarities_with_http_info(self, ids : Annotated[StrictStr, Field(..., description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")], **kwargs) -> ApiResponse:  # noqa: E501
        """Similar recordings for a list of recordings.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.recordings_by_ids_with_similarities_with_http_info(ids, async_req=True)
        >>> result = thread.get()

        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[RecordingForSimilaritySearchDTO], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'ids'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method recordings_by_ids_with_similarities" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['ids']:
            _path_params['ids'] = _params['ids']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearer-jwt']  # noqa: E501

        _response_types_map = {
            '200': "List[RecordingForSimilaritySearchDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/api/v1/public/recording/{ids}/similarities', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def recordings_by_ids_with_taggrams(self, ids : Annotated[StrictStr, Field(..., description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")], category_name : Annotated[Optional[StrictStr], Field(description="Show only taggrams for one category.")] = None, tag_name : Annotated[Optional[StrictStr], Field(description="Show only taggrams for one tag.")] = None, genre_name : Annotated[Optional[StrictStr], Field(description="Show only taggrams for one genre.")] = None, from_timestamp : Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Show only taggrams data starting from from this timestamp in seconds.")] = None, fill_with_zero : Annotated[Optional[StrictBool], Field(description="If set to true, empty timeseries are filled with timeseries of 0.0 values.")] = None, **kwargs) -> List[RecordingMinimalWithTaggramsDTO]:  # noqa: E501
        """Timeseries of AI generated moods, musical features and more for a list of recordings.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.recordings_by_ids_with_taggrams(ids, category_name, tag_name, genre_name, from_timestamp, fill_with_zero, async_req=True)
        >>> result = thread.get()

        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param category_name: Show only taggrams for one category.
        :type category_name: str
        :param tag_name: Show only taggrams for one tag.
        :type tag_name: str
        :param genre_name: Show only taggrams for one genre.
        :type genre_name: str
        :param from_timestamp: Show only taggrams data starting from from this timestamp in seconds.
        :type from_timestamp: float
        :param fill_with_zero: If set to true, empty timeseries are filled with timeseries of 0.0 values.
        :type fill_with_zero: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[RecordingMinimalWithTaggramsDTO]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the recordings_by_ids_with_taggrams_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.recordings_by_ids_with_taggrams_with_http_info(ids, category_name, tag_name, genre_name, from_timestamp, fill_with_zero, **kwargs)  # noqa: E501

    @validate_arguments
    def recordings_by_ids_with_taggrams_with_http_info(self, ids : Annotated[StrictStr, Field(..., description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")], category_name : Annotated[Optional[StrictStr], Field(description="Show only taggrams for one category.")] = None, tag_name : Annotated[Optional[StrictStr], Field(description="Show only taggrams for one tag.")] = None, genre_name : Annotated[Optional[StrictStr], Field(description="Show only taggrams for one genre.")] = None, from_timestamp : Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Show only taggrams data starting from from this timestamp in seconds.")] = None, fill_with_zero : Annotated[Optional[StrictBool], Field(description="If set to true, empty timeseries are filled with timeseries of 0.0 values.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Timeseries of AI generated moods, musical features and more for a list of recordings.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.recordings_by_ids_with_taggrams_with_http_info(ids, category_name, tag_name, genre_name, from_timestamp, fill_with_zero, async_req=True)
        >>> result = thread.get()

        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param category_name: Show only taggrams for one category.
        :type category_name: str
        :param tag_name: Show only taggrams for one tag.
        :type tag_name: str
        :param genre_name: Show only taggrams for one genre.
        :type genre_name: str
        :param from_timestamp: Show only taggrams data starting from from this timestamp in seconds.
        :type from_timestamp: float
        :param fill_with_zero: If set to true, empty timeseries are filled with timeseries of 0.0 values.
        :type fill_with_zero: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[RecordingMinimalWithTaggramsDTO], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'ids',
            'category_name',
            'tag_name',
            'genre_name',
            'from_timestamp',
            'fill_with_zero'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method recordings_by_ids_with_taggrams" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['ids']:
            _path_params['ids'] = _params['ids']


        # process the query parameters
        _query_params = []
        if _params.get('category_name') is not None:  # noqa: E501
            _query_params.append(('categoryName', _params['category_name']))

        if _params.get('tag_name') is not None:  # noqa: E501
            _query_params.append(('tagName', _params['tag_name']))

        if _params.get('genre_name') is not None:  # noqa: E501
            _query_params.append(('genreName', _params['genre_name']))

        if _params.get('from_timestamp') is not None:  # noqa: E501
            _query_params.append(('fromTimestamp', _params['from_timestamp']))

        if _params.get('fill_with_zero') is not None:  # noqa: E501
            _query_params.append(('fillWithZero', _params['fill_with_zero']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearer-jwt']  # noqa: E501

        _response_types_map = {
            '200': "List[RecordingMinimalWithTaggramsDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/api/v1/public/recording/{ids}/taggrams', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def recordings_by_ids_with_tagstrengths(self, ids : Annotated[StrictStr, Field(..., description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")], category_name : Annotated[Optional[StrictStr], Field(description="Show only taggrams for one category.")] = None, tag_name : Annotated[Optional[StrictStr], Field(description="Show only taggrams for one tag.")] = None, genre_name : Annotated[Optional[StrictStr], Field(description="Show only taggrams for one genre.")] = None, **kwargs) -> List[RecordingMinimalWithTagstrengthsDTO]:  # noqa: E501
        """Strengths as numerical representations for AI generated moods, musical features and more for recordings.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.recordings_by_ids_with_tagstrengths(ids, category_name, tag_name, genre_name, async_req=True)
        >>> result = thread.get()

        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param category_name: Show only taggrams for one category.
        :type category_name: str
        :param tag_name: Show only taggrams for one tag.
        :type tag_name: str
        :param genre_name: Show only taggrams for one genre.
        :type genre_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[RecordingMinimalWithTagstrengthsDTO]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the recordings_by_ids_with_tagstrengths_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.recordings_by_ids_with_tagstrengths_with_http_info(ids, category_name, tag_name, genre_name, **kwargs)  # noqa: E501

    @validate_arguments
    def recordings_by_ids_with_tagstrengths_with_http_info(self, ids : Annotated[StrictStr, Field(..., description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")], category_name : Annotated[Optional[StrictStr], Field(description="Show only taggrams for one category.")] = None, tag_name : Annotated[Optional[StrictStr], Field(description="Show only taggrams for one tag.")] = None, genre_name : Annotated[Optional[StrictStr], Field(description="Show only taggrams for one genre.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Strengths as numerical representations for AI generated moods, musical features and more for recordings.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.recordings_by_ids_with_tagstrengths_with_http_info(ids, category_name, tag_name, genre_name, async_req=True)
        >>> result = thread.get()

        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param category_name: Show only taggrams for one category.
        :type category_name: str
        :param tag_name: Show only taggrams for one tag.
        :type tag_name: str
        :param genre_name: Show only taggrams for one genre.
        :type genre_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[RecordingMinimalWithTagstrengthsDTO], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'ids',
            'category_name',
            'tag_name',
            'genre_name'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method recordings_by_ids_with_tagstrengths" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['ids']:
            _path_params['ids'] = _params['ids']


        # process the query parameters
        _query_params = []
        if _params.get('category_name') is not None:  # noqa: E501
            _query_params.append(('categoryName', _params['category_name']))

        if _params.get('tag_name') is not None:  # noqa: E501
            _query_params.append(('tagName', _params['tag_name']))

        if _params.get('genre_name') is not None:  # noqa: E501
            _query_params.append(('genreName', _params['genre_name']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearer-jwt']  # noqa: E501

        _response_types_map = {
            '200': "List[RecordingMinimalWithTagstrengthsDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/api/v1/public/recording/{ids}/tagstrengths', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def recordings_large_by_ids(self, ids : Annotated[StrictStr, Field(..., description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")], **kwargs) -> List[RecordingLargeDTO]:  # noqa: E501
        """Recordings by IDs with a large response.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.recordings_large_by_ids(ids, async_req=True)
        >>> result = thread.get()

        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[RecordingLargeDTO]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the recordings_large_by_ids_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.recordings_large_by_ids_with_http_info(ids, **kwargs)  # noqa: E501

    @validate_arguments
    def recordings_large_by_ids_with_http_info(self, ids : Annotated[StrictStr, Field(..., description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")], **kwargs) -> ApiResponse:  # noqa: E501
        """Recordings by IDs with a large response.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.recordings_large_by_ids_with_http_info(ids, async_req=True)
        >>> result = thread.get()

        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[RecordingLargeDTO], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'ids'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method recordings_large_by_ids" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['ids']:
            _path_params['ids'] = _params['ids']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearer-jwt']  # noqa: E501

        _response_types_map = {
            '200': "List[RecordingLargeDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/api/v1/public/recording/l/{ids}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def recordings_medium_by_ids(self, ids : Annotated[StrictStr, Field(..., description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")], page : Annotated[Optional[StrictInt], Field(description="Zero-based page index (0..N)")] = None, size : Annotated[Optional[StrictInt], Field(description="The size of the page to be returned")] = None, sort : Annotated[Optional[conlist(StrictStr)], Field(description="Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.")] = None, **kwargs) -> List[RecordingMediumDTO]:  # noqa: E501
        """Recordings by IDs with a medium sized response.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.recordings_medium_by_ids(ids, page, size, sort, async_req=True)
        >>> result = thread.get()

        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param sort: Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :type sort: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[RecordingMediumDTO]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the recordings_medium_by_ids_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.recordings_medium_by_ids_with_http_info(ids, page, size, sort, **kwargs)  # noqa: E501

    @validate_arguments
    def recordings_medium_by_ids_with_http_info(self, ids : Annotated[StrictStr, Field(..., description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")], page : Annotated[Optional[StrictInt], Field(description="Zero-based page index (0..N)")] = None, size : Annotated[Optional[StrictInt], Field(description="The size of the page to be returned")] = None, sort : Annotated[Optional[conlist(StrictStr)], Field(description="Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Recordings by IDs with a medium sized response.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.recordings_medium_by_ids_with_http_info(ids, page, size, sort, async_req=True)
        >>> result = thread.get()

        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param sort: Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :type sort: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[RecordingMediumDTO], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'ids',
            'page',
            'size',
            'sort'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method recordings_medium_by_ids" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['ids']:
            _path_params['ids'] = _params['ids']


        # process the query parameters
        _query_params = []
        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('size') is not None:  # noqa: E501
            _query_params.append(('size', _params['size']))

        if _params.get('sort') is not None:  # noqa: E501
            _query_params.append(('sort', _params['sort']))
            _collection_formats['sort'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearer-jwt']  # noqa: E501

        _response_types_map = {
            '200': "List[RecordingMediumDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/api/v1/public/recording/m/{ids}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def recordings_small_by_ids(self, ids : Annotated[StrictStr, Field(..., description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")], **kwargs) -> List[RecordingSmallDTO]:  # noqa: E501
        """Recordings by IDs with a small response.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.recordings_small_by_ids(ids, async_req=True)
        >>> result = thread.get()

        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: List[RecordingSmallDTO]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the recordings_small_by_ids_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.recordings_small_by_ids_with_http_info(ids, **kwargs)  # noqa: E501

    @validate_arguments
    def recordings_small_by_ids_with_http_info(self, ids : Annotated[StrictStr, Field(..., description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")], **kwargs) -> ApiResponse:  # noqa: E501
        """Recordings by IDs with a small response.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.recordings_small_by_ids_with_http_info(ids, async_req=True)
        >>> result = thread.get()

        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[RecordingSmallDTO], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'ids'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method recordings_small_by_ids" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['ids']:
            _path_params['ids'] = _params['ids']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearer-jwt']  # noqa: E501

        _response_types_map = {
            '200': "List[RecordingSmallDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/api/v1/public/recording/s/{ids}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def search_recordings(self, similar_to_recording : Annotated[Optional[StrictStr], Field(description="Search for songs similar to a recording.")] = None, contributor : Annotated[Optional[StrictStr], Field(description="Search for a name that was involved as any contributor.")] = None, main_artist : Annotated[Optional[StrictStr], Field(description="Search for a main artist.")] = None, composer : Annotated[Optional[StrictStr], Field(description="Search for a composer.")] = None, title : Annotated[Optional[StrictStr], Field(description="Search for a title.")] = None, party_and_title : Annotated[Optional[StrictStr], Field(description="Search for party and title.")] = None, language : Annotated[Optional[StrictStr], Field(description="Search for a language of the lyrics.")] = None, genre : Annotated[Optional[StrictStr], Field(description="Search for a genre.")] = None, primary_mood_cluster : Annotated[Optional[StrictStr], Field(description="Search for a mood.")] = None, valence : Annotated[Optional[StrictStr], Field(description="Search for valence.")] = None, arousal : Annotated[Optional[StrictStr], Field(description="Search for arousal.")] = None, pleasantness : Annotated[Optional[StrictStr], Field(description="Search for pleasantness.")] = None, engagement : Annotated[Optional[StrictStr], Field(description="Search for an engagement.")] = None, vocals : Annotated[Optional[StrictStr], Field(description="Search for a vocals gender or instrumental songs.")] = None, dominant_instrument : Annotated[Optional[StrictStr], Field(description="Search for a dominant instrument.")] = None, energy : Annotated[Optional[StrictStr], Field(description="Search for energy.")] = None, sound_generation : Annotated[Optional[StrictStr], Field(description="Search for type of sound generation.")] = None, tempo : Annotated[Optional[StrictStr], Field(description="Search for tempo.")] = None, scale : Annotated[Optional[StrictStr], Field(description="Search for tonal scale.")] = None, key : Annotated[Optional[StrictStr], Field(description="Search for harmonic key.")] = None, rhythm : Annotated[Optional[StrictStr], Field(description="Search for rhythm.")] = None, primary_sound_character : Annotated[Optional[StrictStr], Field(description="Search for a sound character.")] = None, timbre : Annotated[Optional[StrictStr], Field(description="Search for timbre.")] = None, roughness : Annotated[Optional[StrictStr], Field(description="Search for roughness.")] = None, tonality : Annotated[Optional[StrictStr], Field(description="Search for tonality.")] = None, harmony : Annotated[Optional[StrictStr], Field(description="Search for a degree of harmoniousness.")] = None, texture : Annotated[Optional[StrictStr], Field(description="Search for texture.")] = None, groovyness : Annotated[Optional[StrictStr], Field(description="Search for groovyness.")] = None, space : Annotated[Optional[StrictStr], Field(description="Search for space.")] = None, origin_decade : Annotated[Optional[StrictStr], Field(description="Search for origin decade.")] = None, curateability : Annotated[Optional[StrictStr], Field(description="Search for curateability.")] = None, use_case : Annotated[Optional[StrictStr], Field(description="Search for use case.")] = None, channel_suitability : Annotated[Optional[StrictStr], Field(description="Search for channel suitability.")] = None, songtradr_track_id : Annotated[Optional[StrictStr], Field(description="Search for Songtradr track id.")] = None, usage : Annotated[Optional[StrictStr], Field(description="Search for recording usage.")] = None, similar_to_songtradr_track_id : Annotated[Optional[StrictStr], Field(description="Search for songs similar to a recording by songtradr Track Id.")] = None, shuffled : Annotated[Optional[StrictStr], Field(description="Sort the results randomly.")] = None, sort : Annotated[Optional[StrictStr], Field(description="Sort the results.")] = None, page : Annotated[Optional[StrictInt], Field(description="Zero-based page index (0..N)")] = None, size : Annotated[Optional[StrictInt], Field(description="The size of the page to be returned")] = None, **kwargs) -> RecordingListDTO:  # noqa: E501
        """Recordings by contributors, moods, musical features and more.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_recordings(similar_to_recording, contributor, main_artist, composer, title, party_and_title, language, genre, primary_mood_cluster, valence, arousal, pleasantness, engagement, vocals, dominant_instrument, energy, sound_generation, tempo, scale, key, rhythm, primary_sound_character, timbre, roughness, tonality, harmony, texture, groovyness, space, origin_decade, curateability, use_case, channel_suitability, songtradr_track_id, usage, similar_to_songtradr_track_id, shuffled, sort, page, size, async_req=True)
        >>> result = thread.get()

        :param similar_to_recording: Search for songs similar to a recording.
        :type similar_to_recording: str
        :param contributor: Search for a name that was involved as any contributor.
        :type contributor: str
        :param main_artist: Search for a main artist.
        :type main_artist: str
        :param composer: Search for a composer.
        :type composer: str
        :param title: Search for a title.
        :type title: str
        :param party_and_title: Search for party and title.
        :type party_and_title: str
        :param language: Search for a language of the lyrics.
        :type language: str
        :param genre: Search for a genre.
        :type genre: str
        :param primary_mood_cluster: Search for a mood.
        :type primary_mood_cluster: str
        :param valence: Search for valence.
        :type valence: str
        :param arousal: Search for arousal.
        :type arousal: str
        :param pleasantness: Search for pleasantness.
        :type pleasantness: str
        :param engagement: Search for an engagement.
        :type engagement: str
        :param vocals: Search for a vocals gender or instrumental songs.
        :type vocals: str
        :param dominant_instrument: Search for a dominant instrument.
        :type dominant_instrument: str
        :param energy: Search for energy.
        :type energy: str
        :param sound_generation: Search for type of sound generation.
        :type sound_generation: str
        :param tempo: Search for tempo.
        :type tempo: str
        :param scale: Search for tonal scale.
        :type scale: str
        :param key: Search for harmonic key.
        :type key: str
        :param rhythm: Search for rhythm.
        :type rhythm: str
        :param primary_sound_character: Search for a sound character.
        :type primary_sound_character: str
        :param timbre: Search for timbre.
        :type timbre: str
        :param roughness: Search for roughness.
        :type roughness: str
        :param tonality: Search for tonality.
        :type tonality: str
        :param harmony: Search for a degree of harmoniousness.
        :type harmony: str
        :param texture: Search for texture.
        :type texture: str
        :param groovyness: Search for groovyness.
        :type groovyness: str
        :param space: Search for space.
        :type space: str
        :param origin_decade: Search for origin decade.
        :type origin_decade: str
        :param curateability: Search for curateability.
        :type curateability: str
        :param use_case: Search for use case.
        :type use_case: str
        :param channel_suitability: Search for channel suitability.
        :type channel_suitability: str
        :param songtradr_track_id: Search for Songtradr track id.
        :type songtradr_track_id: str
        :param usage: Search for recording usage.
        :type usage: str
        :param similar_to_songtradr_track_id: Search for songs similar to a recording by songtradr Track Id.
        :type similar_to_songtradr_track_id: str
        :param shuffled: Sort the results randomly.
        :type shuffled: str
        :param sort: Sort the results.
        :type sort: str
        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RecordingListDTO
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the search_recordings_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.search_recordings_with_http_info(similar_to_recording, contributor, main_artist, composer, title, party_and_title, language, genre, primary_mood_cluster, valence, arousal, pleasantness, engagement, vocals, dominant_instrument, energy, sound_generation, tempo, scale, key, rhythm, primary_sound_character, timbre, roughness, tonality, harmony, texture, groovyness, space, origin_decade, curateability, use_case, channel_suitability, songtradr_track_id, usage, similar_to_songtradr_track_id, shuffled, sort, page, size, **kwargs)  # noqa: E501

    @validate_arguments
    def search_recordings_with_http_info(self, similar_to_recording : Annotated[Optional[StrictStr], Field(description="Search for songs similar to a recording.")] = None, contributor : Annotated[Optional[StrictStr], Field(description="Search for a name that was involved as any contributor.")] = None, main_artist : Annotated[Optional[StrictStr], Field(description="Search for a main artist.")] = None, composer : Annotated[Optional[StrictStr], Field(description="Search for a composer.")] = None, title : Annotated[Optional[StrictStr], Field(description="Search for a title.")] = None, party_and_title : Annotated[Optional[StrictStr], Field(description="Search for party and title.")] = None, language : Annotated[Optional[StrictStr], Field(description="Search for a language of the lyrics.")] = None, genre : Annotated[Optional[StrictStr], Field(description="Search for a genre.")] = None, primary_mood_cluster : Annotated[Optional[StrictStr], Field(description="Search for a mood.")] = None, valence : Annotated[Optional[StrictStr], Field(description="Search for valence.")] = None, arousal : Annotated[Optional[StrictStr], Field(description="Search for arousal.")] = None, pleasantness : Annotated[Optional[StrictStr], Field(description="Search for pleasantness.")] = None, engagement : Annotated[Optional[StrictStr], Field(description="Search for an engagement.")] = None, vocals : Annotated[Optional[StrictStr], Field(description="Search for a vocals gender or instrumental songs.")] = None, dominant_instrument : Annotated[Optional[StrictStr], Field(description="Search for a dominant instrument.")] = None, energy : Annotated[Optional[StrictStr], Field(description="Search for energy.")] = None, sound_generation : Annotated[Optional[StrictStr], Field(description="Search for type of sound generation.")] = None, tempo : Annotated[Optional[StrictStr], Field(description="Search for tempo.")] = None, scale : Annotated[Optional[StrictStr], Field(description="Search for tonal scale.")] = None, key : Annotated[Optional[StrictStr], Field(description="Search for harmonic key.")] = None, rhythm : Annotated[Optional[StrictStr], Field(description="Search for rhythm.")] = None, primary_sound_character : Annotated[Optional[StrictStr], Field(description="Search for a sound character.")] = None, timbre : Annotated[Optional[StrictStr], Field(description="Search for timbre.")] = None, roughness : Annotated[Optional[StrictStr], Field(description="Search for roughness.")] = None, tonality : Annotated[Optional[StrictStr], Field(description="Search for tonality.")] = None, harmony : Annotated[Optional[StrictStr], Field(description="Search for a degree of harmoniousness.")] = None, texture : Annotated[Optional[StrictStr], Field(description="Search for texture.")] = None, groovyness : Annotated[Optional[StrictStr], Field(description="Search for groovyness.")] = None, space : Annotated[Optional[StrictStr], Field(description="Search for space.")] = None, origin_decade : Annotated[Optional[StrictStr], Field(description="Search for origin decade.")] = None, curateability : Annotated[Optional[StrictStr], Field(description="Search for curateability.")] = None, use_case : Annotated[Optional[StrictStr], Field(description="Search for use case.")] = None, channel_suitability : Annotated[Optional[StrictStr], Field(description="Search for channel suitability.")] = None, songtradr_track_id : Annotated[Optional[StrictStr], Field(description="Search for Songtradr track id.")] = None, usage : Annotated[Optional[StrictStr], Field(description="Search for recording usage.")] = None, similar_to_songtradr_track_id : Annotated[Optional[StrictStr], Field(description="Search for songs similar to a recording by songtradr Track Id.")] = None, shuffled : Annotated[Optional[StrictStr], Field(description="Sort the results randomly.")] = None, sort : Annotated[Optional[StrictStr], Field(description="Sort the results.")] = None, page : Annotated[Optional[StrictInt], Field(description="Zero-based page index (0..N)")] = None, size : Annotated[Optional[StrictInt], Field(description="The size of the page to be returned")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Recordings by contributors, moods, musical features and more.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_recordings_with_http_info(similar_to_recording, contributor, main_artist, composer, title, party_and_title, language, genre, primary_mood_cluster, valence, arousal, pleasantness, engagement, vocals, dominant_instrument, energy, sound_generation, tempo, scale, key, rhythm, primary_sound_character, timbre, roughness, tonality, harmony, texture, groovyness, space, origin_decade, curateability, use_case, channel_suitability, songtradr_track_id, usage, similar_to_songtradr_track_id, shuffled, sort, page, size, async_req=True)
        >>> result = thread.get()

        :param similar_to_recording: Search for songs similar to a recording.
        :type similar_to_recording: str
        :param contributor: Search for a name that was involved as any contributor.
        :type contributor: str
        :param main_artist: Search for a main artist.
        :type main_artist: str
        :param composer: Search for a composer.
        :type composer: str
        :param title: Search for a title.
        :type title: str
        :param party_and_title: Search for party and title.
        :type party_and_title: str
        :param language: Search for a language of the lyrics.
        :type language: str
        :param genre: Search for a genre.
        :type genre: str
        :param primary_mood_cluster: Search for a mood.
        :type primary_mood_cluster: str
        :param valence: Search for valence.
        :type valence: str
        :param arousal: Search for arousal.
        :type arousal: str
        :param pleasantness: Search for pleasantness.
        :type pleasantness: str
        :param engagement: Search for an engagement.
        :type engagement: str
        :param vocals: Search for a vocals gender or instrumental songs.
        :type vocals: str
        :param dominant_instrument: Search for a dominant instrument.
        :type dominant_instrument: str
        :param energy: Search for energy.
        :type energy: str
        :param sound_generation: Search for type of sound generation.
        :type sound_generation: str
        :param tempo: Search for tempo.
        :type tempo: str
        :param scale: Search for tonal scale.
        :type scale: str
        :param key: Search for harmonic key.
        :type key: str
        :param rhythm: Search for rhythm.
        :type rhythm: str
        :param primary_sound_character: Search for a sound character.
        :type primary_sound_character: str
        :param timbre: Search for timbre.
        :type timbre: str
        :param roughness: Search for roughness.
        :type roughness: str
        :param tonality: Search for tonality.
        :type tonality: str
        :param harmony: Search for a degree of harmoniousness.
        :type harmony: str
        :param texture: Search for texture.
        :type texture: str
        :param groovyness: Search for groovyness.
        :type groovyness: str
        :param space: Search for space.
        :type space: str
        :param origin_decade: Search for origin decade.
        :type origin_decade: str
        :param curateability: Search for curateability.
        :type curateability: str
        :param use_case: Search for use case.
        :type use_case: str
        :param channel_suitability: Search for channel suitability.
        :type channel_suitability: str
        :param songtradr_track_id: Search for Songtradr track id.
        :type songtradr_track_id: str
        :param usage: Search for recording usage.
        :type usage: str
        :param similar_to_songtradr_track_id: Search for songs similar to a recording by songtradr Track Id.
        :type similar_to_songtradr_track_id: str
        :param shuffled: Sort the results randomly.
        :type shuffled: str
        :param sort: Sort the results.
        :type sort: str
        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RecordingListDTO, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'similar_to_recording',
            'contributor',
            'main_artist',
            'composer',
            'title',
            'party_and_title',
            'language',
            'genre',
            'primary_mood_cluster',
            'valence',
            'arousal',
            'pleasantness',
            'engagement',
            'vocals',
            'dominant_instrument',
            'energy',
            'sound_generation',
            'tempo',
            'scale',
            'key',
            'rhythm',
            'primary_sound_character',
            'timbre',
            'roughness',
            'tonality',
            'harmony',
            'texture',
            'groovyness',
            'space',
            'origin_decade',
            'curateability',
            'use_case',
            'channel_suitability',
            'songtradr_track_id',
            'usage',
            'similar_to_songtradr_track_id',
            'shuffled',
            'sort',
            'page',
            'size'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_recordings" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('similar_to_recording') is not None:  # noqa: E501
            _query_params.append(('similarToRecording', _params['similar_to_recording']))

        if _params.get('contributor') is not None:  # noqa: E501
            _query_params.append(('contributor', _params['contributor']))

        if _params.get('main_artist') is not None:  # noqa: E501
            _query_params.append(('mainArtist', _params['main_artist']))

        if _params.get('composer') is not None:  # noqa: E501
            _query_params.append(('composer', _params['composer']))

        if _params.get('title') is not None:  # noqa: E501
            _query_params.append(('title', _params['title']))

        if _params.get('party_and_title') is not None:  # noqa: E501
            _query_params.append(('partyAndTitle', _params['party_and_title']))

        if _params.get('language') is not None:  # noqa: E501
            _query_params.append(('language', _params['language']))

        if _params.get('genre') is not None:  # noqa: E501
            _query_params.append(('genre', _params['genre']))

        if _params.get('primary_mood_cluster') is not None:  # noqa: E501
            _query_params.append(('primaryMoodCluster', _params['primary_mood_cluster']))

        if _params.get('valence') is not None:  # noqa: E501
            _query_params.append(('valence', _params['valence']))

        if _params.get('arousal') is not None:  # noqa: E501
            _query_params.append(('arousal', _params['arousal']))

        if _params.get('pleasantness') is not None:  # noqa: E501
            _query_params.append(('pleasantness', _params['pleasantness']))

        if _params.get('engagement') is not None:  # noqa: E501
            _query_params.append(('engagement', _params['engagement']))

        if _params.get('vocals') is not None:  # noqa: E501
            _query_params.append(('vocals', _params['vocals']))

        if _params.get('dominant_instrument') is not None:  # noqa: E501
            _query_params.append(('dominantInstrument', _params['dominant_instrument']))

        if _params.get('energy') is not None:  # noqa: E501
            _query_params.append(('energy', _params['energy']))

        if _params.get('sound_generation') is not None:  # noqa: E501
            _query_params.append(('soundGeneration', _params['sound_generation']))

        if _params.get('tempo') is not None:  # noqa: E501
            _query_params.append(('tempo', _params['tempo']))

        if _params.get('scale') is not None:  # noqa: E501
            _query_params.append(('scale', _params['scale']))

        if _params.get('key') is not None:  # noqa: E501
            _query_params.append(('key', _params['key']))

        if _params.get('rhythm') is not None:  # noqa: E501
            _query_params.append(('rhythm', _params['rhythm']))

        if _params.get('primary_sound_character') is not None:  # noqa: E501
            _query_params.append(('primarySoundCharacter', _params['primary_sound_character']))

        if _params.get('timbre') is not None:  # noqa: E501
            _query_params.append(('timbre', _params['timbre']))

        if _params.get('roughness') is not None:  # noqa: E501
            _query_params.append(('roughness', _params['roughness']))

        if _params.get('tonality') is not None:  # noqa: E501
            _query_params.append(('tonality', _params['tonality']))

        if _params.get('harmony') is not None:  # noqa: E501
            _query_params.append(('harmony', _params['harmony']))

        if _params.get('texture') is not None:  # noqa: E501
            _query_params.append(('texture', _params['texture']))

        if _params.get('groovyness') is not None:  # noqa: E501
            _query_params.append(('groovyness', _params['groovyness']))

        if _params.get('space') is not None:  # noqa: E501
            _query_params.append(('space', _params['space']))

        if _params.get('origin_decade') is not None:  # noqa: E501
            _query_params.append(('originDecade', _params['origin_decade']))

        if _params.get('curateability') is not None:  # noqa: E501
            _query_params.append(('curateability', _params['curateability']))

        if _params.get('use_case') is not None:  # noqa: E501
            _query_params.append(('useCase', _params['use_case']))

        if _params.get('channel_suitability') is not None:  # noqa: E501
            _query_params.append(('channelSuitability', _params['channel_suitability']))

        if _params.get('songtradr_track_id') is not None:  # noqa: E501
            _query_params.append(('songtradrTrackId', _params['songtradr_track_id']))

        if _params.get('usage') is not None:  # noqa: E501
            _query_params.append(('usage', _params['usage']))

        if _params.get('similar_to_songtradr_track_id') is not None:  # noqa: E501
            _query_params.append(('similarToSongtradrTrackId', _params['similar_to_songtradr_track_id']))

        if _params.get('shuffled') is not None:  # noqa: E501
            _query_params.append(('shuffled', _params['shuffled']))

        if _params.get('sort') is not None:  # noqa: E501
            _query_params.append(('sort', _params['sort']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('size') is not None:  # noqa: E501
            _query_params.append(('size', _params['size']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearer-jwt']  # noqa: E501

        _response_types_map = {
            '200': "RecordingListDTO",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/api/v1/public/recording/search', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def search_recordings_granular(self, search_recording_granular_dto : conlist(SearchRecordingGranularDTO), **kwargs) -> RecordingListDTO:  # noqa: E501
        """Recordings by granular search options.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_recordings_granular(search_recording_granular_dto, async_req=True)
        >>> result = thread.get()

        :param search_recording_granular_dto: (required)
        :type search_recording_granular_dto: List[SearchRecordingGranularDTO]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RecordingListDTO
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the search_recordings_granular_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.search_recordings_granular_with_http_info(search_recording_granular_dto, **kwargs)  # noqa: E501

    @validate_arguments
    def search_recordings_granular_with_http_info(self, search_recording_granular_dto : conlist(SearchRecordingGranularDTO), **kwargs) -> ApiResponse:  # noqa: E501
        """Recordings by granular search options.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_recordings_granular_with_http_info(search_recording_granular_dto, async_req=True)
        >>> result = thread.get()

        :param search_recording_granular_dto: (required)
        :type search_recording_granular_dto: List[SearchRecordingGranularDTO]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RecordingListDTO, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'search_recording_granular_dto'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_recordings_granular" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['search_recording_granular_dto'] is not None:
            _body_params = _params['search_recording_granular_dto']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearer-jwt']  # noqa: E501

        _response_types_map = {
            '200': "RecordingListDTO",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/api/v1/public/recording/searchGranular', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def search_recordings_granular_abstraction(self, search_recording_granular_abstraction_dto : conlist(SearchRecordingGranularAbstractionDTO), **kwargs) -> RecordingListDTO:  # noqa: E501
        """Recordings by abstracted wordings and granular search options.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_recordings_granular_abstraction(search_recording_granular_abstraction_dto, async_req=True)
        >>> result = thread.get()

        :param search_recording_granular_abstraction_dto: (required)
        :type search_recording_granular_abstraction_dto: List[SearchRecordingGranularAbstractionDTO]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RecordingListDTO
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the search_recordings_granular_abstraction_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.search_recordings_granular_abstraction_with_http_info(search_recording_granular_abstraction_dto, **kwargs)  # noqa: E501

    @validate_arguments
    def search_recordings_granular_abstraction_with_http_info(self, search_recording_granular_abstraction_dto : conlist(SearchRecordingGranularAbstractionDTO), **kwargs) -> ApiResponse:  # noqa: E501
        """Recordings by abstracted wordings and granular search options.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_recordings_granular_abstraction_with_http_info(search_recording_granular_abstraction_dto, async_req=True)
        >>> result = thread.get()

        :param search_recording_granular_abstraction_dto: (required)
        :type search_recording_granular_abstraction_dto: List[SearchRecordingGranularAbstractionDTO]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RecordingListDTO, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'search_recording_granular_abstraction_dto'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_recordings_granular_abstraction" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['search_recording_granular_abstraction_dto'] is not None:
            _body_params = _params['search_recording_granular_abstraction_dto']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearer-jwt']  # noqa: E501

        _response_types_map = {
            '200': "RecordingListDTO",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '400': "ErrorResponse",
        }

        return self.api_client.call_api(
            '/api/v1/public/recording/searchGranularAbstraction', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
