# coding: utf-8

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.

    The version of the OpenAPI document: 1.13.2
    Contact: info@songtradr.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, StrictStr, conlist

class SearchFilterValuesDTO(BaseModel):
    """
    Categories of musical features that can be used as search filters.
    """
    primary_mood_cluster: conlist(StrictStr) = Field(..., alias="primaryMoodCluster")
    secondary_mood_cluster: conlist(StrictStr) = Field(..., alias="secondaryMoodCluster")
    tertiary_mood_cluster: conlist(StrictStr) = Field(..., alias="tertiaryMoodCluster")
    valence: conlist(StrictStr) = Field(...)
    arousal: conlist(StrictStr) = Field(...)
    pleasantness: conlist(StrictStr) = Field(...)
    engagement: conlist(StrictStr) = Field(...)
    vocals: conlist(StrictStr) = Field(...)
    dominant_instrument: conlist(StrictStr) = Field(..., alias="dominantInstrument")
    secondary_instrument: conlist(StrictStr) = Field(..., alias="secondaryInstrument")
    tertiary_instrument: conlist(StrictStr) = Field(..., alias="tertiaryInstrument")
    energy: conlist(StrictStr) = Field(...)
    sound_generation: conlist(StrictStr) = Field(..., alias="soundGeneration")
    tempo: conlist(StrictStr) = Field(...)
    scale: conlist(StrictStr) = Field(...)
    key: conlist(StrictStr) = Field(...)
    rhythm: conlist(StrictStr) = Field(...)
    primary_sound_character: conlist(StrictStr) = Field(..., alias="primarySoundCharacter")
    timbre: conlist(StrictStr) = Field(...)
    roughness: conlist(StrictStr) = Field(...)
    tonality: conlist(StrictStr) = Field(...)
    harmony: conlist(StrictStr) = Field(...)
    texture: conlist(StrictStr) = Field(...)
    groovyness: conlist(StrictStr) = Field(...)
    space: conlist(StrictStr) = Field(...)
    production_rating: conlist(StrictStr) = Field(..., alias="productionRating")
    performance_rating: conlist(StrictStr) = Field(..., alias="performanceRating")
    song_rating: conlist(StrictStr) = Field(..., alias="songRating")
    audience_age: conlist(StrictStr) = Field(..., alias="audienceAge")
    secondary_audience_age: conlist(StrictStr) = Field(..., alias="secondaryAudienceAge")
    tertiary_audience_age: conlist(StrictStr) = Field(..., alias="tertiaryAudienceAge")
    audience_gender: conlist(StrictStr) = Field(..., alias="audienceGender")
    audience_region: conlist(StrictStr) = Field(..., alias="audienceRegion")
    secondary_audience_region: conlist(StrictStr) = Field(..., alias="secondaryAudienceRegion")
    tertiary_audience_region: conlist(StrictStr) = Field(..., alias="tertiaryAudienceRegion")
    origin_decade: conlist(StrictStr) = Field(..., alias="originDecade")
    origin_region: conlist(StrictStr) = Field(..., alias="originRegion")
    language_of_performance: conlist(StrictStr) = Field(..., alias="languageOfPerformance")
    curateability: conlist(StrictStr) = Field(...)
    use_case: conlist(StrictStr) = Field(..., alias="useCase")
    channel_suitability: conlist(StrictStr) = Field(..., alias="channelSuitability")
    __properties = ["primaryMoodCluster", "secondaryMoodCluster", "tertiaryMoodCluster", "valence", "arousal", "pleasantness", "engagement", "vocals", "dominantInstrument", "secondaryInstrument", "tertiaryInstrument", "energy", "soundGeneration", "tempo", "scale", "key", "rhythm", "primarySoundCharacter", "timbre", "roughness", "tonality", "harmony", "texture", "groovyness", "space", "productionRating", "performanceRating", "songRating", "audienceAge", "secondaryAudienceAge", "tertiaryAudienceAge", "audienceGender", "audienceRegion", "secondaryAudienceRegion", "tertiaryAudienceRegion", "originDecade", "originRegion", "languageOfPerformance", "curateability", "useCase", "channelSuitability"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SearchFilterValuesDTO:
        """Create an instance of SearchFilterValuesDTO from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SearchFilterValuesDTO:
        """Create an instance of SearchFilterValuesDTO from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SearchFilterValuesDTO.parse_obj(obj)

        _obj = SearchFilterValuesDTO.parse_obj({
            "primary_mood_cluster": obj.get("primaryMoodCluster"),
            "secondary_mood_cluster": obj.get("secondaryMoodCluster"),
            "tertiary_mood_cluster": obj.get("tertiaryMoodCluster"),
            "valence": obj.get("valence"),
            "arousal": obj.get("arousal"),
            "pleasantness": obj.get("pleasantness"),
            "engagement": obj.get("engagement"),
            "vocals": obj.get("vocals"),
            "dominant_instrument": obj.get("dominantInstrument"),
            "secondary_instrument": obj.get("secondaryInstrument"),
            "tertiary_instrument": obj.get("tertiaryInstrument"),
            "energy": obj.get("energy"),
            "sound_generation": obj.get("soundGeneration"),
            "tempo": obj.get("tempo"),
            "scale": obj.get("scale"),
            "key": obj.get("key"),
            "rhythm": obj.get("rhythm"),
            "primary_sound_character": obj.get("primarySoundCharacter"),
            "timbre": obj.get("timbre"),
            "roughness": obj.get("roughness"),
            "tonality": obj.get("tonality"),
            "harmony": obj.get("harmony"),
            "texture": obj.get("texture"),
            "groovyness": obj.get("groovyness"),
            "space": obj.get("space"),
            "production_rating": obj.get("productionRating"),
            "performance_rating": obj.get("performanceRating"),
            "song_rating": obj.get("songRating"),
            "audience_age": obj.get("audienceAge"),
            "secondary_audience_age": obj.get("secondaryAudienceAge"),
            "tertiary_audience_age": obj.get("tertiaryAudienceAge"),
            "audience_gender": obj.get("audienceGender"),
            "audience_region": obj.get("audienceRegion"),
            "secondary_audience_region": obj.get("secondaryAudienceRegion"),
            "tertiary_audience_region": obj.get("tertiaryAudienceRegion"),
            "origin_decade": obj.get("originDecade"),
            "origin_region": obj.get("originRegion"),
            "language_of_performance": obj.get("languageOfPerformance"),
            "curateability": obj.get("curateability"),
            "use_case": obj.get("useCase"),
            "channel_suitability": obj.get("channelSuitability")
        })
        return _obj


