# coding: utf-8

"""
    Zarban API

    API for Zarban services.  # noqa: E501

    The version of the OpenAPI document: 2.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from zarban.service.openapi_client.api_client import ApiClient
from zarban.service.openapi_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class StableCoinSystemApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def v2_ilks_get(self, **kwargs):  # noqa: E501
        """Get all Ilks  # noqa: E501

        Retrieve a list of all available ilks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_ilks_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Ilk]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v2_ilks_get_with_http_info(**kwargs)  # noqa: E501

    def v2_ilks_get_with_http_info(self, **kwargs):  # noqa: E501
        """Get all Ilks  # noqa: E501

        Retrieve a list of all available ilks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_ilks_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Ilk], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_ilks_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v2/ilks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Ilk]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_ilks_name_get(self, name, **kwargs):  # noqa: E501
        """Get Ilk by name  # noqa: E501

        Retrieve an Ilk by providing its name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_ilks_name_get(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Name of the ILK (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Ilk
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v2_ilks_name_get_with_http_info(name, **kwargs)  # noqa: E501

    def v2_ilks_name_get_with_http_info(self, name, **kwargs):  # noqa: E501
        """Get Ilk by name  # noqa: E501

        Retrieve an Ilk by providing its name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_ilks_name_get_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str name: Name of the ILK (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Ilk, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_ilks_name_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `v2_ilks_name_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v2/ilks/{name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Ilk',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_stablecoinsystem_auctions_tx_gemexit_post(self, stablecoin_system_gemexit_tx_request, **kwargs):  # noqa: E501
        """exit Gem token (which can be used as collateral) from Vat contract  # noqa: E501

        exit Gem token (which can be used as collateral) from Vat contract  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_stablecoinsystem_auctions_tx_gemexit_post(stablecoin_system_gemexit_tx_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param StablecoinSystemGemexitTxRequest stablecoin_system_gemexit_tx_request: exit Zar token from Vat contract transaction request (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ChainActivity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v2_stablecoinsystem_auctions_tx_gemexit_post_with_http_info(stablecoin_system_gemexit_tx_request, **kwargs)  # noqa: E501

    def v2_stablecoinsystem_auctions_tx_gemexit_post_with_http_info(self, stablecoin_system_gemexit_tx_request, **kwargs):  # noqa: E501
        """exit Gem token (which can be used as collateral) from Vat contract  # noqa: E501

        exit Gem token (which can be used as collateral) from Vat contract  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_stablecoinsystem_auctions_tx_gemexit_post_with_http_info(stablecoin_system_gemexit_tx_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param StablecoinSystemGemexitTxRequest stablecoin_system_gemexit_tx_request: exit Zar token from Vat contract transaction request (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ChainActivity, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'stablecoin_system_gemexit_tx_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_stablecoinsystem_auctions_tx_gemexit_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'stablecoin_system_gemexit_tx_request' is set
        if self.api_client.client_side_validation and ('stablecoin_system_gemexit_tx_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['stablecoin_system_gemexit_tx_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `stablecoin_system_gemexit_tx_request` when calling `v2_stablecoinsystem_auctions_tx_gemexit_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'stablecoin_system_gemexit_tx_request' in local_var_params:
            body_params = local_var_params['stablecoin_system_gemexit_tx_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v2/stablecoinsystem/auctions/tx/gemexit', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ChainActivity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_stablecoinsystem_auctions_tx_redo_post(self, stablecoin_system_redo_tx_request, **kwargs):  # noqa: E501
        """reset a auction  # noqa: E501

        reset a auction  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_stablecoinsystem_auctions_tx_redo_post(stablecoin_system_redo_tx_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param StablecoinSystemRedoTxRequest stablecoin_system_redo_tx_request: Reset a Auction transaction request (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ChainActivity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v2_stablecoinsystem_auctions_tx_redo_post_with_http_info(stablecoin_system_redo_tx_request, **kwargs)  # noqa: E501

    def v2_stablecoinsystem_auctions_tx_redo_post_with_http_info(self, stablecoin_system_redo_tx_request, **kwargs):  # noqa: E501
        """reset a auction  # noqa: E501

        reset a auction  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_stablecoinsystem_auctions_tx_redo_post_with_http_info(stablecoin_system_redo_tx_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param StablecoinSystemRedoTxRequest stablecoin_system_redo_tx_request: Reset a Auction transaction request (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ChainActivity, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'stablecoin_system_redo_tx_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_stablecoinsystem_auctions_tx_redo_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'stablecoin_system_redo_tx_request' is set
        if self.api_client.client_side_validation and ('stablecoin_system_redo_tx_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['stablecoin_system_redo_tx_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `stablecoin_system_redo_tx_request` when calling `v2_stablecoinsystem_auctions_tx_redo_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'stablecoin_system_redo_tx_request' in local_var_params:
            body_params = local_var_params['stablecoin_system_redo_tx_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v2/stablecoinsystem/auctions/tx/redo', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ChainActivity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_stablecoinsystem_auctions_tx_take_post(self, stablecoin_system_take_tx_request, **kwargs):  # noqa: E501
        """take a auction  # noqa: E501

        take a auction  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_stablecoinsystem_auctions_tx_take_post(stablecoin_system_take_tx_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param StablecoinSystemTakeTxRequest stablecoin_system_take_tx_request: Take a Auction transaction request (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ChainActivity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v2_stablecoinsystem_auctions_tx_take_post_with_http_info(stablecoin_system_take_tx_request, **kwargs)  # noqa: E501

    def v2_stablecoinsystem_auctions_tx_take_post_with_http_info(self, stablecoin_system_take_tx_request, **kwargs):  # noqa: E501
        """take a auction  # noqa: E501

        take a auction  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_stablecoinsystem_auctions_tx_take_post_with_http_info(stablecoin_system_take_tx_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param StablecoinSystemTakeTxRequest stablecoin_system_take_tx_request: Take a Auction transaction request (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ChainActivity, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'stablecoin_system_take_tx_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_stablecoinsystem_auctions_tx_take_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'stablecoin_system_take_tx_request' is set
        if self.api_client.client_side_validation and ('stablecoin_system_take_tx_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['stablecoin_system_take_tx_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `stablecoin_system_take_tx_request` when calling `v2_stablecoinsystem_auctions_tx_take_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'stablecoin_system_take_tx_request' in local_var_params:
            body_params = local_var_params['stablecoin_system_take_tx_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v2/stablecoinsystem/auctions/tx/take', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ChainActivity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_stablecoinsystem_auctions_tx_zarexit_post(self, stablecoin_system_zarexit_tx_request, **kwargs):  # noqa: E501
        """exit ZAR token from Vat contract  # noqa: E501

        exit ZAR token from Vat contract  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_stablecoinsystem_auctions_tx_zarexit_post(stablecoin_system_zarexit_tx_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param StablecoinSystemZarexitTxRequest stablecoin_system_zarexit_tx_request: exit Zar token from Vat contract transaction request (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ChainActivity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v2_stablecoinsystem_auctions_tx_zarexit_post_with_http_info(stablecoin_system_zarexit_tx_request, **kwargs)  # noqa: E501

    def v2_stablecoinsystem_auctions_tx_zarexit_post_with_http_info(self, stablecoin_system_zarexit_tx_request, **kwargs):  # noqa: E501
        """exit ZAR token from Vat contract  # noqa: E501

        exit ZAR token from Vat contract  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_stablecoinsystem_auctions_tx_zarexit_post_with_http_info(stablecoin_system_zarexit_tx_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param StablecoinSystemZarexitTxRequest stablecoin_system_zarexit_tx_request: exit Zar token from Vat contract transaction request (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ChainActivity, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'stablecoin_system_zarexit_tx_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_stablecoinsystem_auctions_tx_zarexit_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'stablecoin_system_zarexit_tx_request' is set
        if self.api_client.client_side_validation and ('stablecoin_system_zarexit_tx_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['stablecoin_system_zarexit_tx_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `stablecoin_system_zarexit_tx_request` when calling `v2_stablecoinsystem_auctions_tx_zarexit_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'stablecoin_system_zarexit_tx_request' in local_var_params:
            body_params = local_var_params['stablecoin_system_zarexit_tx_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v2/stablecoinsystem/auctions/tx/zarexit', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ChainActivity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_stablecoinsystem_auctions_tx_zarjoin_post(self, stablecoin_system_zarjoin_tx_request, **kwargs):  # noqa: E501
        """approve and join ZAR token into Vat contract  # noqa: E501

        approve and join ZAR token into Vat contract  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_stablecoinsystem_auctions_tx_zarjoin_post(stablecoin_system_zarjoin_tx_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param StablecoinSystemZarjoinTxRequest stablecoin_system_zarjoin_tx_request: Approve and join Zar token into Vat contract transaction request (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ChainActivity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v2_stablecoinsystem_auctions_tx_zarjoin_post_with_http_info(stablecoin_system_zarjoin_tx_request, **kwargs)  # noqa: E501

    def v2_stablecoinsystem_auctions_tx_zarjoin_post_with_http_info(self, stablecoin_system_zarjoin_tx_request, **kwargs):  # noqa: E501
        """approve and join ZAR token into Vat contract  # noqa: E501

        approve and join ZAR token into Vat contract  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_stablecoinsystem_auctions_tx_zarjoin_post_with_http_info(stablecoin_system_zarjoin_tx_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param StablecoinSystemZarjoinTxRequest stablecoin_system_zarjoin_tx_request: Approve and join Zar token into Vat contract transaction request (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ChainActivity, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'stablecoin_system_zarjoin_tx_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_stablecoinsystem_auctions_tx_zarjoin_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'stablecoin_system_zarjoin_tx_request' is set
        if self.api_client.client_side_validation and ('stablecoin_system_zarjoin_tx_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['stablecoin_system_zarjoin_tx_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `stablecoin_system_zarjoin_tx_request` when calling `v2_stablecoinsystem_auctions_tx_zarjoin_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'stablecoin_system_zarjoin_tx_request' in local_var_params:
            body_params = local_var_params['stablecoin_system_zarjoin_tx_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v2/stablecoinsystem/auctions/tx/zarjoin', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ChainActivity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_stablecoinsystem_tx_bark_post(self, stablecoin_system_bark_tx_request, **kwargs):  # noqa: E501
        """liquidate a vault  # noqa: E501

        liquidate a vault  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_stablecoinsystem_tx_bark_post(stablecoin_system_bark_tx_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param StablecoinSystemBarkTxRequest stablecoin_system_bark_tx_request: Liquidate a Vault transaction request (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ChainActivity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v2_stablecoinsystem_tx_bark_post_with_http_info(stablecoin_system_bark_tx_request, **kwargs)  # noqa: E501

    def v2_stablecoinsystem_tx_bark_post_with_http_info(self, stablecoin_system_bark_tx_request, **kwargs):  # noqa: E501
        """liquidate a vault  # noqa: E501

        liquidate a vault  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_stablecoinsystem_tx_bark_post_with_http_info(stablecoin_system_bark_tx_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param StablecoinSystemBarkTxRequest stablecoin_system_bark_tx_request: Liquidate a Vault transaction request (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ChainActivity, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'stablecoin_system_bark_tx_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_stablecoinsystem_tx_bark_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'stablecoin_system_bark_tx_request' is set
        if self.api_client.client_side_validation and ('stablecoin_system_bark_tx_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['stablecoin_system_bark_tx_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `stablecoin_system_bark_tx_request` when calling `v2_stablecoinsystem_tx_bark_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'stablecoin_system_bark_tx_request' in local_var_params:
            body_params = local_var_params['stablecoin_system_bark_tx_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v2/stablecoinsystem/tx/bark', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ChainActivity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_stablecoinsystem_tx_createvault_post(self, stablecoin_system_create_vault_tx_request, **kwargs):  # noqa: E501
        """Create vault  # noqa: E501

        Create vault  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_stablecoinsystem_tx_createvault_post(stablecoin_system_create_vault_tx_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param StablecoinSystemCreateVaultTxRequest stablecoin_system_create_vault_tx_request: Create vault transaction request (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ChainActivity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v2_stablecoinsystem_tx_createvault_post_with_http_info(stablecoin_system_create_vault_tx_request, **kwargs)  # noqa: E501

    def v2_stablecoinsystem_tx_createvault_post_with_http_info(self, stablecoin_system_create_vault_tx_request, **kwargs):  # noqa: E501
        """Create vault  # noqa: E501

        Create vault  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_stablecoinsystem_tx_createvault_post_with_http_info(stablecoin_system_create_vault_tx_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param StablecoinSystemCreateVaultTxRequest stablecoin_system_create_vault_tx_request: Create vault transaction request (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ChainActivity, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'stablecoin_system_create_vault_tx_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_stablecoinsystem_tx_createvault_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'stablecoin_system_create_vault_tx_request' is set
        if self.api_client.client_side_validation and ('stablecoin_system_create_vault_tx_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['stablecoin_system_create_vault_tx_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `stablecoin_system_create_vault_tx_request` when calling `v2_stablecoinsystem_tx_createvault_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'stablecoin_system_create_vault_tx_request' in local_var_params:
            body_params = local_var_params['stablecoin_system_create_vault_tx_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v2/stablecoinsystem/tx/createvault', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ChainActivity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_stablecoinsystem_tx_depositcollateral_post(self, stablecoin_system_deposit_collateral_tx_request, **kwargs):  # noqa: E501
        """Deposit collateral  # noqa: E501

        Deposit collateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_stablecoinsystem_tx_depositcollateral_post(stablecoin_system_deposit_collateral_tx_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param StablecoinSystemDepositCollateralTxRequest stablecoin_system_deposit_collateral_tx_request: Deposit collateral transaction request (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ChainActivity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v2_stablecoinsystem_tx_depositcollateral_post_with_http_info(stablecoin_system_deposit_collateral_tx_request, **kwargs)  # noqa: E501

    def v2_stablecoinsystem_tx_depositcollateral_post_with_http_info(self, stablecoin_system_deposit_collateral_tx_request, **kwargs):  # noqa: E501
        """Deposit collateral  # noqa: E501

        Deposit collateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_stablecoinsystem_tx_depositcollateral_post_with_http_info(stablecoin_system_deposit_collateral_tx_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param StablecoinSystemDepositCollateralTxRequest stablecoin_system_deposit_collateral_tx_request: Deposit collateral transaction request (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ChainActivity, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'stablecoin_system_deposit_collateral_tx_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_stablecoinsystem_tx_depositcollateral_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'stablecoin_system_deposit_collateral_tx_request' is set
        if self.api_client.client_side_validation and ('stablecoin_system_deposit_collateral_tx_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['stablecoin_system_deposit_collateral_tx_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `stablecoin_system_deposit_collateral_tx_request` when calling `v2_stablecoinsystem_tx_depositcollateral_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'stablecoin_system_deposit_collateral_tx_request' in local_var_params:
            body_params = local_var_params['stablecoin_system_deposit_collateral_tx_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v2/stablecoinsystem/tx/depositcollateral', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ChainActivity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_stablecoinsystem_tx_mintzar_post(self, stablecoin_system_mint_zar_tx_request, **kwargs):  # noqa: E501
        """Mint ZAR  # noqa: E501

        Mint ZAR  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_stablecoinsystem_tx_mintzar_post(stablecoin_system_mint_zar_tx_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param StablecoinSystemMintZarTxRequest stablecoin_system_mint_zar_tx_request: Mint ZAR transaction request (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ChainActivity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v2_stablecoinsystem_tx_mintzar_post_with_http_info(stablecoin_system_mint_zar_tx_request, **kwargs)  # noqa: E501

    def v2_stablecoinsystem_tx_mintzar_post_with_http_info(self, stablecoin_system_mint_zar_tx_request, **kwargs):  # noqa: E501
        """Mint ZAR  # noqa: E501

        Mint ZAR  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_stablecoinsystem_tx_mintzar_post_with_http_info(stablecoin_system_mint_zar_tx_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param StablecoinSystemMintZarTxRequest stablecoin_system_mint_zar_tx_request: Mint ZAR transaction request (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ChainActivity, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'stablecoin_system_mint_zar_tx_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_stablecoinsystem_tx_mintzar_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'stablecoin_system_mint_zar_tx_request' is set
        if self.api_client.client_side_validation and ('stablecoin_system_mint_zar_tx_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['stablecoin_system_mint_zar_tx_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `stablecoin_system_mint_zar_tx_request` when calling `v2_stablecoinsystem_tx_mintzar_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'stablecoin_system_mint_zar_tx_request' in local_var_params:
            body_params = local_var_params['stablecoin_system_mint_zar_tx_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v2/stablecoinsystem/tx/mintzar', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ChainActivity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_stablecoinsystem_tx_repayzar_post(self, stablecoin_system_repay_zar_tx_request, **kwargs):  # noqa: E501
        """Repay ZAR  # noqa: E501

        Repay ZAR  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_stablecoinsystem_tx_repayzar_post(stablecoin_system_repay_zar_tx_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param StablecoinSystemRepayZarTxRequest stablecoin_system_repay_zar_tx_request: Repay ZAR transaction request (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ChainActivity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v2_stablecoinsystem_tx_repayzar_post_with_http_info(stablecoin_system_repay_zar_tx_request, **kwargs)  # noqa: E501

    def v2_stablecoinsystem_tx_repayzar_post_with_http_info(self, stablecoin_system_repay_zar_tx_request, **kwargs):  # noqa: E501
        """Repay ZAR  # noqa: E501

        Repay ZAR  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_stablecoinsystem_tx_repayzar_post_with_http_info(stablecoin_system_repay_zar_tx_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param StablecoinSystemRepayZarTxRequest stablecoin_system_repay_zar_tx_request: Repay ZAR transaction request (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ChainActivity, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'stablecoin_system_repay_zar_tx_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_stablecoinsystem_tx_repayzar_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'stablecoin_system_repay_zar_tx_request' is set
        if self.api_client.client_side_validation and ('stablecoin_system_repay_zar_tx_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['stablecoin_system_repay_zar_tx_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `stablecoin_system_repay_zar_tx_request` when calling `v2_stablecoinsystem_tx_repayzar_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'stablecoin_system_repay_zar_tx_request' in local_var_params:
            body_params = local_var_params['stablecoin_system_repay_zar_tx_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v2/stablecoinsystem/tx/repayzar', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ChainActivity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_stablecoinsystem_tx_withdrawcollateral_post(self, stablecoin_system_withdraw_collateral_tx_request, **kwargs):  # noqa: E501
        """Withdraw collateral  # noqa: E501

        Withdraw collateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_stablecoinsystem_tx_withdrawcollateral_post(stablecoin_system_withdraw_collateral_tx_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param StablecoinSystemWithdrawCollateralTxRequest stablecoin_system_withdraw_collateral_tx_request: Withdraw collateral transaction request (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ChainActivity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v2_stablecoinsystem_tx_withdrawcollateral_post_with_http_info(stablecoin_system_withdraw_collateral_tx_request, **kwargs)  # noqa: E501

    def v2_stablecoinsystem_tx_withdrawcollateral_post_with_http_info(self, stablecoin_system_withdraw_collateral_tx_request, **kwargs):  # noqa: E501
        """Withdraw collateral  # noqa: E501

        Withdraw collateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_stablecoinsystem_tx_withdrawcollateral_post_with_http_info(stablecoin_system_withdraw_collateral_tx_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param StablecoinSystemWithdrawCollateralTxRequest stablecoin_system_withdraw_collateral_tx_request: Withdraw collateral transaction request (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ChainActivity, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'stablecoin_system_withdraw_collateral_tx_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_stablecoinsystem_tx_withdrawcollateral_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'stablecoin_system_withdraw_collateral_tx_request' is set
        if self.api_client.client_side_validation and ('stablecoin_system_withdraw_collateral_tx_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['stablecoin_system_withdraw_collateral_tx_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `stablecoin_system_withdraw_collateral_tx_request` when calling `v2_stablecoinsystem_tx_withdrawcollateral_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'stablecoin_system_withdraw_collateral_tx_request' in local_var_params:
            body_params = local_var_params['stablecoin_system_withdraw_collateral_tx_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v2/stablecoinsystem/tx/withdrawcollateral', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ChainActivity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_stats_get(self, **kwargs):  # noqa: E501
        """Get collector data  # noqa: E501

        Get collector data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_stats_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Stats
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v2_stats_get_with_http_info(**kwargs)  # noqa: E501

    def v2_stats_get_with_http_info(self, **kwargs):  # noqa: E501
        """Get collector data  # noqa: E501

        Get collector data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_stats_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Stats, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_stats_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v2/stats', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Stats',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_vaults_get(self, **kwargs):  # noqa: E501
        """Get vaults by owner query  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_vaults_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Ethereum address of the owner
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Vault]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v2_vaults_get_with_http_info(**kwargs)  # noqa: E501

    def v2_vaults_get_with_http_info(self, **kwargs):  # noqa: E501
        """Get vaults by owner query  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_vaults_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str owner: Ethereum address of the owner
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Vault], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'owner'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_vaults_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'owner' in local_var_params and local_var_params['owner'] is not None:  # noqa: E501
            query_params.append(('owner', local_var_params['owner']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v2/vaults', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Vault]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_vaults_id_events_get(self, id, **kwargs):  # noqa: E501
        """Get vault events by ID  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_vaults_id_events_get(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: Vault ID (required)
        :param str type: Event type
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[BasicEvent]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v2_vaults_id_events_get_with_http_info(id, **kwargs)  # noqa: E501

    def v2_vaults_id_events_get_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get vault events by ID  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_vaults_id_events_get_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: Vault ID (required)
        :param str type: Event type
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[BasicEvent], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_vaults_id_events_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `v2_vaults_id_events_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v2/vaults/{id}/events', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BasicEvent]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_vaults_id_get(self, id, **kwargs):  # noqa: E501
        """Get a vault by ID  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_vaults_id_get(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: Vault ID (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Vault
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v2_vaults_id_get_with_http_info(id, **kwargs)  # noqa: E501

    def v2_vaults_id_get_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get a vault by ID  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_vaults_id_get_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int id: Vault ID (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Vault, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_vaults_id_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `v2_vaults_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v2/vaults/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Vault',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
