# coding: utf-8

"""
    Zarban API

    API for Zarban services.  # noqa: E501

    The version of the OpenAPI document: 2.0.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from zarban.service.openapi_client.configuration import Configuration


class Order(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'quote_id': 'str',
        'outputs': 'list[RawDutchAmount]',
        'encoded_order': 'str',
        'signature': 'str',
        'input': 'RawDutchAmount',
        'order_status': 'str',
        'chain_id': 'int',
        'order_hash': 'str',
        'order_type': 'str'
    }

    attribute_map = {
        'quote_id': 'quoteId',
        'outputs': 'outputs',
        'encoded_order': 'encodedOrder',
        'signature': 'signature',
        'input': 'input',
        'order_status': 'orderStatus',
        'chain_id': 'chainId',
        'order_hash': 'orderHash',
        'order_type': 'orderType'
    }

    def __init__(self, quote_id=None, outputs=None, encoded_order=None, signature=None, input=None, order_status=None, chain_id=None, order_hash=None, order_type=None, local_vars_configuration=None):  # noqa: E501
        """Order - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._quote_id = None
        self._outputs = None
        self._encoded_order = None
        self._signature = None
        self._input = None
        self._order_status = None
        self._chain_id = None
        self._order_hash = None
        self._order_type = None
        self.discriminator = None

        if quote_id is not None:
            self.quote_id = quote_id
        self.outputs = outputs
        self.encoded_order = encoded_order
        self.signature = signature
        self.input = input
        self.order_status = order_status
        self.chain_id = chain_id
        self.order_hash = order_hash
        if order_type is not None:
            self.order_type = order_type

    @property
    def quote_id(self):
        """Gets the quote_id of this Order.  # noqa: E501


        :return: The quote_id of this Order.  # noqa: E501
        :rtype: str
        """
        return self._quote_id

    @quote_id.setter
    def quote_id(self, quote_id):
        """Sets the quote_id of this Order.


        :param quote_id: The quote_id of this Order.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                quote_id is not None and not re.search(r'^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[4][0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}$', quote_id)):  # noqa: E501
            raise ValueError(r"Invalid value for `quote_id`, must be a follow pattern or equal to `/^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[4][0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}$/`")  # noqa: E501

        self._quote_id = quote_id

    @property
    def outputs(self):
        """Gets the outputs of this Order.  # noqa: E501


        :return: The outputs of this Order.  # noqa: E501
        :rtype: list[RawDutchAmount]
        """
        return self._outputs

    @outputs.setter
    def outputs(self, outputs):
        """Sets the outputs of this Order.


        :param outputs: The outputs of this Order.  # noqa: E501
        :type: list[RawDutchAmount]
        """
        if self.local_vars_configuration.client_side_validation and outputs is None:  # noqa: E501
            raise ValueError("Invalid value for `outputs`, must not be `None`")  # noqa: E501

        self._outputs = outputs

    @property
    def encoded_order(self):
        """Gets the encoded_order of this Order.  # noqa: E501


        :return: The encoded_order of this Order.  # noqa: E501
        :rtype: str
        """
        return self._encoded_order

    @encoded_order.setter
    def encoded_order(self, encoded_order):
        """Sets the encoded_order of this Order.


        :param encoded_order: The encoded_order of this Order.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and encoded_order is None:  # noqa: E501
            raise ValueError("Invalid value for `encoded_order`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                encoded_order is not None and not re.search(r'^(0x)?[0-9a-fA-F]*$', encoded_order)):  # noqa: E501
            raise ValueError(r"Invalid value for `encoded_order`, must be a follow pattern or equal to `/^(0x)?[0-9a-fA-F]*$/`")  # noqa: E501

        self._encoded_order = encoded_order

    @property
    def signature(self):
        """Gets the signature of this Order.  # noqa: E501


        :return: The signature of this Order.  # noqa: E501
        :rtype: str
        """
        return self._signature

    @signature.setter
    def signature(self, signature):
        """Sets the signature of this Order.


        :param signature: The signature of this Order.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and signature is None:  # noqa: E501
            raise ValueError("Invalid value for `signature`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                signature is not None and not re.search(r'^(0x)?[0-9a-fA-F]{130}$', signature)):  # noqa: E501
            raise ValueError(r"Invalid value for `signature`, must be a follow pattern or equal to `/^(0x)?[0-9a-fA-F]{130}$/`")  # noqa: E501

        self._signature = signature

    @property
    def input(self):
        """Gets the input of this Order.  # noqa: E501


        :return: The input of this Order.  # noqa: E501
        :rtype: RawDutchAmount
        """
        return self._input

    @input.setter
    def input(self, input):
        """Sets the input of this Order.


        :param input: The input of this Order.  # noqa: E501
        :type: RawDutchAmount
        """
        if self.local_vars_configuration.client_side_validation and input is None:  # noqa: E501
            raise ValueError("Invalid value for `input`, must not be `None`")  # noqa: E501

        self._input = input

    @property
    def order_status(self):
        """Gets the order_status of this Order.  # noqa: E501


        :return: The order_status of this Order.  # noqa: E501
        :rtype: str
        """
        return self._order_status

    @order_status.setter
    def order_status(self, order_status):
        """Sets the order_status of this Order.


        :param order_status: The order_status of this Order.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and order_status is None:  # noqa: E501
            raise ValueError("Invalid value for `order_status`, must not be `None`")  # noqa: E501
        allowed_values = ["open", "expired", "error", "cancelled", "filled", "insufficient-funds"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and order_status not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `order_status` ({0}), must be one of {1}"  # noqa: E501
                .format(order_status, allowed_values)
            )

        self._order_status = order_status

    @property
    def chain_id(self):
        """Gets the chain_id of this Order.  # noqa: E501


        :return: The chain_id of this Order.  # noqa: E501
        :rtype: int
        """
        return self._chain_id

    @chain_id.setter
    def chain_id(self, chain_id):
        """Sets the chain_id of this Order.


        :param chain_id: The chain_id of this Order.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and chain_id is None:  # noqa: E501
            raise ValueError("Invalid value for `chain_id`, must not be `None`")  # noqa: E501

        self._chain_id = chain_id

    @property
    def order_hash(self):
        """Gets the order_hash of this Order.  # noqa: E501


        :return: The order_hash of this Order.  # noqa: E501
        :rtype: str
        """
        return self._order_hash

    @order_hash.setter
    def order_hash(self, order_hash):
        """Sets the order_hash of this Order.


        :param order_hash: The order_hash of this Order.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and order_hash is None:  # noqa: E501
            raise ValueError("Invalid value for `order_hash`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                order_hash is not None and not re.search(r'^(0x)?[0-9a-fA-F]{64}$', order_hash)):  # noqa: E501
            raise ValueError(r"Invalid value for `order_hash`, must be a follow pattern or equal to `/^(0x)?[0-9a-fA-F]{64}$/`")  # noqa: E501

        self._order_hash = order_hash

    @property
    def order_type(self):
        """Gets the order_type of this Order.  # noqa: E501


        :return: The order_type of this Order.  # noqa: E501
        :rtype: str
        """
        return self._order_type

    @order_type.setter
    def order_type(self, order_type):
        """Sets the order_type of this Order.


        :param order_type: The order_type of this Order.  # noqa: E501
        :type: str
        """
        allowed_values = ["dutch", "limit"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and order_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `order_type` ({0}), must be one of {1}"  # noqa: E501
                .format(order_type, allowed_values)
            )

        self._order_type = order_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Order):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Order):
            return True

        return self.to_dict() != other.to_dict()
