# coding: utf-8

"""
    Zarban Wallet API

    API for Zarban wallet services.  # noqa: E501

    The version of the OpenAPI document: 2.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from zarban.wallet.openapi_client.api_client import ApiClient
from zarban.wallet.openapi_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class LoansApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def loans_estimate_get(self, plan_name, loan_to_value_option, amount, input_type, **kwargs):  # noqa: E501
        """Get collateral and loan amount estimation  # noqa: E501

        Get an estimate of required collateral for a specific loan amount, and vice versa.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.loans_estimate_get(plan_name, loan_to_value_option, amount, input_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str plan_name: The name of the loan plan (required)
        :param LoanToValueOptions loan_to_value_option: The desired loan to value option (required)
        :param str amount: Loan/Collateral amount (required)
        :param str input_type: The type of the input amount (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: dict(str, str)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.loans_estimate_get_with_http_info(plan_name, loan_to_value_option, amount, input_type, **kwargs)  # noqa: E501

    def loans_estimate_get_with_http_info(self, plan_name, loan_to_value_option, amount, input_type, **kwargs):  # noqa: E501
        """Get collateral and loan amount estimation  # noqa: E501

        Get an estimate of required collateral for a specific loan amount, and vice versa.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.loans_estimate_get_with_http_info(plan_name, loan_to_value_option, amount, input_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str plan_name: The name of the loan plan (required)
        :param LoanToValueOptions loan_to_value_option: The desired loan to value option (required)
        :param str amount: Loan/Collateral amount (required)
        :param str input_type: The type of the input amount (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(dict(str, str), status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'plan_name',
            'loan_to_value_option',
            'amount',
            'input_type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method loans_estimate_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'plan_name' is set
        if self.api_client.client_side_validation and ('plan_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['plan_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `plan_name` when calling `loans_estimate_get`")  # noqa: E501
        # verify the required parameter 'loan_to_value_option' is set
        if self.api_client.client_side_validation and ('loan_to_value_option' not in local_var_params or  # noqa: E501
                                                        local_var_params['loan_to_value_option'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `loan_to_value_option` when calling `loans_estimate_get`")  # noqa: E501
        # verify the required parameter 'amount' is set
        if self.api_client.client_side_validation and ('amount' not in local_var_params or  # noqa: E501
                                                        local_var_params['amount'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `amount` when calling `loans_estimate_get`")  # noqa: E501
        # verify the required parameter 'input_type' is set
        if self.api_client.client_side_validation and ('input_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['input_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `input_type` when calling `loans_estimate_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'plan_name' in local_var_params and local_var_params['plan_name'] is not None:  # noqa: E501
            query_params.append(('planName', local_var_params['plan_name']))  # noqa: E501
        if 'loan_to_value_option' in local_var_params and local_var_params['loan_to_value_option'] is not None:  # noqa: E501
            query_params.append(('loanToValueOption', local_var_params['loan_to_value_option']))  # noqa: E501
        if 'amount' in local_var_params and local_var_params['amount'] is not None:  # noqa: E501
            query_params.append(('amount', local_var_params['amount']))  # noqa: E501
        if 'input_type' in local_var_params and local_var_params['input_type'] is not None:  # noqa: E501
            query_params.append(('inputType', local_var_params['input_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/loans/estimate', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, str)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
