# coding: utf-8

"""
    Zarban API

    API for Zarban services.  # noqa: E501

    The version of the OpenAPI document: 2.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from zarban.service.openapi_client.api_client import ApiClient
from zarban.service.openapi_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class LendingPoolApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def v2_lendingpool_borrows_get(self, **kwargs):  # noqa: E501
        """Get user borrows of lendingpool  # noqa: E501

        Get user borrows of lendingpool  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_lendingpool_borrows_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user: Ethereum address of the user
        :param str reserve: Ethereum address of the reserve
        :param int cursor: Cursor for pagination
        :param int limit: Limit the number of deposits returned (default is 50)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[LendingpoolBorrow]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v2_lendingpool_borrows_get_with_http_info(**kwargs)  # noqa: E501

    def v2_lendingpool_borrows_get_with_http_info(self, **kwargs):  # noqa: E501
        """Get user borrows of lendingpool  # noqa: E501

        Get user borrows of lendingpool  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_lendingpool_borrows_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user: Ethereum address of the user
        :param str reserve: Ethereum address of the reserve
        :param int cursor: Cursor for pagination
        :param int limit: Limit the number of deposits returned (default is 50)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[LendingpoolBorrow], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user',
            'reserve',
            'cursor',
            'limit'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_lendingpool_borrows_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'user' in local_var_params and not re.search(r'0x[a-fA-F0-9]{40}', local_var_params['user']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `user` when calling `v2_lendingpool_borrows_get`, must conform to the pattern `/0x[a-fA-F0-9]{40}/`")  # noqa: E501
        if self.api_client.client_side_validation and 'reserve' in local_var_params and not re.search(r'0x[a-fA-F0-9]{40}', local_var_params['reserve']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `reserve` when calling `v2_lendingpool_borrows_get`, must conform to the pattern `/0x[a-fA-F0-9]{40}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'user' in local_var_params and local_var_params['user'] is not None:  # noqa: E501
            query_params.append(('user', local_var_params['user']))  # noqa: E501
        if 'reserve' in local_var_params and local_var_params['reserve'] is not None:  # noqa: E501
            query_params.append(('reserve', local_var_params['reserve']))  # noqa: E501
        if 'cursor' in local_var_params and local_var_params['cursor'] is not None:  # noqa: E501
            query_params.append(('cursor', local_var_params['cursor']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v2/lendingpool/borrows', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[LendingpoolBorrow]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_lendingpool_deposits_get(self, **kwargs):  # noqa: E501
        """Get user deposits of Lendingpool  # noqa: E501

        Get user deposits of Lendingpool  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_lendingpool_deposits_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user: Ethereum address of the user
        :param str reserve: Ethereum address of the reserve
        :param int cursor: Cursor for pagination
        :param int limit: Limit the number of deposits returned (default is 50)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[LendingpoolDeposit]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v2_lendingpool_deposits_get_with_http_info(**kwargs)  # noqa: E501

    def v2_lendingpool_deposits_get_with_http_info(self, **kwargs):  # noqa: E501
        """Get user deposits of Lendingpool  # noqa: E501

        Get user deposits of Lendingpool  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_lendingpool_deposits_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str user: Ethereum address of the user
        :param str reserve: Ethereum address of the reserve
        :param int cursor: Cursor for pagination
        :param int limit: Limit the number of deposits returned (default is 50)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[LendingpoolDeposit], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'user',
            'reserve',
            'cursor',
            'limit'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_lendingpool_deposits_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'user' in local_var_params and not re.search(r'0x[a-fA-F0-9]{40}', local_var_params['user']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `user` when calling `v2_lendingpool_deposits_get`, must conform to the pattern `/0x[a-fA-F0-9]{40}/`")  # noqa: E501
        if self.api_client.client_side_validation and 'reserve' in local_var_params and not re.search(r'0x[a-fA-F0-9]{40}', local_var_params['reserve']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `reserve` when calling `v2_lendingpool_deposits_get`, must conform to the pattern `/0x[a-fA-F0-9]{40}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'user' in local_var_params and local_var_params['user'] is not None:  # noqa: E501
            query_params.append(('user', local_var_params['user']))  # noqa: E501
        if 'reserve' in local_var_params and local_var_params['reserve'] is not None:  # noqa: E501
            query_params.append(('reserve', local_var_params['reserve']))  # noqa: E501
        if 'cursor' in local_var_params and local_var_params['cursor'] is not None:  # noqa: E501
            query_params.append(('cursor', local_var_params['cursor']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v2/lendingpool/deposits', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[LendingpoolDeposit]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_lendingpool_reserves_get(self, **kwargs):  # noqa: E501
        """Fetch Reserve Data By Asset  # noqa: E501

        Retrieve data of reserves  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_lendingpool_reserves_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str asset: The asset address in hexadecimal format.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FormattedReserveData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v2_lendingpool_reserves_get_with_http_info(**kwargs)  # noqa: E501

    def v2_lendingpool_reserves_get_with_http_info(self, **kwargs):  # noqa: E501
        """Fetch Reserve Data By Asset  # noqa: E501

        Retrieve data of reserves  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_lendingpool_reserves_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str asset: The asset address in hexadecimal format.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FormattedReserveData, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'asset'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_lendingpool_reserves_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'asset' in local_var_params and local_var_params['asset'] is not None:  # noqa: E501
            query_params.append(('asset', local_var_params['asset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v2/lendingpool/reserves', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FormattedReserveData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_lendingpool_tx_borrow_post(self, lendingpool_borrow_tx_request, **kwargs):  # noqa: E501
        """Borrow from lending pool  # noqa: E501

        Borrow from lending pool  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_lendingpool_tx_borrow_post(lendingpool_borrow_tx_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param LendingpoolBorrowTxRequest lendingpool_borrow_tx_request: Borrow transaction request, if amount is not provided, it will be calculated based on the token balance (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v2_lendingpool_tx_borrow_post_with_http_info(lendingpool_borrow_tx_request, **kwargs)  # noqa: E501

    def v2_lendingpool_tx_borrow_post_with_http_info(self, lendingpool_borrow_tx_request, **kwargs):  # noqa: E501
        """Borrow from lending pool  # noqa: E501

        Borrow from lending pool  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_lendingpool_tx_borrow_post_with_http_info(lendingpool_borrow_tx_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param LendingpoolBorrowTxRequest lendingpool_borrow_tx_request: Borrow transaction request, if amount is not provided, it will be calculated based on the token balance (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse200, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'lendingpool_borrow_tx_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_lendingpool_tx_borrow_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'lendingpool_borrow_tx_request' is set
        if self.api_client.client_side_validation and ('lendingpool_borrow_tx_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['lendingpool_borrow_tx_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `lendingpool_borrow_tx_request` when calling `v2_lendingpool_tx_borrow_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'lendingpool_borrow_tx_request' in local_var_params:
            body_params = local_var_params['lendingpool_borrow_tx_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v2/lendingpool/tx/borrow', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse200',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_lendingpool_tx_deposit_post(self, lendingpool_deposit_tx_request, **kwargs):  # noqa: E501
        """Deposit to lending pool  # noqa: E501

        Deposit to lending pool  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_lendingpool_tx_deposit_post(lendingpool_deposit_tx_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param LendingpoolDepositTxRequest lendingpool_deposit_tx_request: Deposit transaction request, if amount is not provided, it will be calculated based on the token balance (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v2_lendingpool_tx_deposit_post_with_http_info(lendingpool_deposit_tx_request, **kwargs)  # noqa: E501

    def v2_lendingpool_tx_deposit_post_with_http_info(self, lendingpool_deposit_tx_request, **kwargs):  # noqa: E501
        """Deposit to lending pool  # noqa: E501

        Deposit to lending pool  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_lendingpool_tx_deposit_post_with_http_info(lendingpool_deposit_tx_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param LendingpoolDepositTxRequest lendingpool_deposit_tx_request: Deposit transaction request, if amount is not provided, it will be calculated based on the token balance (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse200, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'lendingpool_deposit_tx_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_lendingpool_tx_deposit_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'lendingpool_deposit_tx_request' is set
        if self.api_client.client_side_validation and ('lendingpool_deposit_tx_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['lendingpool_deposit_tx_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `lendingpool_deposit_tx_request` when calling `v2_lendingpool_tx_deposit_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'lendingpool_deposit_tx_request' in local_var_params:
            body_params = local_var_params['lendingpool_deposit_tx_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v2/lendingpool/tx/deposit', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse200',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_lendingpool_tx_repay_post(self, lendingpool_repay_tx_request, **kwargs):  # noqa: E501
        """Repay to lending pool  # noqa: E501

        Repay to lending pool  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_lendingpool_tx_repay_post(lendingpool_repay_tx_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param LendingpoolRepayTxRequest lendingpool_repay_tx_request: Repay transaction request, if amount is not provided, it will repay the maximum possible amount (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v2_lendingpool_tx_repay_post_with_http_info(lendingpool_repay_tx_request, **kwargs)  # noqa: E501

    def v2_lendingpool_tx_repay_post_with_http_info(self, lendingpool_repay_tx_request, **kwargs):  # noqa: E501
        """Repay to lending pool  # noqa: E501

        Repay to lending pool  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_lendingpool_tx_repay_post_with_http_info(lendingpool_repay_tx_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param LendingpoolRepayTxRequest lendingpool_repay_tx_request: Repay transaction request, if amount is not provided, it will repay the maximum possible amount (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse200, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'lendingpool_repay_tx_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_lendingpool_tx_repay_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'lendingpool_repay_tx_request' is set
        if self.api_client.client_side_validation and ('lendingpool_repay_tx_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['lendingpool_repay_tx_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `lendingpool_repay_tx_request` when calling `v2_lendingpool_tx_repay_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'lendingpool_repay_tx_request' in local_var_params:
            body_params = local_var_params['lendingpool_repay_tx_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v2/lendingpool/tx/repay', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse200',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_lendingpool_tx_useassetascollateral_post(self, lendingpool_use_asset_as_collateral_tx_request, **kwargs):  # noqa: E501
        """Enable/Disable asset as collateral  # noqa: E501

        Allows to enable/disable a specific asset as collateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_lendingpool_tx_useassetascollateral_post(lendingpool_use_asset_as_collateral_tx_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param LendingpoolUseAssetAsCollateralTxRequest lendingpool_use_asset_as_collateral_tx_request: UseAssetAsCollateral transaction request (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v2_lendingpool_tx_useassetascollateral_post_with_http_info(lendingpool_use_asset_as_collateral_tx_request, **kwargs)  # noqa: E501

    def v2_lendingpool_tx_useassetascollateral_post_with_http_info(self, lendingpool_use_asset_as_collateral_tx_request, **kwargs):  # noqa: E501
        """Enable/Disable asset as collateral  # noqa: E501

        Allows to enable/disable a specific asset as collateral  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_lendingpool_tx_useassetascollateral_post_with_http_info(lendingpool_use_asset_as_collateral_tx_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param LendingpoolUseAssetAsCollateralTxRequest lendingpool_use_asset_as_collateral_tx_request: UseAssetAsCollateral transaction request (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse200, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'lendingpool_use_asset_as_collateral_tx_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_lendingpool_tx_useassetascollateral_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'lendingpool_use_asset_as_collateral_tx_request' is set
        if self.api_client.client_side_validation and ('lendingpool_use_asset_as_collateral_tx_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['lendingpool_use_asset_as_collateral_tx_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `lendingpool_use_asset_as_collateral_tx_request` when calling `v2_lendingpool_tx_useassetascollateral_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'lendingpool_use_asset_as_collateral_tx_request' in local_var_params:
            body_params = local_var_params['lendingpool_use_asset_as_collateral_tx_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v2/lendingpool/tx/useassetascollateral', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse200',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_lendingpool_tx_withdraw_post(self, lendingpool_withdraw_tx_request, **kwargs):  # noqa: E501
        """Withdraw from lending pool  # noqa: E501

        Withdraw from lending pool  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_lendingpool_tx_withdraw_post(lendingpool_withdraw_tx_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param LendingpoolWithdrawTxRequest lendingpool_withdraw_tx_request: Withdraw transaction request, if amount is not provided, it will be calculated based on the user account status (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v2_lendingpool_tx_withdraw_post_with_http_info(lendingpool_withdraw_tx_request, **kwargs)  # noqa: E501

    def v2_lendingpool_tx_withdraw_post_with_http_info(self, lendingpool_withdraw_tx_request, **kwargs):  # noqa: E501
        """Withdraw from lending pool  # noqa: E501

        Withdraw from lending pool  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_lendingpool_tx_withdraw_post_with_http_info(lendingpool_withdraw_tx_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param LendingpoolWithdrawTxRequest lendingpool_withdraw_tx_request: Withdraw transaction request, if amount is not provided, it will be calculated based on the user account status (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse200, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'lendingpool_withdraw_tx_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_lendingpool_tx_withdraw_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'lendingpool_withdraw_tx_request' is set
        if self.api_client.client_side_validation and ('lendingpool_withdraw_tx_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['lendingpool_withdraw_tx_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `lendingpool_withdraw_tx_request` when calling `v2_lendingpool_tx_withdraw_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'lendingpool_withdraw_tx_request' in local_var_params:
            body_params = local_var_params['lendingpool_withdraw_tx_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v2/lendingpool/tx/withdraw', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse200',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
