# coding: utf-8

"""
    Zarban API

    API for Zarban services.  # noqa: E501

    The version of the OpenAPI document: 2.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from zarban.service.openapi_client.api_client import ApiClient
from zarban.service.openapi_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class OrdersApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def v2_orders_get(self, **kwargs):  # noqa: E501
        """Fetch Unfilled Orders  # noqa: E501

        Get a list of unfilled orders filtered by different parameters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_orders_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str type: Type of the order
        :param str hash: order hash
        :param str status: Status of the order
        :param str offerer: Ethereum address of the offerer
        :param str filler: Ethereum address of the filler
        :param TimeRange decay_start_time: Decay start time
        :param TimeRange decay_end_time: Decay end time
        :param TimeRange deadline: Order deadline
        :param int cursor: Cursor for pagination
        :param int limit: Limit the number of orders returned (default is 10)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Order]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v2_orders_get_with_http_info(**kwargs)  # noqa: E501

    def v2_orders_get_with_http_info(self, **kwargs):  # noqa: E501
        """Fetch Unfilled Orders  # noqa: E501

        Get a list of unfilled orders filtered by different parameters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_orders_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str type: Type of the order
        :param str hash: order hash
        :param str status: Status of the order
        :param str offerer: Ethereum address of the offerer
        :param str filler: Ethereum address of the filler
        :param TimeRange decay_start_time: Decay start time
        :param TimeRange decay_end_time: Decay end time
        :param TimeRange deadline: Order deadline
        :param int cursor: Cursor for pagination
        :param int limit: Limit the number of orders returned (default is 10)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Order], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'type',
            'hash',
            'status',
            'offerer',
            'filler',
            'decay_start_time',
            'decay_end_time',
            'deadline',
            'cursor',
            'limit'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_orders_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'hash' in local_var_params and not re.search(r'^0x[0-9,a-z,A-Z]{64}$', local_var_params['hash']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `hash` when calling `v2_orders_get`, must conform to the pattern `/^0x[0-9,a-z,A-Z]{64}$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'offerer' in local_var_params and not re.search(r'0x[a-fA-F0-9]{40}', local_var_params['offerer']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `offerer` when calling `v2_orders_get`, must conform to the pattern `/0x[a-fA-F0-9]{40}/`")  # noqa: E501
        if self.api_client.client_side_validation and 'filler' in local_var_params and not re.search(r'0x[a-fA-F0-9]{40}', local_var_params['filler']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filler` when calling `v2_orders_get`, must conform to the pattern `/0x[a-fA-F0-9]{40}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'hash' in local_var_params and local_var_params['hash'] is not None:  # noqa: E501
            query_params.append(('hash', local_var_params['hash']))  # noqa: E501
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'offerer' in local_var_params and local_var_params['offerer'] is not None:  # noqa: E501
            query_params.append(('offerer', local_var_params['offerer']))  # noqa: E501
        if 'filler' in local_var_params and local_var_params['filler'] is not None:  # noqa: E501
            query_params.append(('filler', local_var_params['filler']))  # noqa: E501
        if 'decay_start_time' in local_var_params and local_var_params['decay_start_time'] is not None:  # noqa: E501
            query_params.append(('decayStartTime', local_var_params['decay_start_time']))  # noqa: E501
        if 'decay_end_time' in local_var_params and local_var_params['decay_end_time'] is not None:  # noqa: E501
            query_params.append(('decayEndTime', local_var_params['decay_end_time']))  # noqa: E501
        if 'deadline' in local_var_params and local_var_params['deadline'] is not None:  # noqa: E501
            query_params.append(('deadline', local_var_params['deadline']))  # noqa: E501
        if 'cursor' in local_var_params and local_var_params['cursor'] is not None:  # noqa: E501
            query_params.append(('cursor', local_var_params['cursor']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v2/orders', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Order]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def v2_orders_sync_post(self, update_order_request, **kwargs):  # noqa: E501
        """Updates Order Entity  # noqa: E501

        updates an order entity in database  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_orders_sync_post(update_order_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param UpdateOrderRequest update_order_request: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Error
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.v2_orders_sync_post_with_http_info(update_order_request, **kwargs)  # noqa: E501

    def v2_orders_sync_post_with_http_info(self, update_order_request, **kwargs):  # noqa: E501
        """Updates Order Entity  # noqa: E501

        updates an order entity in database  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.v2_orders_sync_post_with_http_info(update_order_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param UpdateOrderRequest update_order_request: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Error, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'update_order_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v2_orders_sync_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'update_order_request' is set
        if self.api_client.client_side_validation and ('update_order_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['update_order_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_order_request` when calling `v2_orders_sync_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_order_request' in local_var_params:
            body_params = local_var_params['update_order_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/v2/orders/sync', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Error',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
