# coding: utf-8

"""
    Zarban API

    API for Zarban services.  # noqa: E501

    The version of the OpenAPI document: 2.0.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from zarban.service.openapi_client.configuration import Configuration


class QuoteRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'request_id': 'str',
        'type': 'OrderType',
        'trade_type': 'TradeType',
        'input_token': 'str',
        'output_token': 'str',
        'amount': 'str',
        'recipient': 'str',
        'options': 'QuoteRequestOptions'
    }

    attribute_map = {
        'request_id': 'requestId',
        'type': 'type',
        'trade_type': 'tradeType',
        'input_token': 'inputToken',
        'output_token': 'outputToken',
        'amount': 'amount',
        'recipient': 'recipient',
        'options': 'options'
    }

    def __init__(self, request_id=None, type=None, trade_type=None, input_token=None, output_token=None, amount=None, recipient=None, options=None, local_vars_configuration=None):  # noqa: E501
        """QuoteRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._request_id = None
        self._type = None
        self._trade_type = None
        self._input_token = None
        self._output_token = None
        self._amount = None
        self._recipient = None
        self._options = None
        self.discriminator = None

        if request_id is not None:
            self.request_id = request_id
        if type is not None:
            self.type = type
        self.trade_type = trade_type
        self.input_token = input_token
        self.output_token = output_token
        self.amount = amount
        self.recipient = recipient
        if options is not None:
            self.options = options

    @property
    def request_id(self):
        """Gets the request_id of this QuoteRequest.  # noqa: E501


        :return: The request_id of this QuoteRequest.  # noqa: E501
        :rtype: str
        """
        return self._request_id

    @request_id.setter
    def request_id(self, request_id):
        """Sets the request_id of this QuoteRequest.


        :param request_id: The request_id of this QuoteRequest.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                request_id is not None and not re.search(r'^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[4][0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}$', request_id)):  # noqa: E501
            raise ValueError(r"Invalid value for `request_id`, must be a follow pattern or equal to `/^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[4][0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}$/`")  # noqa: E501

        self._request_id = request_id

    @property
    def type(self):
        """Gets the type of this QuoteRequest.  # noqa: E501


        :return: The type of this QuoteRequest.  # noqa: E501
        :rtype: OrderType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this QuoteRequest.


        :param type: The type of this QuoteRequest.  # noqa: E501
        :type: OrderType
        """

        self._type = type

    @property
    def trade_type(self):
        """Gets the trade_type of this QuoteRequest.  # noqa: E501


        :return: The trade_type of this QuoteRequest.  # noqa: E501
        :rtype: TradeType
        """
        return self._trade_type

    @trade_type.setter
    def trade_type(self, trade_type):
        """Sets the trade_type of this QuoteRequest.


        :param trade_type: The trade_type of this QuoteRequest.  # noqa: E501
        :type: TradeType
        """
        if self.local_vars_configuration.client_side_validation and trade_type is None:  # noqa: E501
            raise ValueError("Invalid value for `trade_type`, must not be `None`")  # noqa: E501

        self._trade_type = trade_type

    @property
    def input_token(self):
        """Gets the input_token of this QuoteRequest.  # noqa: E501


        :return: The input_token of this QuoteRequest.  # noqa: E501
        :rtype: str
        """
        return self._input_token

    @input_token.setter
    def input_token(self, input_token):
        """Sets the input_token of this QuoteRequest.


        :param input_token: The input_token of this QuoteRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and input_token is None:  # noqa: E501
            raise ValueError("Invalid value for `input_token`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                input_token is not None and not re.search(r'^(0x)?[0-9a-fA-F]{40}$', input_token)):  # noqa: E501
            raise ValueError(r"Invalid value for `input_token`, must be a follow pattern or equal to `/^(0x)?[0-9a-fA-F]{40}$/`")  # noqa: E501

        self._input_token = input_token

    @property
    def output_token(self):
        """Gets the output_token of this QuoteRequest.  # noqa: E501


        :return: The output_token of this QuoteRequest.  # noqa: E501
        :rtype: str
        """
        return self._output_token

    @output_token.setter
    def output_token(self, output_token):
        """Sets the output_token of this QuoteRequest.


        :param output_token: The output_token of this QuoteRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and output_token is None:  # noqa: E501
            raise ValueError("Invalid value for `output_token`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                output_token is not None and not re.search(r'^(0x)?[0-9a-fA-F]{40}$', output_token)):  # noqa: E501
            raise ValueError(r"Invalid value for `output_token`, must be a follow pattern or equal to `/^(0x)?[0-9a-fA-F]{40}$/`")  # noqa: E501

        self._output_token = output_token

    @property
    def amount(self):
        """Gets the amount of this QuoteRequest.  # noqa: E501


        :return: The amount of this QuoteRequest.  # noqa: E501
        :rtype: str
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this QuoteRequest.


        :param amount: The amount of this QuoteRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and amount is None:  # noqa: E501
            raise ValueError("Invalid value for `amount`, must not be `None`")  # noqa: E501

        self._amount = amount

    @property
    def recipient(self):
        """Gets the recipient of this QuoteRequest.  # noqa: E501


        :return: The recipient of this QuoteRequest.  # noqa: E501
        :rtype: str
        """
        return self._recipient

    @recipient.setter
    def recipient(self, recipient):
        """Sets the recipient of this QuoteRequest.


        :param recipient: The recipient of this QuoteRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and recipient is None:  # noqa: E501
            raise ValueError("Invalid value for `recipient`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                recipient is not None and not re.search(r'^(0x)?[0-9a-fA-F]{40}$', recipient)):  # noqa: E501
            raise ValueError(r"Invalid value for `recipient`, must be a follow pattern or equal to `/^(0x)?[0-9a-fA-F]{40}$/`")  # noqa: E501

        self._recipient = recipient

    @property
    def options(self):
        """Gets the options of this QuoteRequest.  # noqa: E501


        :return: The options of this QuoteRequest.  # noqa: E501
        :rtype: QuoteRequestOptions
        """
        return self._options

    @options.setter
    def options(self, options):
        """Sets the options of this QuoteRequest.


        :param options: The options of this QuoteRequest.  # noqa: E501
        :type: QuoteRequestOptions
        """

        self._options = options

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QuoteRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, QuoteRequest):
            return True

        return self.to_dict() != other.to_dict()
