# coding: utf-8

"""
    Zarban API

    API for Zarban services.  # noqa: E501

    The version of the OpenAPI document: 2.0.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from zarban.service.openapi_client.configuration import Configuration


class QuoteRequestOptions(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'dry_run': 'bool',
        'slippage_tolerance': 'str',
        'use_synthetic_quotes': 'bool',
        'permit_signature': 'str',
        'permit_nonce': 'str',
        'permit_expiration': 'int',
        'permit_amount': 'str',
        'permit_sig_deadline': 'int',
        'quote_id': 'str',
        'encoded_order': 'str'
    }

    attribute_map = {
        'dry_run': 'dryRun',
        'slippage_tolerance': 'slippageTolerance',
        'use_synthetic_quotes': 'useSyntheticQuotes',
        'permit_signature': 'permitSignature',
        'permit_nonce': 'permitNonce',
        'permit_expiration': 'permitExpiration',
        'permit_amount': 'permitAmount',
        'permit_sig_deadline': 'permitSigDeadline',
        'quote_id': 'quoteId',
        'encoded_order': 'encodedOrder'
    }

    def __init__(self, dry_run=False, slippage_tolerance='0.005', use_synthetic_quotes=False, permit_signature=None, permit_nonce=None, permit_expiration=None, permit_amount=None, permit_sig_deadline=None, quote_id=None, encoded_order=None, local_vars_configuration=None):  # noqa: E501
        """QuoteRequestOptions - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._dry_run = None
        self._slippage_tolerance = None
        self._use_synthetic_quotes = None
        self._permit_signature = None
        self._permit_nonce = None
        self._permit_expiration = None
        self._permit_amount = None
        self._permit_sig_deadline = None
        self._quote_id = None
        self._encoded_order = None
        self.discriminator = None

        if dry_run is not None:
            self.dry_run = dry_run
        if slippage_tolerance is not None:
            self.slippage_tolerance = slippage_tolerance
        if use_synthetic_quotes is not None:
            self.use_synthetic_quotes = use_synthetic_quotes
        if permit_signature is not None:
            self.permit_signature = permit_signature
        if permit_nonce is not None:
            self.permit_nonce = permit_nonce
        if permit_expiration is not None:
            self.permit_expiration = permit_expiration
        if permit_amount is not None:
            self.permit_amount = permit_amount
        if permit_sig_deadline is not None:
            self.permit_sig_deadline = permit_sig_deadline
        if quote_id is not None:
            self.quote_id = quote_id
        if encoded_order is not None:
            self.encoded_order = encoded_order

    @property
    def dry_run(self):
        """Gets the dry_run of this QuoteRequestOptions.  # noqa: E501


        :return: The dry_run of this QuoteRequestOptions.  # noqa: E501
        :rtype: bool
        """
        return self._dry_run

    @dry_run.setter
    def dry_run(self, dry_run):
        """Sets the dry_run of this QuoteRequestOptions.


        :param dry_run: The dry_run of this QuoteRequestOptions.  # noqa: E501
        :type: bool
        """

        self._dry_run = dry_run

    @property
    def slippage_tolerance(self):
        """Gets the slippage_tolerance of this QuoteRequestOptions.  # noqa: E501


        :return: The slippage_tolerance of this QuoteRequestOptions.  # noqa: E501
        :rtype: str
        """
        return self._slippage_tolerance

    @slippage_tolerance.setter
    def slippage_tolerance(self, slippage_tolerance):
        """Sets the slippage_tolerance of this QuoteRequestOptions.


        :param slippage_tolerance: The slippage_tolerance of this QuoteRequestOptions.  # noqa: E501
        :type: str
        """

        self._slippage_tolerance = slippage_tolerance

    @property
    def use_synthetic_quotes(self):
        """Gets the use_synthetic_quotes of this QuoteRequestOptions.  # noqa: E501


        :return: The use_synthetic_quotes of this QuoteRequestOptions.  # noqa: E501
        :rtype: bool
        """
        return self._use_synthetic_quotes

    @use_synthetic_quotes.setter
    def use_synthetic_quotes(self, use_synthetic_quotes):
        """Sets the use_synthetic_quotes of this QuoteRequestOptions.


        :param use_synthetic_quotes: The use_synthetic_quotes of this QuoteRequestOptions.  # noqa: E501
        :type: bool
        """

        self._use_synthetic_quotes = use_synthetic_quotes

    @property
    def permit_signature(self):
        """Gets the permit_signature of this QuoteRequestOptions.  # noqa: E501


        :return: The permit_signature of this QuoteRequestOptions.  # noqa: E501
        :rtype: str
        """
        return self._permit_signature

    @permit_signature.setter
    def permit_signature(self, permit_signature):
        """Sets the permit_signature of this QuoteRequestOptions.


        :param permit_signature: The permit_signature of this QuoteRequestOptions.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                permit_signature is not None and not re.search(r'^(0x)?[0-9a-fA-F]{130}$', permit_signature)):  # noqa: E501
            raise ValueError(r"Invalid value for `permit_signature`, must be a follow pattern or equal to `/^(0x)?[0-9a-fA-F]{130}$/`")  # noqa: E501

        self._permit_signature = permit_signature

    @property
    def permit_nonce(self):
        """Gets the permit_nonce of this QuoteRequestOptions.  # noqa: E501


        :return: The permit_nonce of this QuoteRequestOptions.  # noqa: E501
        :rtype: str
        """
        return self._permit_nonce

    @permit_nonce.setter
    def permit_nonce(self, permit_nonce):
        """Sets the permit_nonce of this QuoteRequestOptions.


        :param permit_nonce: The permit_nonce of this QuoteRequestOptions.  # noqa: E501
        :type: str
        """

        self._permit_nonce = permit_nonce

    @property
    def permit_expiration(self):
        """Gets the permit_expiration of this QuoteRequestOptions.  # noqa: E501


        :return: The permit_expiration of this QuoteRequestOptions.  # noqa: E501
        :rtype: int
        """
        return self._permit_expiration

    @permit_expiration.setter
    def permit_expiration(self, permit_expiration):
        """Sets the permit_expiration of this QuoteRequestOptions.


        :param permit_expiration: The permit_expiration of this QuoteRequestOptions.  # noqa: E501
        :type: int
        """

        self._permit_expiration = permit_expiration

    @property
    def permit_amount(self):
        """Gets the permit_amount of this QuoteRequestOptions.  # noqa: E501


        :return: The permit_amount of this QuoteRequestOptions.  # noqa: E501
        :rtype: str
        """
        return self._permit_amount

    @permit_amount.setter
    def permit_amount(self, permit_amount):
        """Sets the permit_amount of this QuoteRequestOptions.


        :param permit_amount: The permit_amount of this QuoteRequestOptions.  # noqa: E501
        :type: str
        """

        self._permit_amount = permit_amount

    @property
    def permit_sig_deadline(self):
        """Gets the permit_sig_deadline of this QuoteRequestOptions.  # noqa: E501


        :return: The permit_sig_deadline of this QuoteRequestOptions.  # noqa: E501
        :rtype: int
        """
        return self._permit_sig_deadline

    @permit_sig_deadline.setter
    def permit_sig_deadline(self, permit_sig_deadline):
        """Sets the permit_sig_deadline of this QuoteRequestOptions.


        :param permit_sig_deadline: The permit_sig_deadline of this QuoteRequestOptions.  # noqa: E501
        :type: int
        """

        self._permit_sig_deadline = permit_sig_deadline

    @property
    def quote_id(self):
        """Gets the quote_id of this QuoteRequestOptions.  # noqa: E501


        :return: The quote_id of this QuoteRequestOptions.  # noqa: E501
        :rtype: str
        """
        return self._quote_id

    @quote_id.setter
    def quote_id(self, quote_id):
        """Sets the quote_id of this QuoteRequestOptions.


        :param quote_id: The quote_id of this QuoteRequestOptions.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                quote_id is not None and not re.search(r'^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[4][0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}$', quote_id)):  # noqa: E501
            raise ValueError(r"Invalid value for `quote_id`, must be a follow pattern or equal to `/^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[4][0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}$/`")  # noqa: E501

        self._quote_id = quote_id

    @property
    def encoded_order(self):
        """Gets the encoded_order of this QuoteRequestOptions.  # noqa: E501


        :return: The encoded_order of this QuoteRequestOptions.  # noqa: E501
        :rtype: str
        """
        return self._encoded_order

    @encoded_order.setter
    def encoded_order(self, encoded_order):
        """Sets the encoded_order of this QuoteRequestOptions.


        :param encoded_order: The encoded_order of this QuoteRequestOptions.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                encoded_order is not None and not re.search(r'^(0x)?[0-9a-fA-F]*$', encoded_order)):  # noqa: E501
            raise ValueError(r"Invalid value for `encoded_order`, must be a follow pattern or equal to `/^(0x)?[0-9a-fA-F]*$/`")  # noqa: E501

        self._encoded_order = encoded_order

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QuoteRequestOptions):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, QuoteRequestOptions):
            return True

        return self.to_dict() != other.to_dict()
