# coding: utf-8

"""
    Zarban API

    API for Zarban services.  # noqa: E501

    The version of the OpenAPI document: 2.0.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from zarban.service.openapi_client.configuration import Configuration


class QuoteResponse(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'type': 'OrderType',
        'trade_type': 'TradeType',
        'time': 'Timestamp',
        'amount': 'dict(str, str)',
        'quote': 'dict(str, str)',
        'quote_id': 'str',
        'gas_price': 'dict(str, str)',
        'gas_use_estimate': 'int',
        'gas_fee_estimate': 'dict(str, str)',
        'route_string': 'str',
        'method_parameters': 'MethodParameters',
        'route': 'list[V3PoolInRoute]',
        'order_info': 'OrderInfo',
        'encoded_order': 'str',
        'order_hash': 'str',
        'permit_data': 'TypedData'
    }

    attribute_map = {
        'type': 'type',
        'trade_type': 'tradeType',
        'time': 'time',
        'amount': 'amount',
        'quote': 'quote',
        'quote_id': 'quoteId',
        'gas_price': 'gasPrice',
        'gas_use_estimate': 'gasUseEstimate',
        'gas_fee_estimate': 'gasFeeEstimate',
        'route_string': 'routeString',
        'method_parameters': 'methodParameters',
        'route': 'route',
        'order_info': 'orderInfo',
        'encoded_order': 'encodedOrder',
        'order_hash': 'orderHash',
        'permit_data': 'permitData'
    }

    def __init__(self, type=None, trade_type=None, time=None, amount=None, quote=None, quote_id=None, gas_price=None, gas_use_estimate=None, gas_fee_estimate=None, route_string=None, method_parameters=None, route=None, order_info=None, encoded_order=None, order_hash=None, permit_data=None, local_vars_configuration=None):  # noqa: E501
        """QuoteResponse - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._type = None
        self._trade_type = None
        self._time = None
        self._amount = None
        self._quote = None
        self._quote_id = None
        self._gas_price = None
        self._gas_use_estimate = None
        self._gas_fee_estimate = None
        self._route_string = None
        self._method_parameters = None
        self._route = None
        self._order_info = None
        self._encoded_order = None
        self._order_hash = None
        self._permit_data = None
        self.discriminator = None

        self.type = type
        self.trade_type = trade_type
        self.time = time
        self.amount = amount
        self.quote = quote
        self.quote_id = quote_id
        self.gas_price = gas_price
        self.gas_use_estimate = gas_use_estimate
        self.gas_fee_estimate = gas_fee_estimate
        self.route_string = route_string
        if method_parameters is not None:
            self.method_parameters = method_parameters
        self.route = route
        if order_info is not None:
            self.order_info = order_info
        if encoded_order is not None:
            self.encoded_order = encoded_order
        if order_hash is not None:
            self.order_hash = order_hash
        if permit_data is not None:
            self.permit_data = permit_data

    @property
    def type(self):
        """Gets the type of this QuoteResponse.  # noqa: E501


        :return: The type of this QuoteResponse.  # noqa: E501
        :rtype: OrderType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this QuoteResponse.


        :param type: The type of this QuoteResponse.  # noqa: E501
        :type: OrderType
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def trade_type(self):
        """Gets the trade_type of this QuoteResponse.  # noqa: E501


        :return: The trade_type of this QuoteResponse.  # noqa: E501
        :rtype: TradeType
        """
        return self._trade_type

    @trade_type.setter
    def trade_type(self, trade_type):
        """Sets the trade_type of this QuoteResponse.


        :param trade_type: The trade_type of this QuoteResponse.  # noqa: E501
        :type: TradeType
        """
        if self.local_vars_configuration.client_side_validation and trade_type is None:  # noqa: E501
            raise ValueError("Invalid value for `trade_type`, must not be `None`")  # noqa: E501

        self._trade_type = trade_type

    @property
    def time(self):
        """Gets the time of this QuoteResponse.  # noqa: E501


        :return: The time of this QuoteResponse.  # noqa: E501
        :rtype: Timestamp
        """
        return self._time

    @time.setter
    def time(self, time):
        """Sets the time of this QuoteResponse.


        :param time: The time of this QuoteResponse.  # noqa: E501
        :type: Timestamp
        """
        if self.local_vars_configuration.client_side_validation and time is None:  # noqa: E501
            raise ValueError("Invalid value for `time`, must not be `None`")  # noqa: E501

        self._time = time

    @property
    def amount(self):
        """Gets the amount of this QuoteResponse.  # noqa: E501


        :return: The amount of this QuoteResponse.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this QuoteResponse.


        :param amount: The amount of this QuoteResponse.  # noqa: E501
        :type: dict(str, str)
        """
        if self.local_vars_configuration.client_side_validation and amount is None:  # noqa: E501
            raise ValueError("Invalid value for `amount`, must not be `None`")  # noqa: E501

        self._amount = amount

    @property
    def quote(self):
        """Gets the quote of this QuoteResponse.  # noqa: E501


        :return: The quote of this QuoteResponse.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._quote

    @quote.setter
    def quote(self, quote):
        """Sets the quote of this QuoteResponse.


        :param quote: The quote of this QuoteResponse.  # noqa: E501
        :type: dict(str, str)
        """
        if self.local_vars_configuration.client_side_validation and quote is None:  # noqa: E501
            raise ValueError("Invalid value for `quote`, must not be `None`")  # noqa: E501

        self._quote = quote

    @property
    def quote_id(self):
        """Gets the quote_id of this QuoteResponse.  # noqa: E501


        :return: The quote_id of this QuoteResponse.  # noqa: E501
        :rtype: str
        """
        return self._quote_id

    @quote_id.setter
    def quote_id(self, quote_id):
        """Sets the quote_id of this QuoteResponse.


        :param quote_id: The quote_id of this QuoteResponse.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and quote_id is None:  # noqa: E501
            raise ValueError("Invalid value for `quote_id`, must not be `None`")  # noqa: E501

        self._quote_id = quote_id

    @property
    def gas_price(self):
        """Gets the gas_price of this QuoteResponse.  # noqa: E501


        :return: The gas_price of this QuoteResponse.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._gas_price

    @gas_price.setter
    def gas_price(self, gas_price):
        """Sets the gas_price of this QuoteResponse.


        :param gas_price: The gas_price of this QuoteResponse.  # noqa: E501
        :type: dict(str, str)
        """
        if self.local_vars_configuration.client_side_validation and gas_price is None:  # noqa: E501
            raise ValueError("Invalid value for `gas_price`, must not be `None`")  # noqa: E501

        self._gas_price = gas_price

    @property
    def gas_use_estimate(self):
        """Gets the gas_use_estimate of this QuoteResponse.  # noqa: E501


        :return: The gas_use_estimate of this QuoteResponse.  # noqa: E501
        :rtype: int
        """
        return self._gas_use_estimate

    @gas_use_estimate.setter
    def gas_use_estimate(self, gas_use_estimate):
        """Sets the gas_use_estimate of this QuoteResponse.


        :param gas_use_estimate: The gas_use_estimate of this QuoteResponse.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and gas_use_estimate is None:  # noqa: E501
            raise ValueError("Invalid value for `gas_use_estimate`, must not be `None`")  # noqa: E501

        self._gas_use_estimate = gas_use_estimate

    @property
    def gas_fee_estimate(self):
        """Gets the gas_fee_estimate of this QuoteResponse.  # noqa: E501


        :return: The gas_fee_estimate of this QuoteResponse.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._gas_fee_estimate

    @gas_fee_estimate.setter
    def gas_fee_estimate(self, gas_fee_estimate):
        """Sets the gas_fee_estimate of this QuoteResponse.


        :param gas_fee_estimate: The gas_fee_estimate of this QuoteResponse.  # noqa: E501
        :type: dict(str, str)
        """
        if self.local_vars_configuration.client_side_validation and gas_fee_estimate is None:  # noqa: E501
            raise ValueError("Invalid value for `gas_fee_estimate`, must not be `None`")  # noqa: E501

        self._gas_fee_estimate = gas_fee_estimate

    @property
    def route_string(self):
        """Gets the route_string of this QuoteResponse.  # noqa: E501


        :return: The route_string of this QuoteResponse.  # noqa: E501
        :rtype: str
        """
        return self._route_string

    @route_string.setter
    def route_string(self, route_string):
        """Sets the route_string of this QuoteResponse.


        :param route_string: The route_string of this QuoteResponse.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and route_string is None:  # noqa: E501
            raise ValueError("Invalid value for `route_string`, must not be `None`")  # noqa: E501

        self._route_string = route_string

    @property
    def method_parameters(self):
        """Gets the method_parameters of this QuoteResponse.  # noqa: E501


        :return: The method_parameters of this QuoteResponse.  # noqa: E501
        :rtype: MethodParameters
        """
        return self._method_parameters

    @method_parameters.setter
    def method_parameters(self, method_parameters):
        """Sets the method_parameters of this QuoteResponse.


        :param method_parameters: The method_parameters of this QuoteResponse.  # noqa: E501
        :type: MethodParameters
        """

        self._method_parameters = method_parameters

    @property
    def route(self):
        """Gets the route of this QuoteResponse.  # noqa: E501


        :return: The route of this QuoteResponse.  # noqa: E501
        :rtype: list[V3PoolInRoute]
        """
        return self._route

    @route.setter
    def route(self, route):
        """Sets the route of this QuoteResponse.


        :param route: The route of this QuoteResponse.  # noqa: E501
        :type: list[V3PoolInRoute]
        """
        if self.local_vars_configuration.client_side_validation and route is None:  # noqa: E501
            raise ValueError("Invalid value for `route`, must not be `None`")  # noqa: E501

        self._route = route

    @property
    def order_info(self):
        """Gets the order_info of this QuoteResponse.  # noqa: E501


        :return: The order_info of this QuoteResponse.  # noqa: E501
        :rtype: OrderInfo
        """
        return self._order_info

    @order_info.setter
    def order_info(self, order_info):
        """Sets the order_info of this QuoteResponse.


        :param order_info: The order_info of this QuoteResponse.  # noqa: E501
        :type: OrderInfo
        """

        self._order_info = order_info

    @property
    def encoded_order(self):
        """Gets the encoded_order of this QuoteResponse.  # noqa: E501


        :return: The encoded_order of this QuoteResponse.  # noqa: E501
        :rtype: str
        """
        return self._encoded_order

    @encoded_order.setter
    def encoded_order(self, encoded_order):
        """Sets the encoded_order of this QuoteResponse.


        :param encoded_order: The encoded_order of this QuoteResponse.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                encoded_order is not None and not re.search(r'^(0x)?[0-9a-fA-F]*$', encoded_order)):  # noqa: E501
            raise ValueError(r"Invalid value for `encoded_order`, must be a follow pattern or equal to `/^(0x)?[0-9a-fA-F]*$/`")  # noqa: E501

        self._encoded_order = encoded_order

    @property
    def order_hash(self):
        """Gets the order_hash of this QuoteResponse.  # noqa: E501


        :return: The order_hash of this QuoteResponse.  # noqa: E501
        :rtype: str
        """
        return self._order_hash

    @order_hash.setter
    def order_hash(self, order_hash):
        """Sets the order_hash of this QuoteResponse.


        :param order_hash: The order_hash of this QuoteResponse.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                order_hash is not None and not re.search(r'^(0x)?[0-9a-fA-F]{64}$', order_hash)):  # noqa: E501
            raise ValueError(r"Invalid value for `order_hash`, must be a follow pattern or equal to `/^(0x)?[0-9a-fA-F]{64}$/`")  # noqa: E501

        self._order_hash = order_hash

    @property
    def permit_data(self):
        """Gets the permit_data of this QuoteResponse.  # noqa: E501


        :return: The permit_data of this QuoteResponse.  # noqa: E501
        :rtype: TypedData
        """
        return self._permit_data

    @permit_data.setter
    def permit_data(self, permit_data):
        """Sets the permit_data of this QuoteResponse.


        :param permit_data: The permit_data of this QuoteResponse.  # noqa: E501
        :type: TypedData
        """

        self._permit_data = permit_data

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QuoteResponse):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, QuoteResponse):
            return True

        return self.to_dict() != other.to_dict()
