# coding: utf-8

"""
    Zarban API

    API for Zarban services.  # noqa: E501

    The version of the OpenAPI document: 2.0.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from zarban.service.openapi_client.configuration import Configuration


class StablecoinSystemTakeTxRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'user': 'str',
        'auction_id': 'int',
        'ilk': 'str',
        'collateral_amount_upper_limit': 'str',
        'max_acceptable_price': 'str'
    }

    attribute_map = {
        'user': 'user',
        'auction_id': 'auctionId',
        'ilk': 'ilk',
        'collateral_amount_upper_limit': 'collateralAmountUpperLimit',
        'max_acceptable_price': 'maxAcceptablePrice'
    }

    def __init__(self, user=None, auction_id=None, ilk=None, collateral_amount_upper_limit=None, max_acceptable_price=None, local_vars_configuration=None):  # noqa: E501
        """StablecoinSystemTakeTxRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._user = None
        self._auction_id = None
        self._ilk = None
        self._collateral_amount_upper_limit = None
        self._max_acceptable_price = None
        self.discriminator = None

        self.user = user
        self.auction_id = auction_id
        self.ilk = ilk
        self.collateral_amount_upper_limit = collateral_amount_upper_limit
        self.max_acceptable_price = max_acceptable_price

    @property
    def user(self):
        """Gets the user of this StablecoinSystemTakeTxRequest.  # noqa: E501

        Ethereum address of the user taking the auction.  # noqa: E501

        :return: The user of this StablecoinSystemTakeTxRequest.  # noqa: E501
        :rtype: str
        """
        return self._user

    @user.setter
    def user(self, user):
        """Sets the user of this StablecoinSystemTakeTxRequest.

        Ethereum address of the user taking the auction.  # noqa: E501

        :param user: The user of this StablecoinSystemTakeTxRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and user is None:  # noqa: E501
            raise ValueError("Invalid value for `user`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                user is not None and not re.search(r'0x[a-fA-F0-9]{40}', user)):  # noqa: E501
            raise ValueError(r"Invalid value for `user`, must be a follow pattern or equal to `/0x[a-fA-F0-9]{40}/`")  # noqa: E501

        self._user = user

    @property
    def auction_id(self):
        """Gets the auction_id of this StablecoinSystemTakeTxRequest.  # noqa: E501

        The ID of the auction  # noqa: E501

        :return: The auction_id of this StablecoinSystemTakeTxRequest.  # noqa: E501
        :rtype: int
        """
        return self._auction_id

    @auction_id.setter
    def auction_id(self, auction_id):
        """Sets the auction_id of this StablecoinSystemTakeTxRequest.

        The ID of the auction  # noqa: E501

        :param auction_id: The auction_id of this StablecoinSystemTakeTxRequest.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and auction_id is None:  # noqa: E501
            raise ValueError("Invalid value for `auction_id`, must not be `None`")  # noqa: E501

        self._auction_id = auction_id

    @property
    def ilk(self):
        """Gets the ilk of this StablecoinSystemTakeTxRequest.  # noqa: E501

        Name of the ILK  # noqa: E501

        :return: The ilk of this StablecoinSystemTakeTxRequest.  # noqa: E501
        :rtype: str
        """
        return self._ilk

    @ilk.setter
    def ilk(self, ilk):
        """Sets the ilk of this StablecoinSystemTakeTxRequest.

        Name of the ILK  # noqa: E501

        :param ilk: The ilk of this StablecoinSystemTakeTxRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and ilk is None:  # noqa: E501
            raise ValueError("Invalid value for `ilk`, must not be `None`")  # noqa: E501

        self._ilk = ilk

    @property
    def collateral_amount_upper_limit(self):
        """Gets the collateral_amount_upper_limit of this StablecoinSystemTakeTxRequest.  # noqa: E501

        upper limit on the amount of collateral to buy [wad]  # noqa: E501

        :return: The collateral_amount_upper_limit of this StablecoinSystemTakeTxRequest.  # noqa: E501
        :rtype: str
        """
        return self._collateral_amount_upper_limit

    @collateral_amount_upper_limit.setter
    def collateral_amount_upper_limit(self, collateral_amount_upper_limit):
        """Sets the collateral_amount_upper_limit of this StablecoinSystemTakeTxRequest.

        upper limit on the amount of collateral to buy [wad]  # noqa: E501

        :param collateral_amount_upper_limit: The collateral_amount_upper_limit of this StablecoinSystemTakeTxRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and collateral_amount_upper_limit is None:  # noqa: E501
            raise ValueError("Invalid value for `collateral_amount_upper_limit`, must not be `None`")  # noqa: E501

        self._collateral_amount_upper_limit = collateral_amount_upper_limit

    @property
    def max_acceptable_price(self):
        """Gets the max_acceptable_price of this StablecoinSystemTakeTxRequest.  # noqa: E501

        Maximum acceptable price (ZAR / collateral) [ray]  # noqa: E501

        :return: The max_acceptable_price of this StablecoinSystemTakeTxRequest.  # noqa: E501
        :rtype: str
        """
        return self._max_acceptable_price

    @max_acceptable_price.setter
    def max_acceptable_price(self, max_acceptable_price):
        """Sets the max_acceptable_price of this StablecoinSystemTakeTxRequest.

        Maximum acceptable price (ZAR / collateral) [ray]  # noqa: E501

        :param max_acceptable_price: The max_acceptable_price of this StablecoinSystemTakeTxRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and max_acceptable_price is None:  # noqa: E501
            raise ValueError("Invalid value for `max_acceptable_price`, must not be `None`")  # noqa: E501

        self._max_acceptable_price = max_acceptable_price

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, StablecoinSystemTakeTxRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, StablecoinSystemTakeTxRequest):
            return True

        return self.to_dict() != other.to_dict()
