# coding: utf-8

"""
    Zarban Wallet API

    API for Zarban wallet services.  # noqa: E501

    The version of the OpenAPI document: 2.0.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from zarban.wallet.openapi_client.configuration import Configuration


class LoanPlan(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'min_collateralization_ratio': 'str',
        'acceptable_coins': 'list[Coin]',
        'fee': 'str',
        'max_debt': 'dict(str, str)',
        'min_debt': 'dict(str, str)',
        'loan_to_value_options': 'list[DetailedLoanToValueOptions]'
    }

    attribute_map = {
        'name': 'name',
        'min_collateralization_ratio': 'minCollateralizationRatio',
        'acceptable_coins': 'acceptableCoins',
        'fee': 'fee',
        'max_debt': 'maxDebt',
        'min_debt': 'minDebt',
        'loan_to_value_options': 'loanToValueOptions'
    }

    def __init__(self, name=None, min_collateralization_ratio=None, acceptable_coins=None, fee=None, max_debt=None, min_debt=None, loan_to_value_options=None, local_vars_configuration=None):  # noqa: E501
        """LoanPlan - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._min_collateralization_ratio = None
        self._acceptable_coins = None
        self._fee = None
        self._max_debt = None
        self._min_debt = None
        self._loan_to_value_options = None
        self.discriminator = None

        self.name = name
        self.min_collateralization_ratio = min_collateralization_ratio
        self.acceptable_coins = acceptable_coins
        self.fee = fee
        self.max_debt = max_debt
        self.min_debt = min_debt
        self.loan_to_value_options = loan_to_value_options

    @property
    def name(self):
        """Gets the name of this LoanPlan.  # noqa: E501

        The name of the loan plan  # noqa: E501

        :return: The name of this LoanPlan.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this LoanPlan.

        The name of the loan plan  # noqa: E501

        :param name: The name of this LoanPlan.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def min_collateralization_ratio(self):
        """Gets the min_collateralization_ratio of this LoanPlan.  # noqa: E501

        The minimum collateralization ratio of the loan plan  # noqa: E501

        :return: The min_collateralization_ratio of this LoanPlan.  # noqa: E501
        :rtype: str
        """
        return self._min_collateralization_ratio

    @min_collateralization_ratio.setter
    def min_collateralization_ratio(self, min_collateralization_ratio):
        """Sets the min_collateralization_ratio of this LoanPlan.

        The minimum collateralization ratio of the loan plan  # noqa: E501

        :param min_collateralization_ratio: The min_collateralization_ratio of this LoanPlan.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and min_collateralization_ratio is None:  # noqa: E501
            raise ValueError("Invalid value for `min_collateralization_ratio`, must not be `None`")  # noqa: E501

        self._min_collateralization_ratio = min_collateralization_ratio

    @property
    def acceptable_coins(self):
        """Gets the acceptable_coins of this LoanPlan.  # noqa: E501


        :return: The acceptable_coins of this LoanPlan.  # noqa: E501
        :rtype: list[Coin]
        """
        return self._acceptable_coins

    @acceptable_coins.setter
    def acceptable_coins(self, acceptable_coins):
        """Sets the acceptable_coins of this LoanPlan.


        :param acceptable_coins: The acceptable_coins of this LoanPlan.  # noqa: E501
        :type: list[Coin]
        """
        if self.local_vars_configuration.client_side_validation and acceptable_coins is None:  # noqa: E501
            raise ValueError("Invalid value for `acceptable_coins`, must not be `None`")  # noqa: E501

        self._acceptable_coins = acceptable_coins

    @property
    def fee(self):
        """Gets the fee of this LoanPlan.  # noqa: E501

        The annual fee of the loan plan  # noqa: E501

        :return: The fee of this LoanPlan.  # noqa: E501
        :rtype: str
        """
        return self._fee

    @fee.setter
    def fee(self, fee):
        """Sets the fee of this LoanPlan.

        The annual fee of the loan plan  # noqa: E501

        :param fee: The fee of this LoanPlan.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and fee is None:  # noqa: E501
            raise ValueError("Invalid value for `fee`, must not be `None`")  # noqa: E501

        self._fee = fee

    @property
    def max_debt(self):
        """Gets the max_debt of this LoanPlan.  # noqa: E501


        :return: The max_debt of this LoanPlan.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._max_debt

    @max_debt.setter
    def max_debt(self, max_debt):
        """Sets the max_debt of this LoanPlan.


        :param max_debt: The max_debt of this LoanPlan.  # noqa: E501
        :type: dict(str, str)
        """
        if self.local_vars_configuration.client_side_validation and max_debt is None:  # noqa: E501
            raise ValueError("Invalid value for `max_debt`, must not be `None`")  # noqa: E501

        self._max_debt = max_debt

    @property
    def min_debt(self):
        """Gets the min_debt of this LoanPlan.  # noqa: E501


        :return: The min_debt of this LoanPlan.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._min_debt

    @min_debt.setter
    def min_debt(self, min_debt):
        """Sets the min_debt of this LoanPlan.


        :param min_debt: The min_debt of this LoanPlan.  # noqa: E501
        :type: dict(str, str)
        """
        if self.local_vars_configuration.client_side_validation and min_debt is None:  # noqa: E501
            raise ValueError("Invalid value for `min_debt`, must not be `None`")  # noqa: E501

        self._min_debt = min_debt

    @property
    def loan_to_value_options(self):
        """Gets the loan_to_value_options of this LoanPlan.  # noqa: E501


        :return: The loan_to_value_options of this LoanPlan.  # noqa: E501
        :rtype: list[DetailedLoanToValueOptions]
        """
        return self._loan_to_value_options

    @loan_to_value_options.setter
    def loan_to_value_options(self, loan_to_value_options):
        """Sets the loan_to_value_options of this LoanPlan.


        :param loan_to_value_options: The loan_to_value_options of this LoanPlan.  # noqa: E501
        :type: list[DetailedLoanToValueOptions]
        """
        if self.local_vars_configuration.client_side_validation and loan_to_value_options is None:  # noqa: E501
            raise ValueError("Invalid value for `loan_to_value_options`, must not be `None`")  # noqa: E501

        self._loan_to_value_options = loan_to_value_options

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LoanPlan):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, LoanPlan):
            return True

        return self.to_dict() != other.to_dict()
