# coding: utf-8

"""
    Zarban Wallet API

    API for Zarban wallet services.  # noqa: E501

    The version of the OpenAPI document: 2.0.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from zarban.wallet.openapi_client.configuration import Configuration


class SwapRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'intent': 'str',
        'quote_id': 'str',
        'trade_type': 'str',
        '_in': 'str',
        'out': 'str',
        'amount': 'str'
    }

    attribute_map = {
        'intent': 'intent',
        'quote_id': 'quoteId',
        'trade_type': 'tradeType',
        '_in': 'in',
        'out': 'out',
        'amount': 'amount'
    }

    def __init__(self, intent=None, quote_id=None, trade_type=None, _in=None, out=None, amount=None, local_vars_configuration=None):  # noqa: E501
        """SwapRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._intent = None
        self._quote_id = None
        self._trade_type = None
        self.__in = None
        self._out = None
        self._amount = None
        self.discriminator = None

        self.intent = intent
        if quote_id is not None:
            self.quote_id = quote_id
        if trade_type is not None:
            self.trade_type = trade_type
        if _in is not None:
            self._in = _in
        if out is not None:
            self.out = out
        if amount is not None:
            self.amount = amount

    @property
    def intent(self):
        """Gets the intent of this SwapRequest.  # noqa: E501

        Intent to swap  # noqa: E501

        :return: The intent of this SwapRequest.  # noqa: E501
        :rtype: str
        """
        return self._intent

    @intent.setter
    def intent(self, intent):
        """Sets the intent of this SwapRequest.

        Intent to swap  # noqa: E501

        :param intent: The intent of this SwapRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and intent is None:  # noqa: E501
            raise ValueError("Invalid value for `intent`, must not be `None`")  # noqa: E501
        allowed_values = ["Swap", "Quote", "Preview"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and intent not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `intent` ({0}), must be one of {1}"  # noqa: E501
                .format(intent, allowed_values)
            )

        self._intent = intent

    @property
    def quote_id(self):
        """Gets the quote_id of this SwapRequest.  # noqa: E501

        Quote ID, required if intent is Swap  # noqa: E501

        :return: The quote_id of this SwapRequest.  # noqa: E501
        :rtype: str
        """
        return self._quote_id

    @quote_id.setter
    def quote_id(self, quote_id):
        """Sets the quote_id of this SwapRequest.

        Quote ID, required if intent is Swap  # noqa: E501

        :param quote_id: The quote_id of this SwapRequest.  # noqa: E501
        :type: str
        """

        self._quote_id = quote_id

    @property
    def trade_type(self):
        """Gets the trade_type of this SwapRequest.  # noqa: E501

        Trade type  # noqa: E501

        :return: The trade_type of this SwapRequest.  # noqa: E501
        :rtype: str
        """
        return self._trade_type

    @trade_type.setter
    def trade_type(self, trade_type):
        """Sets the trade_type of this SwapRequest.

        Trade type  # noqa: E501

        :param trade_type: The trade_type of this SwapRequest.  # noqa: E501
        :type: str
        """
        allowed_values = ["ExactInput", "ExactOutput"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and trade_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `trade_type` ({0}), must be one of {1}"  # noqa: E501
                .format(trade_type, allowed_values)
            )

        self._trade_type = trade_type

    @property
    def _in(self):
        """Gets the _in of this SwapRequest.  # noqa: E501

        Coin symbol to swap from  # noqa: E501

        :return: The _in of this SwapRequest.  # noqa: E501
        :rtype: str
        """
        return self.__in

    @_in.setter
    def _in(self, _in):
        """Sets the _in of this SwapRequest.

        Coin symbol to swap from  # noqa: E501

        :param _in: The _in of this SwapRequest.  # noqa: E501
        :type: str
        """

        self.__in = _in

    @property
    def out(self):
        """Gets the out of this SwapRequest.  # noqa: E501

        Coin symbol to swap to  # noqa: E501

        :return: The out of this SwapRequest.  # noqa: E501
        :rtype: str
        """
        return self._out

    @out.setter
    def out(self, out):
        """Sets the out of this SwapRequest.

        Coin symbol to swap to  # noqa: E501

        :param out: The out of this SwapRequest.  # noqa: E501
        :type: str
        """

        self._out = out

    @property
    def amount(self):
        """Gets the amount of this SwapRequest.  # noqa: E501

        Amount to swap  # noqa: E501

        :return: The amount of this SwapRequest.  # noqa: E501
        :rtype: str
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this SwapRequest.

        Amount to swap  # noqa: E501

        :param amount: The amount of this SwapRequest.  # noqa: E501
        :type: str
        """

        self._amount = amount

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SwapRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SwapRequest):
            return True

        return self.to_dict() != other.to_dict()
